"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cognito_1 = require("monocdk/aws-cognito");
const common_1 = require("../../../common");
/**
 * Cognito identity pools do not allow for unauthenticated logins without a valid reason
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cognito_1.CfnIdentityPool) {
        const allowUnauthenticatedIdentities = common_1.resolveIfPrimitive(node, node.allowUnauthenticatedIdentities);
        if (allowUnauthenticatedIdentities) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ09HNy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvc2VjdXJpdHlfYW5kX2NvbXBsaWFuY2UvQ09HNy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLHFEQUFzRDtBQUN0RCw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDZCQUFlLEVBQUU7UUFDbkMsTUFBTSw4QkFBOEIsR0FBRywyQkFBa0IsQ0FDdkQsSUFBSSxFQUNKLElBQUksQ0FBQyw4QkFBOEIsQ0FDcEMsQ0FBQztRQUNGLElBQUksOEJBQThCLEVBQUU7WUFDbEMsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBWEQsNEJBV0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5JZGVudGl0eVBvb2wgfSBmcm9tICdtb25vY2RrL2F3cy1jb2duaXRvJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL2NvbW1vbic7XG5cbi8qKlxuICogQ29nbml0byBpZGVudGl0eSBwb29scyBkbyBub3QgYWxsb3cgZm9yIHVuYXV0aGVudGljYXRlZCBsb2dpbnMgd2l0aG91dCBhIHZhbGlkIHJlYXNvblxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbklkZW50aXR5UG9vbCkge1xuICAgIGNvbnN0IGFsbG93VW5hdXRoZW50aWNhdGVkSWRlbnRpdGllcyA9IHJlc29sdmVJZlByaW1pdGl2ZShcbiAgICAgIG5vZGUsXG4gICAgICBub2RlLmFsbG93VW5hdXRoZW50aWNhdGVkSWRlbnRpdGllcyxcbiAgICApO1xuICAgIGlmIChhbGxvd1VuYXV0aGVudGljYXRlZElkZW50aXRpZXMpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=