"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cloudfront_1 = require("monocdk/aws-cloudfront");
const common_1 = require("../../../common");
/**
 * CloudFront distributions do not use SSLv3 or TLSv1 for communication to the origin
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudfront_1.CfnDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.distributionConfig);
        if (distributionConfig.origins != undefined) {
            const origins = monocdk_1.Stack.of(node).resolve(distributionConfig.origins);
            for (const origin of origins) {
                const resolvedOrigin = monocdk_1.Stack.of(node).resolve(origin);
                if (resolvedOrigin.customOriginConfig != undefined) {
                    const customOriginConfig = monocdk_1.Stack.of(node).resolve(resolvedOrigin.customOriginConfig);
                    const originProtocolPolicy = common_1.resolveIfPrimitive(node, customOriginConfig.originProtocolPolicy);
                    if (originProtocolPolicy != aws_cloudfront_1.OriginProtocolPolicy.HTTPS_ONLY) {
                        return false;
                    }
                    if (customOriginConfig.originSslProtocols == undefined) {
                        return false;
                    }
                    const outdatedValues = [
                        aws_cloudfront_1.SecurityPolicyProtocol.SSL_V3,
                        aws_cloudfront_1.SecurityPolicyProtocol.TLS_V1,
                    ];
                    const originSslProtocols = (monocdk_1.Stack.of(node).resolve(customOriginConfig.originSslProtocols));
                    const lowerCaseProtocols = originSslProtocols.map((i) => {
                        return i.toLowerCase();
                    });
                    for (const outdated of outdatedValues) {
                        if (lowerCaseProtocols.includes(outdated.toLowerCase())) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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