"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cloudfront_1 = require("monocdk/aws-cloudfront");
const common_1 = require("../../../common");
/**
 * CloudFront distributions may require Geo restrictions
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudfront_1.CfnDistribution) {
        const distributionConfig = monocdk_1.Stack.of(node).resolve(node.distributionConfig);
        if (distributionConfig.restrictions == undefined) {
            return false;
        }
        else {
            const restrictions = monocdk_1.Stack.of(node).resolve(distributionConfig.restrictions);
            const geoRestrictions = monocdk_1.Stack.of(node).resolve(restrictions.geoRestriction);
            const restrictionType = common_1.resolveIfPrimitive(node, geoRestrictions.restrictionType);
            if (restrictionType == 'none') {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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