"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_apigateway_1 = require("monocdk/aws-apigateway");
const aws_apigatewayv2_1 = require("monocdk/aws-apigatewayv2");
const common_1 = require("../../../common");
/**
 * APIs implement authorization
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_apigateway_1.CfnMethod || node instanceof aws_apigatewayv2_1.CfnRoute) {
        const authorizationType = common_1.resolveIfPrimitive(node, node.authorizationType);
        if (authorizationType == undefined ||
            authorizationType == aws_apigateway_1.AuthorizationType.NONE) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQVBJRzQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL25ldHdvcmtfYW5kX2RlbGl2ZXJ5L0FQSUc0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBS0EsMkRBQXNFO0FBQ3RFLCtEQUFvRDtBQUNwRCw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDBCQUFTLElBQUksSUFBSSxZQUFZLDJCQUFRLEVBQUU7UUFDekQsTUFBTSxpQkFBaUIsR0FBRywyQkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDM0UsSUFDRSxpQkFBaUIsSUFBSSxTQUFTO1lBQzlCLGlCQUFpQixJQUFJLGtDQUFpQixDQUFDLElBQUksRUFDM0M7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFYRCw0QkFXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IEF1dGhvcml6YXRpb25UeXBlLCBDZm5NZXRob2QgfSBmcm9tICdtb25vY2RrL2F3cy1hcGlnYXRld2F5JztcbmltcG9ydCB7IENmblJvdXRlIH0gZnJvbSAnbW9ub2Nkay9hd3MtYXBpZ2F0ZXdheXYyJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL2NvbW1vbic7XG5cbi8qKlxuICogQVBJcyBpbXBsZW1lbnQgYXV0aG9yaXphdGlvblxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbk1ldGhvZCB8fCBub2RlIGluc3RhbmNlb2YgQ2ZuUm91dGUpIHtcbiAgICBjb25zdCBhdXRob3JpemF0aW9uVHlwZSA9IHJlc29sdmVJZlByaW1pdGl2ZShub2RlLCBub2RlLmF1dGhvcml6YXRpb25UeXBlKTtcbiAgICBpZiAoXG4gICAgICBhdXRob3JpemF0aW9uVHlwZSA9PSB1bmRlZmluZWQgfHxcbiAgICAgIGF1dGhvcml6YXRpb25UeXBlID09IEF1dGhvcml6YXRpb25UeXBlLk5PTkVcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=