"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_mediastore_1 = require("monocdk/aws-mediastore");
const common_1 = require("../../../common");
/**
 * Media Store containers define metric policies to send metrics to CloudWatch
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_mediastore_1.CfnContainer) {
        const metricPolicy = monocdk_1.Stack.of(node).resolve(node.metricPolicy);
        if (metricPolicy == undefined) {
            return false;
        }
        const containerLevelMetrics = common_1.resolveIfPrimitive(node, metricPolicy.containerLevelMetrics);
        if (containerLevelMetrics != 'ENABLED') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTVM0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9tZWRpYV9zZXJ2aWNlcy9NUzQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNkM7QUFDN0MsMkRBQXNEO0FBQ3RELDRDQUFxRDtBQUVyRDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksNkJBQVksRUFBRTtRQUNoQyxNQUFNLFlBQVksR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDL0QsSUFBSSxZQUFZLElBQUksU0FBUyxFQUFFO1lBQzdCLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLHFCQUFxQixHQUFHLDJCQUFrQixDQUM5QyxJQUFJLEVBQ0osWUFBWSxDQUFDLHFCQUFxQixDQUNuQyxDQUFDO1FBQ0YsSUFBSSxxQkFBcUIsSUFBSSxTQUFTLEVBQUU7WUFDdEMsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBZkQsNEJBZUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuQ29udGFpbmVyIH0gZnJvbSAnbW9ub2Nkay9hd3MtbWVkaWFzdG9yZSc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9jb21tb24nO1xuXG4vKipcbiAqIE1lZGlhIFN0b3JlIGNvbnRhaW5lcnMgZGVmaW5lIG1ldHJpYyBwb2xpY2llcyB0byBzZW5kIG1ldHJpY3MgdG8gQ2xvdWRXYXRjaFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkNvbnRhaW5lcikge1xuICAgIGNvbnN0IG1ldHJpY1BvbGljeSA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5tZXRyaWNQb2xpY3kpO1xuICAgIGlmIChtZXRyaWNQb2xpY3kgPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IGNvbnRhaW5lckxldmVsTWV0cmljcyA9IHJlc29sdmVJZlByaW1pdGl2ZShcbiAgICAgIG5vZGUsXG4gICAgICBtZXRyaWNQb2xpY3kuY29udGFpbmVyTGV2ZWxNZXRyaWNzLFxuICAgICk7XG4gICAgaWYgKGNvbnRhaW5lckxldmVsTWV0cmljcyAhPSAnRU5BQkxFRCcpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=