"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_sagemaker_1 = require("monocdk/aws-sagemaker");
const common_1 = require("../../../common");
/**
 * SageMaker notebook instances have direct internet access disabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_sagemaker_1.CfnNotebookInstance) {
        const directInternetAccess = common_1.resolveIfPrimitive(node, node.directInternetAccess);
        if (directInternetAccess == undefined ||
            directInternetAccess != 'Disabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU00zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9tYWNoaW5lX2xlYXJuaW5nL1NNMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLHlEQUE0RDtBQUM1RCw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLG1DQUFtQixFQUFFO1FBQ3ZDLE1BQU0sb0JBQW9CLEdBQUcsMkJBQWtCLENBQzdDLElBQUksRUFDSixJQUFJLENBQUMsb0JBQW9CLENBQzFCLENBQUM7UUFDRixJQUNFLG9CQUFvQixJQUFJLFNBQVM7WUFDakMsb0JBQW9CLElBQUksVUFBVSxFQUNsQztZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWRELDRCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuTm90ZWJvb2tJbnN0YW5jZSB9IGZyb20gJ21vbm9jZGsvYXdzLXNhZ2VtYWtlcic7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9jb21tb24nO1xuXG4vKipcbiAqIFNhZ2VNYWtlciBub3RlYm9vayBpbnN0YW5jZXMgaGF2ZSBkaXJlY3QgaW50ZXJuZXQgYWNjZXNzIGRpc2FibGVkXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuTm90ZWJvb2tJbnN0YW5jZSkge1xuICAgIGNvbnN0IGRpcmVjdEludGVybmV0QWNjZXNzID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgbm9kZSxcbiAgICAgIG5vZGUuZGlyZWN0SW50ZXJuZXRBY2Nlc3MsXG4gICAgKTtcbiAgICBpZiAoXG4gICAgICBkaXJlY3RJbnRlcm5ldEFjY2VzcyA9PSB1bmRlZmluZWQgfHxcbiAgICAgIGRpcmVjdEludGVybmV0QWNjZXNzICE9ICdEaXNhYmxlZCdcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=