"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cloud9_1 = require("monocdk/aws-cloud9");
const common_1 = require("../../../common");
/**
 * Cloud9 instances use no-ingress EC2 instances with AWS Systems Manager
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloud9_1.CfnEnvironmentEC2) {
        const connectionType = common_1.resolveIfPrimitive(node, node.connectionType);
        if (connectionType == undefined || connectionType != 'CONNECT_SSM') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQzkxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9kZXZlbG9wZXJfdG9vbHMvQzkxLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBS0EsbURBQXVEO0FBQ3ZELDRDQUFxRDtBQUVyRDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksOEJBQWlCLEVBQUU7UUFDckMsTUFBTSxjQUFjLEdBQUcsMkJBQWtCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUNyRSxJQUFJLGNBQWMsSUFBSSxTQUFTLElBQUksY0FBYyxJQUFJLGFBQWEsRUFBRTtZQUNsRSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFSRCw0QkFRQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkVudmlyb25tZW50RUMyIH0gZnJvbSAnbW9ub2Nkay9hd3MtY2xvdWQ5JztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL2NvbW1vbic7XG5cbi8qKlxuICogQ2xvdWQ5IGluc3RhbmNlcyB1c2Ugbm8taW5ncmVzcyBFQzIgaW5zdGFuY2VzIHdpdGggQVdTIFN5c3RlbXMgTWFuYWdlclxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkVudmlyb25tZW50RUMyKSB7XG4gICAgY29uc3QgY29ubmVjdGlvblR5cGUgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5jb25uZWN0aW9uVHlwZSk7XG4gICAgaWYgKGNvbm5lY3Rpb25UeXBlID09IHVuZGVmaW5lZCB8fCBjb25uZWN0aW9uVHlwZSAhPSAnQ09OTkVDVF9TU00nKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19