"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
const common_1 = require("../../../common");
/**
 * RDS Aurora MySQL serverless clusters have audit, error, general, and slowquery Log Exports enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        const engine = common_1.resolveIfPrimitive(node, node.engine).toLowerCase();
        const engineMode = common_1.resolveIfPrimitive(node, node.engineMode).toLowerCase();
        if (engineMode != undefined &&
            engineMode.toLowerCase() == 'serverless' &&
            (engine.toLowerCase() == 'aurora' ||
                engine.toLowerCase() == 'aurora-mysql')) {
            if (node.enableCloudwatchLogsExports == undefined) {
                return false;
            }
            const needed = ['audit', 'error', 'general', 'slowquery'];
            const exports = node.enableCloudwatchLogsExports.map((i) => {
                return i.toLowerCase();
            });
            return needed.every((i) => exports.includes(i));
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUkRTMTYuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL2RhdGFiYXNlcy9SRFMxNi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLDZDQUErQztBQUMvQyw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHNCQUFZLEVBQUU7UUFDaEMsTUFBTSxNQUFNLEdBQUcsMkJBQWtCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUNuRSxNQUFNLFVBQVUsR0FBRywyQkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQzNFLElBQ0UsVUFBVSxJQUFJLFNBQVM7WUFDdkIsVUFBVSxDQUFDLFdBQVcsRUFBRSxJQUFJLFlBQVk7WUFDeEMsQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFLElBQUksUUFBUTtnQkFDL0IsTUFBTSxDQUFDLFdBQVcsRUFBRSxJQUFJLGNBQWMsQ0FBQyxFQUN6QztZQUNBLElBQUksSUFBSSxDQUFDLDJCQUEyQixJQUFJLFNBQVMsRUFBRTtnQkFDakQsT0FBTyxLQUFLLENBQUM7YUFDZDtZQUNELE1BQU0sTUFBTSxHQUFHLENBQUMsT0FBTyxFQUFFLE9BQU8sRUFBRSxTQUFTLEVBQUUsV0FBVyxDQUFDLENBQUM7WUFDMUQsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLDJCQUEyQixDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO2dCQUN6RCxPQUFPLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUN6QixDQUFDLENBQUMsQ0FBQztZQUNILE9BQU8sTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ2pEO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFyQkQsNEJBcUJDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuREJDbHVzdGVyIH0gZnJvbSAnbW9ub2Nkay9hd3MtcmRzJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL2NvbW1vbic7XG5cbi8qKlxuICogUkRTIEF1cm9yYSBNeVNRTCBzZXJ2ZXJsZXNzIGNsdXN0ZXJzIGhhdmUgYXVkaXQsIGVycm9yLCBnZW5lcmFsLCBhbmQgc2xvd3F1ZXJ5IExvZyBFeHBvcnRzIGVuYWJsZWRcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5EQkNsdXN0ZXIpIHtcbiAgICBjb25zdCBlbmdpbmUgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5lbmdpbmUpLnRvTG93ZXJDYXNlKCk7XG4gICAgY29uc3QgZW5naW5lTW9kZSA9IHJlc29sdmVJZlByaW1pdGl2ZShub2RlLCBub2RlLmVuZ2luZU1vZGUpLnRvTG93ZXJDYXNlKCk7XG4gICAgaWYgKFxuICAgICAgZW5naW5lTW9kZSAhPSB1bmRlZmluZWQgJiZcbiAgICAgIGVuZ2luZU1vZGUudG9Mb3dlckNhc2UoKSA9PSAnc2VydmVybGVzcycgJiZcbiAgICAgIChlbmdpbmUudG9Mb3dlckNhc2UoKSA9PSAnYXVyb3JhJyB8fFxuICAgICAgICBlbmdpbmUudG9Mb3dlckNhc2UoKSA9PSAnYXVyb3JhLW15c3FsJylcbiAgICApIHtcbiAgICAgIGlmIChub2RlLmVuYWJsZUNsb3Vkd2F0Y2hMb2dzRXhwb3J0cyA9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgICAgY29uc3QgbmVlZGVkID0gWydhdWRpdCcsICdlcnJvcicsICdnZW5lcmFsJywgJ3Nsb3dxdWVyeSddO1xuICAgICAgY29uc3QgZXhwb3J0cyA9IG5vZGUuZW5hYmxlQ2xvdWR3YXRjaExvZ3NFeHBvcnRzLm1hcCgoaSkgPT4ge1xuICAgICAgICByZXR1cm4gaS50b0xvd2VyQ2FzZSgpO1xuICAgICAgfSk7XG4gICAgICByZXR1cm4gbmVlZGVkLmV2ZXJ5KChpKSA9PiBleHBvcnRzLmluY2x1ZGVzKGkpKTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=