"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
const common_1 = require("../../../common");
/**
 * RDS Aurora serverless clusters have Log Exports enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        const engine = common_1.resolveIfPrimitive(node, node.engine).toLowerCase();
        const backtrackWindow = common_1.resolveIfPrimitive(node, node.backtrackWindow);
        if (engine == 'aurora' || engine == 'aurora-mysql') {
            if (backtrackWindow == undefined || backtrackWindow == 0) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUkRTMTQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL2RhdGFiYXNlcy9SRFMxNC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLDZDQUErQztBQUMvQyw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHNCQUFZLEVBQUU7UUFDaEMsTUFBTSxNQUFNLEdBQUcsMkJBQWtCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUNuRSxNQUFNLGVBQWUsR0FBRywyQkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3ZFLElBQUksTUFBTSxJQUFJLFFBQVEsSUFBSSxNQUFNLElBQUksY0FBYyxFQUFFO1lBQ2xELElBQUksZUFBZSxJQUFJLFNBQVMsSUFBSSxlQUFlLElBQUksQ0FBQyxFQUFFO2dCQUN4RCxPQUFPLEtBQUssQ0FBQzthQUNkO1NBQ0Y7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVhELDRCQVdDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuREJDbHVzdGVyIH0gZnJvbSAnbW9ub2Nkay9hd3MtcmRzJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL2NvbW1vbic7XG5cbi8qKlxuICogUkRTIEF1cm9yYSBzZXJ2ZXJsZXNzIGNsdXN0ZXJzIGhhdmUgTG9nIEV4cG9ydHMgZW5hYmxlZFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRCQ2x1c3Rlcikge1xuICAgIGNvbnN0IGVuZ2luZSA9IHJlc29sdmVJZlByaW1pdGl2ZShub2RlLCBub2RlLmVuZ2luZSkudG9Mb3dlckNhc2UoKTtcbiAgICBjb25zdCBiYWNrdHJhY2tXaW5kb3cgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5iYWNrdHJhY2tXaW5kb3cpO1xuICAgIGlmIChlbmdpbmUgPT0gJ2F1cm9yYScgfHwgZW5naW5lID09ICdhdXJvcmEtbXlzcWwnKSB7XG4gICAgICBpZiAoYmFja3RyYWNrV2luZG93ID09IHVuZGVmaW5lZCB8fCBiYWNrdHJhY2tXaW5kb3cgPT0gMCkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19