"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
const common_1 = require("../../../common");
/**
 *  RDS DB instances and Aurora DB clusters do not use the default endpoint ports
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.port == undefined) {
            return false;
        }
        const port = common_1.resolveIfPrimitive(node, node.port);
        const engine = common_1.resolveIfPrimitive(node, node.engine).toLowerCase();
        const engineMode = common_1.resolveIfPrimitive(node, node.engineMode);
        if (engineMode == undefined || engineMode.toLowerCase() == 'provisioned') {
            if (engine.includes('aurora') && port == 3306) {
                return false;
            }
        }
        else if ((engine == 'aurora' || engine == 'aurora-mysql') &&
            port == 3306) {
            return false;
        }
        else if (engine == 'aurora-postgresql' && port == 5432) {
            return false;
        }
        return true;
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        if (node.engine == undefined) {
            return false;
        }
        const port = common_1.resolveIfPrimitive(node, node.port);
        const engine = common_1.resolveIfPrimitive(node, node.engine).toLowerCase();
        if (port == undefined) {
            if (!engine.includes('aurora')) {
                return false;
            }
        }
        else {
            if ((engine == 'mariadb' || engine == 'mysql') && port == 3306) {
                return false;
            }
            else if (engine == 'postgres' && port == 5432) {
                return false;
            }
            else if (engine.includes('oracle') && port == 1521) {
                return false;
            }
            else if (engine.includes('sqlserver') && port == 1433) {
                return false;
            }
        }
        return true;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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