"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
const common_1 = require("../../../common");
/**
 *  RDS DB instances and Aurora DB clusters have Deletion Protection enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.deletionProtection == undefined) {
            return false;
        }
        const deletionProtection = common_1.resolveIfPrimitive(node, node.deletionProtection);
        if (deletionProtection == false) {
            return false;
        }
        return true;
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        const deletionProtection = common_1.resolveIfPrimitive(node, node.deletionProtection);
        const engine = common_1.resolveIfPrimitive(node, node.engine);
        if ((deletionProtection == false || deletionProtection == undefined) &&
            (engine == undefined || !engine.toLowerCase().includes('aurora'))) {
            return false;
        }
        return true;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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