"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_neptune_1 = require("monocdk/aws-neptune");
const common_1 = require("../../../common");
/**
 * Neptune DB instances have Auto Minor Version Upgrade enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_neptune_1.CfnDBInstance) {
        if (node.autoMinorVersionUpgrade == undefined) {
            return false;
        }
        const autoMinorVersionUpgrade = common_1.resolveIfPrimitive(node, node.autoMinorVersionUpgrade);
        if (!autoMinorVersionUpgrade) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTjIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL2RhdGFiYXNlcy9OMi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLHFEQUFvRDtBQUNwRCw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDJCQUFhLEVBQUU7UUFDakMsSUFBSSxJQUFJLENBQUMsdUJBQXVCLElBQUksU0FBUyxFQUFFO1lBQzdDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLHVCQUF1QixHQUFHLDJCQUFrQixDQUNoRCxJQUFJLEVBQ0osSUFBSSxDQUFDLHVCQUF1QixDQUM3QixDQUFDO1FBQ0YsSUFBSSxDQUFDLHVCQUF1QixFQUFFO1lBQzVCLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWRELDRCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuREJJbnN0YW5jZSB9IGZyb20gJ21vbm9jZGsvYXdzLW5lcHR1bmUnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vY29tbW9uJztcblxuLyoqXG4gKiBOZXB0dW5lIERCIGluc3RhbmNlcyBoYXZlIEF1dG8gTWlub3IgVmVyc2lvbiBVcGdyYWRlIGVuYWJsZWRcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5EQkluc3RhbmNlKSB7XG4gICAgaWYgKG5vZGUuYXV0b01pbm9yVmVyc2lvblVwZ3JhZGUgPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IGF1dG9NaW5vclZlcnNpb25VcGdyYWRlID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgbm9kZSxcbiAgICAgIG5vZGUuYXV0b01pbm9yVmVyc2lvblVwZ3JhZGUsXG4gICAgKTtcbiAgICBpZiAoIWF1dG9NaW5vclZlcnNpb25VcGdyYWRlKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19