"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticache_1 = require("monocdk/aws-elasticache");
/**
 * ElastiCache Redis clusters use Redis AUTH for user authentication
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        if (node.authToken == undefined || node.authToken.length == 0) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQUVDNi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvZGF0YWJhc2VzL0FFQzYudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFLQSw2REFBOEQ7QUFFOUQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHFDQUFtQixFQUFFO1FBQ3ZDLElBQUksSUFBSSxDQUFDLFNBQVMsSUFBSSxTQUFTLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUFFO1lBQzdELE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVBELDRCQU9DIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuUmVwbGljYXRpb25Hcm91cCB9IGZyb20gJ21vbm9jZGsvYXdzLWVsYXN0aWNhY2hlJztcblxuLyoqXG4gKiBFbGFzdGlDYWNoZSBSZWRpcyBjbHVzdGVycyB1c2UgUmVkaXMgQVVUSCBmb3IgdXNlciBhdXRoZW50aWNhdGlvblxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblJlcGxpY2F0aW9uR3JvdXApIHtcbiAgICBpZiAobm9kZS5hdXRoVG9rZW4gPT0gdW5kZWZpbmVkIHx8IG5vZGUuYXV0aFRva2VuLmxlbmd0aCA9PSAwKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19