"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const common_1 = require("../../../common");
/**
 * ElastiCache clusters do not use the default endpoint ports
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticache_1.CfnCacheCluster) {
        const port = common_1.resolveIfPrimitive(node, node.port);
        if (port == undefined) {
            return false;
        }
        const engine = common_1.resolveIfPrimitive(node, node.engine);
        if (engine.toLowerCase() == 'redis' && port == 6379) {
            return false;
        }
        else if (engine.toLowerCase() == 'memcached' && port == 11211) {
            return false;
        }
    }
    else if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        const port = common_1.resolveIfPrimitive(node, node.port);
        if (port == undefined) {
            return false;
        }
        const engine = common_1.resolveIfPrimitive(node, node.engine);
        if ((engine == undefined || engine.toLowerCase() == 'redis') &&
            port == 6379) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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