"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const common_1 = require("../../../common");
/**
 * ElastiCache Redis clusters have both encryption in transit and at rest enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        if (node.atRestEncryptionEnabled == undefined ||
            node.transitEncryptionEnabled == undefined) {
            return false;
        }
        const rest = common_1.resolveIfPrimitive(node, node.atRestEncryptionEnabled);
        const transit = common_1.resolveIfPrimitive(node, node.transitEncryptionEnabled);
        if (rest == false || transit == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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