"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
const common_1 = require("../../../common");
/**
 * ALBs have access logs enabled.
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const type = common_1.resolveIfPrimitive(node, node.type);
        if (type == undefined || type == 'application') {
            const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
            let found = false;
            for (const attribute of attributes) {
                const resolvedAttribute = monocdk_1.Stack.of(node).resolve(attribute);
                const key = common_1.resolveIfPrimitive(node, resolvedAttribute.key);
                const value = common_1.resolveIfPrimitive(node, resolvedAttribute.value);
                if (key == 'access_logs.s3.enabled' && value == 'true') {
                    found = true;
                    break;
                }
            }
            if (!found) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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