"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_ecr_1 = require("monocdk/aws-ecr");
/**
 * ECR Repositories do not allow open access
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecr_1.CfnRegistryPolicy) {
        const policyText = monocdk_1.Stack.of(node).resolve(node.policyText);
        return checkStatement(policyText);
    }
    else if (node instanceof aws_ecr_1.CfnRepository) {
        const policyText = monocdk_1.Stack.of(node).resolve(node.repositoryPolicyText);
        return checkStatement(policyText);
    }
    return true;
}
exports.default = default_1;
/**
 * Helper function for parsing through the policy statement
 * @param policyText the JSON policy text
 * @returns boolean
 */
function checkStatement(policyText) {
    if (policyText == undefined || policyText.Statement == undefined) {
        return true;
    }
    for (const statement of policyText.Statement) {
        const effect = statement.Effect;
        if (effect == 'Allow') {
            const awsString = statement.Principal
                ? JSON.stringify(statement.Principal)
                : '';
            if (awsString.includes('*')) {
                return false;
            }
        }
    }
    return true;
}
//# sourceMappingURL=data:application/json;base64,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