"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_quicksight_1 = require("monocdk/aws-quicksight");
const common_1 = require("../../../common");
/**
 * Quicksight uses SSL when connecting to a data source
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_quicksight_1.CfnDataSource) {
        const sslProperties = monocdk_1.Stack.of(node).resolve(node.sslProperties);
        if (sslProperties != undefined) {
            const disableSsl = common_1.resolveIfPrimitive(node, sslProperties.disableSsl);
            if (disableSsl === true) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUVMxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9hbmFseXRpY3MvUVMxLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLDJEQUF1RDtBQUN2RCw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDhCQUFhLEVBQUU7UUFDakMsTUFBTSxhQUFhLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ2pFLElBQUksYUFBYSxJQUFJLFNBQVMsRUFBRTtZQUM5QixNQUFNLFVBQVUsR0FBRywyQkFBa0IsQ0FBQyxJQUFJLEVBQUUsYUFBYSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ3RFLElBQUksVUFBVSxLQUFLLElBQUksRUFBRTtnQkFDdkIsT0FBTyxLQUFLLENBQUM7YUFDZDtTQUNGO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFYRCw0QkFXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5EYXRhU291cmNlIH0gZnJvbSAnbW9ub2Nkay9hd3MtcXVpY2tzaWdodCc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9jb21tb24nO1xuXG4vKipcbiAqIFF1aWNrc2lnaHQgdXNlcyBTU0wgd2hlbiBjb25uZWN0aW5nIHRvIGEgZGF0YSBzb3VyY2VcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5EYXRhU291cmNlKSB7XG4gICAgY29uc3Qgc3NsUHJvcGVydGllcyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5zc2xQcm9wZXJ0aWVzKTtcbiAgICBpZiAoc3NsUHJvcGVydGllcyAhPSB1bmRlZmluZWQpIHtcbiAgICAgIGNvbnN0IGRpc2FibGVTc2wgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgc3NsUHJvcGVydGllcy5kaXNhYmxlU3NsKTtcbiAgICAgIGlmIChkaXNhYmxlU3NsID09PSB0cnVlKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=