"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
const common_1 = require("../../../common");
/**
 * OpenSearch Service domains use dedicated master nodes
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const elasticsearchClusterConfig = monocdk_1.Stack.of(node).resolve(node.elasticsearchClusterConfig);
        if (elasticsearchClusterConfig == undefined) {
            return false;
        }
        const dedicatedMasterEnabled = common_1.resolveIfPrimitive(node, elasticsearchClusterConfig.dedicatedMasterEnabled);
        if (!dedicatedMasterEnabled) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiT1M0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9hbmFseXRpY3MvT1M0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLGlFQUFzRDtBQUN0RCw0Q0FBcUQ7QUFFckQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDZCQUFTLEVBQUU7UUFDN0IsTUFBTSwwQkFBMEIsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FDdkQsSUFBSSxDQUFDLDBCQUEwQixDQUNoQyxDQUFDO1FBQ0YsSUFBSSwwQkFBMEIsSUFBSSxTQUFTLEVBQUU7WUFDM0MsT0FBTyxLQUFLLENBQUM7U0FDZDtRQUNELE1BQU0sc0JBQXNCLEdBQUcsMkJBQWtCLENBQy9DLElBQUksRUFDSiwwQkFBMEIsQ0FBQyxzQkFBc0IsQ0FDbEQsQ0FBQztRQUNGLElBQUksQ0FBQyxzQkFBc0IsRUFBRTtZQUMzQixPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFqQkQsNEJBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkRvbWFpbiB9IGZyb20gJ21vbm9jZGsvYXdzLWVsYXN0aWNzZWFyY2gnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vY29tbW9uJztcblxuLyoqXG4gKiBPcGVuU2VhcmNoIFNlcnZpY2UgZG9tYWlucyB1c2UgZGVkaWNhdGVkIG1hc3RlciBub2Rlc1xuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRvbWFpbikge1xuICAgIGNvbnN0IGVsYXN0aWNzZWFyY2hDbHVzdGVyQ29uZmlnID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShcbiAgICAgIG5vZGUuZWxhc3RpY3NlYXJjaENsdXN0ZXJDb25maWcsXG4gICAgKTtcbiAgICBpZiAoZWxhc3RpY3NlYXJjaENsdXN0ZXJDb25maWcgPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IGRlZGljYXRlZE1hc3RlckVuYWJsZWQgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgZWxhc3RpY3NlYXJjaENsdXN0ZXJDb25maWcuZGVkaWNhdGVkTWFzdGVyRW5hYmxlZCxcbiAgICApO1xuICAgIGlmICghZGVkaWNhdGVkTWFzdGVyRW5hYmxlZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==