"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
/**
 * OpenSearch Service domains only grant access via allowlisted IP addresses
 * @param node the CfnResource to check
 */
function default_1(node) {
    var _a, _b;
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const accessPolicies = monocdk_1.Stack.of(node).resolve(node.accessPolicies);
        if (accessPolicies == undefined) {
            return false;
        }
        const statements = accessPolicies === null || accessPolicies === void 0 ? void 0 : accessPolicies.Statement;
        if (statements == undefined || statements.length == 0) {
            return false;
        }
        for (const statement of statements) {
            if (statement.Effect == 'Allow') {
                const allowList = (_b = (_a = statement === null || statement === void 0 ? void 0 : statement.Condition) === null || _a === void 0 ? void 0 : _a.IpAddress) === null || _b === void 0 ? void 0 : _b['aws:sourceIp'];
                if (allowList == undefined || allowList.length == 0) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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