"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_msk_1 = require("monocdk/aws-msk");
const common_1 = require("../../../common");
/**
 * MSK clusters use TLS communication between brokers
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_msk_1.CfnCluster) {
        const encryptionInfo = monocdk_1.Stack.of(node).resolve(node.encryptionInfo);
        if (encryptionInfo != undefined) {
            const encryptionInTransit = monocdk_1.Stack.of(node).resolve(encryptionInfo.encryptionInTransit);
            if (encryptionInTransit != undefined) {
                const inCluster = common_1.resolveIfPrimitive(node, encryptionInTransit.inCluster);
                if (inCluster === false) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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