"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_msk_1 = require("monocdk/aws-msk");
const common_1 = require("../../../common");
/**
 * MSK clusters only uses TLS communication between clients and brokers
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_msk_1.CfnCluster) {
        const encryptionInfo = monocdk_1.Stack.of(node).resolve(node.encryptionInfo);
        if (encryptionInfo != undefined) {
            const encryptionInTransit = monocdk_1.Stack.of(node).resolve(encryptionInfo.encryptionInTransit);
            if (encryptionInTransit != undefined) {
                const clientBroker = common_1.resolveIfPrimitive(node, encryptionInTransit.clientBroker);
                if (clientBroker != undefined &&
                    clientBroker != aws_msk_1.ClientBrokerEncryption.TLS) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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