"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_kinesisanalytics_1 = require("monocdk/aws-kinesisanalytics");
const common_1 = require("../../../common");
/**
 * Kinesis Data Analytics Flink Applications have checkpointing enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_kinesisanalytics_1.CfnApplicationV2) {
        if (node.runtimeEnvironment.toLowerCase().startsWith('flink')) {
            const applicationConfiguration = monocdk_1.Stack.of(node).resolve(node.applicationConfiguration);
            if (applicationConfiguration == undefined) {
                return false;
            }
            const flinkApplicationConfiguration = monocdk_1.Stack.of(node).resolve(applicationConfiguration.flinkApplicationConfiguration);
            if (flinkApplicationConfiguration == undefined) {
                return false;
            }
            const checkpointConfiguration = monocdk_1.Stack.of(node).resolve(flinkApplicationConfiguration.checkpointConfiguration);
            if (checkpointConfiguration == undefined) {
                return false;
            }
            if (common_1.resolveIfPrimitive(node, checkpointConfiguration.configurationType) ==
                'CUSTOM') {
                const enabled = common_1.resolveIfPrimitive(node, checkpointConfiguration.checkpointingEnabled);
                if (!enabled) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiS0RBMy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvYW5hbHl0aWNzL0tEQTMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNkM7QUFDN0MsdUVBQWdFO0FBQ2hFLDRDQUFxRDtBQUVyRDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksdUNBQWdCLEVBQUU7UUFDcEMsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxFQUFFLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQzdELE1BQU0sd0JBQXdCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3JELElBQUksQ0FBQyx3QkFBd0IsQ0FDOUIsQ0FBQztZQUNGLElBQUksd0JBQXdCLElBQUksU0FBUyxFQUFFO2dCQUN6QyxPQUFPLEtBQUssQ0FBQzthQUNkO1lBQ0QsTUFBTSw2QkFBNkIsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FDMUQsd0JBQXdCLENBQUMsNkJBQTZCLENBQ3ZELENBQUM7WUFDRixJQUFJLDZCQUE2QixJQUFJLFNBQVMsRUFBRTtnQkFDOUMsT0FBTyxLQUFLLENBQUM7YUFDZDtZQUNELE1BQU0sdUJBQXVCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3BELDZCQUE2QixDQUFDLHVCQUF1QixDQUN0RCxDQUFDO1lBQ0YsSUFBSSx1QkFBdUIsSUFBSSxTQUFTLEVBQUU7Z0JBQ3hDLE9BQU8sS0FBSyxDQUFDO2FBQ2Q7WUFDRCxJQUNFLDJCQUFrQixDQUFDLElBQUksRUFBRSx1QkFBdUIsQ0FBQyxpQkFBaUIsQ0FBQztnQkFDbkUsUUFBUSxFQUNSO2dCQUNBLE1BQU0sT0FBTyxHQUFHLDJCQUFrQixDQUNoQyxJQUFJLEVBQ0osdUJBQXVCLENBQUMsb0JBQW9CLENBQzdDLENBQUM7Z0JBQ0YsSUFBSSxDQUFDLE9BQU8sRUFBRTtvQkFDWixPQUFPLEtBQUssQ0FBQztpQkFDZDthQUNGO1NBQ0Y7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQXBDRCw0QkFvQ0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuQXBwbGljYXRpb25WMiB9IGZyb20gJ21vbm9jZGsvYXdzLWtpbmVzaXNhbmFseXRpY3MnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vY29tbW9uJztcblxuLyoqXG4gKiBLaW5lc2lzIERhdGEgQW5hbHl0aWNzIEZsaW5rIEFwcGxpY2F0aW9ucyBoYXZlIGNoZWNrcG9pbnRpbmcgZW5hYmxlZFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkFwcGxpY2F0aW9uVjIpIHtcbiAgICBpZiAobm9kZS5ydW50aW1lRW52aXJvbm1lbnQudG9Mb3dlckNhc2UoKS5zdGFydHNXaXRoKCdmbGluaycpKSB7XG4gICAgICBjb25zdCBhcHBsaWNhdGlvbkNvbmZpZ3VyYXRpb24gPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgICBub2RlLmFwcGxpY2F0aW9uQ29uZmlndXJhdGlvbixcbiAgICAgICk7XG4gICAgICBpZiAoYXBwbGljYXRpb25Db25maWd1cmF0aW9uID09IHVuZGVmaW5lZCkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG4gICAgICBjb25zdCBmbGlua0FwcGxpY2F0aW9uQ29uZmlndXJhdGlvbiA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUoXG4gICAgICAgIGFwcGxpY2F0aW9uQ29uZmlndXJhdGlvbi5mbGlua0FwcGxpY2F0aW9uQ29uZmlndXJhdGlvbixcbiAgICAgICk7XG4gICAgICBpZiAoZmxpbmtBcHBsaWNhdGlvbkNvbmZpZ3VyYXRpb24gPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IGNoZWNrcG9pbnRDb25maWd1cmF0aW9uID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShcbiAgICAgICAgZmxpbmtBcHBsaWNhdGlvbkNvbmZpZ3VyYXRpb24uY2hlY2twb2ludENvbmZpZ3VyYXRpb24sXG4gICAgICApO1xuICAgICAgaWYgKGNoZWNrcG9pbnRDb25maWd1cmF0aW9uID09IHVuZGVmaW5lZCkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG4gICAgICBpZiAoXG4gICAgICAgIHJlc29sdmVJZlByaW1pdGl2ZShub2RlLCBjaGVja3BvaW50Q29uZmlndXJhdGlvbi5jb25maWd1cmF0aW9uVHlwZSkgPT1cbiAgICAgICAgJ0NVU1RPTSdcbiAgICAgICkge1xuICAgICAgICBjb25zdCBlbmFibGVkID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgICAgIG5vZGUsXG4gICAgICAgICAgY2hlY2twb2ludENvbmZpZ3VyYXRpb24uY2hlY2twb2ludGluZ0VuYWJsZWQsXG4gICAgICAgICk7XG4gICAgICAgIGlmICghZW5hYmxlZCkge1xuICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==