import * as cdktf from 'cdktf';
export interface StatefulSetV1Metadata {
    /**
    * An unstructured key value map stored with the stateful set that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#annotations StatefulSetV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#generate_name StatefulSetV1#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the stateful set. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#labels StatefulSetV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the stateful set, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the stateful set must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#namespace StatefulSetV1#namespace}
    */
    readonly namespace?: string;
}
export declare function statefulSetV1MetadataToTerraform(struct?: StatefulSetV1MetadataOutputReference | StatefulSetV1Metadata): any;
export declare class StatefulSetV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1Metadata | undefined;
    set internalValue(value: StatefulSetV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface StatefulSetV1SpecSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#operator StatefulSetV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#values StatefulSetV1#values}
    */
    readonly values?: string[];
}
export declare function statefulSetV1SpecSelectorMatchExpressionsToTerraform(struct?: StatefulSetV1SpecSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class StatefulSetV1SpecSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecSelectorMatchExpressionsOutputReference;
}
export interface StatefulSetV1SpecSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_labels StatefulSetV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_expressions StatefulSetV1#match_expressions}
    */
    readonly matchExpressions?: StatefulSetV1SpecSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecSelectorToTerraform(struct?: StatefulSetV1SpecSelectorOutputReference | StatefulSetV1SpecSelector): any;
export declare class StatefulSetV1SpecSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecSelector | undefined;
    set internalValue(value: StatefulSetV1SpecSelector | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): StatefulSetV1SpecSelectorMatchExpressionsList;
    putMatchExpressions(value: StatefulSetV1SpecSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | StatefulSetV1SpecSelectorMatchExpressions[] | undefined;
}
export interface StatefulSetV1SpecTemplateMetadata {
    /**
    * An unstructured key value map stored with the stateful set that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#annotations StatefulSetV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#generate_name StatefulSetV1#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the stateful set. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#labels StatefulSetV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the stateful set, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
}
export declare function statefulSetV1SpecTemplateMetadataToTerraform(struct?: StatefulSetV1SpecTemplateMetadataOutputReference | StatefulSetV1SpecTemplateMetadata): any;
export declare class StatefulSetV1SpecTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateMetadata | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#operator StatefulSetV1#operator}
    */
    readonly operator?: string;
    /**
    * Values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#values StatefulSetV1#values}
    */
    readonly values?: string[];
}
export declare function statefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_expressions StatefulSetV1#match_expressions}
    */
    readonly matchExpressions?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference | StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined);
    private _matchExpressions;
    get matchExpressions(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressionsList;
    putMatchExpressions(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight is in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#weight StatefulSetV1#weight}
    */
    readonly weight: number;
    /**
    * preference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#preference StatefulSetV1#preference}
    */
    readonly preference: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
}
export declare function statefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _preference;
    get preference(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceOutputReference;
    putPreference(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference): void;
    get preferenceInput(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#operator StatefulSetV1#operator}
    */
    readonly operator?: string;
    /**
    * Values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#values StatefulSetV1#values}
    */
    readonly values?: string[];
}
export declare function statefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm {
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_expressions StatefulSetV1#match_expressions}
    */
    readonly matchExpressions?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm | cdktf.IResolvable | undefined);
    private _matchExpressions;
    get matchExpressions(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressionsList;
    putMatchExpressions(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermMatchExpressions[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * node_selector_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#node_selector_term StatefulSetV1#node_selector_term}
    */
    readonly nodeSelectorTerm?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference | StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined);
    private _nodeSelectorTerm;
    get nodeSelectorTerm(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermList;
    putNodeSelectorTerm(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | cdktf.IResolvable): void;
    resetNodeSelectorTerm(): void;
    get nodeSelectorTermInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerm[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecAffinityNodeAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#preferred_during_scheduling_ignored_during_execution StatefulSetV1#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#required_during_scheduling_ignored_during_execution StatefulSetV1#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
export declare function statefulSetV1SpecTemplateSpecAffinityNodeAffinityToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityOutputReference | StatefulSetV1SpecTemplateSpecAffinityNodeAffinity): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityNodeAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinity | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#operator StatefulSetV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#values StatefulSetV1#values}
    */
    readonly values?: string[];
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_labels StatefulSetV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_expressions StatefulSetV1#match_expressions}
    */
    readonly matchExpressions?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#namespaces StatefulSetV1#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#topology_key StatefulSetV1#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#label_selector StatefulSetV1#label_selector}
    */
    readonly labelSelector?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference | StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList;
    putLabelSelector(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight associated with matching the corresponding podAffinityTerm, in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#weight StatefulSetV1#weight}
    */
    readonly weight: number;
    /**
    * pod_affinity_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#pod_affinity_term StatefulSetV1#pod_affinity_term}
    */
    readonly podAffinityTerm: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _podAffinityTerm;
    get podAffinityTerm(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference;
    putPodAffinityTerm(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): void;
    get podAffinityTermInput(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#operator StatefulSetV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#values StatefulSetV1#values}
    */
    readonly values?: string[];
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_labels StatefulSetV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_expressions StatefulSetV1#match_expressions}
    */
    readonly matchExpressions?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#namespaces StatefulSetV1#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#topology_key StatefulSetV1#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#label_selector StatefulSetV1#label_selector}
    */
    readonly labelSelector?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList;
    putLabelSelector(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#preferred_during_scheduling_ignored_during_execution StatefulSetV1#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#required_during_scheduling_ignored_during_execution StatefulSetV1#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAffinityToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAffinityOutputReference | StatefulSetV1SpecTemplateSpecAffinityPodAffinity): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAffinity | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionList;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#operator StatefulSetV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#values StatefulSetV1#values}
    */
    readonly values?: string[];
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_labels StatefulSetV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_expressions StatefulSetV1#match_expressions}
    */
    readonly matchExpressions?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#namespaces StatefulSetV1#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#topology_key StatefulSetV1#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#label_selector StatefulSetV1#label_selector}
    */
    readonly labelSelector?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorList;
    putLabelSelector(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
    * weight associated with matching the corresponding podAffinityTerm, in the range 1-100
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#weight StatefulSetV1#weight}
    */
    readonly weight: number;
    /**
    * pod_affinity_term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#pod_affinity_term StatefulSetV1#pod_affinity_term}
    */
    readonly podAffinityTerm: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _podAffinityTerm;
    get podAffinityTerm(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermOutputReference;
    putPodAffinityTerm(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm): void;
    get podAffinityTermInput(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#operator StatefulSetV1#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#values StatefulSetV1#values}
    */
    readonly values?: string[];
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_labels StatefulSetV1#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#match_expressions StatefulSetV1#match_expressions}
    */
    readonly matchExpressions?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
    * namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means 'this pod's namespace'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#namespaces StatefulSetV1#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * empty topology key is interpreted by the scheduler as 'all topologies'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#topology_key StatefulSetV1#topology_key}
    */
    readonly topologyKey: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#label_selector StatefulSetV1#label_selector}
    */
    readonly labelSelector?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | cdktf.IResolvable | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    get topologyKeyInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorList;
    putLabelSelector(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinity {
    /**
    * preferred_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#preferred_during_scheduling_ignored_during_execution StatefulSetV1#preferred_during_scheduling_ignored_during_execution}
    */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
    /**
    * required_during_scheduling_ignored_during_execution block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#required_during_scheduling_ignored_during_execution StatefulSetV1#required_during_scheduling_ignored_during_execution}
    */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecAffinityPodAntiAffinityToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityOutputReference | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinity): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinity | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinity | undefined);
    private _preferredDuringSchedulingIgnoredDuringExecution;
    get preferredDuringSchedulingIgnoredDuringExecution(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionList;
    putPreferredDuringSchedulingIgnoredDuringExecution(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetPreferredDuringSchedulingIgnoredDuringExecution(): void;
    get preferredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[] | undefined;
    private _requiredDuringSchedulingIgnoredDuringExecution;
    get requiredDuringSchedulingIgnoredDuringExecution(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionList;
    putRequiredDuringSchedulingIgnoredDuringExecution(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | cdktf.IResolvable): void;
    resetRequiredDuringSchedulingIgnoredDuringExecution(): void;
    get requiredDuringSchedulingIgnoredDuringExecutionInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecAffinity {
    /**
    * node_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#node_affinity StatefulSetV1#node_affinity}
    */
    readonly nodeAffinity?: StatefulSetV1SpecTemplateSpecAffinityNodeAffinity;
    /**
    * pod_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#pod_affinity StatefulSetV1#pod_affinity}
    */
    readonly podAffinity?: StatefulSetV1SpecTemplateSpecAffinityPodAffinity;
    /**
    * pod_anti_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#pod_anti_affinity StatefulSetV1#pod_anti_affinity}
    */
    readonly podAntiAffinity?: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinity;
}
export declare function statefulSetV1SpecTemplateSpecAffinityToTerraform(struct?: StatefulSetV1SpecTemplateSpecAffinityOutputReference | StatefulSetV1SpecTemplateSpecAffinity): any;
export declare class StatefulSetV1SpecTemplateSpecAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecAffinity | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecAffinity | undefined);
    private _nodeAffinity;
    get nodeAffinity(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinityOutputReference;
    putNodeAffinity(value: StatefulSetV1SpecTemplateSpecAffinityNodeAffinity): void;
    resetNodeAffinity(): void;
    get nodeAffinityInput(): StatefulSetV1SpecTemplateSpecAffinityNodeAffinity | undefined;
    private _podAffinity;
    get podAffinity(): StatefulSetV1SpecTemplateSpecAffinityPodAffinityOutputReference;
    putPodAffinity(value: StatefulSetV1SpecTemplateSpecAffinityPodAffinity): void;
    resetPodAffinity(): void;
    get podAffinityInput(): StatefulSetV1SpecTemplateSpecAffinityPodAffinity | undefined;
    private _podAntiAffinity;
    get podAntiAffinity(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinityOutputReference;
    putPodAntiAffinity(value: StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinity): void;
    resetPodAntiAffinity(): void;
    get podAntiAffinityInput(): StatefulSetV1SpecTemplateSpecAffinityPodAntiAffinity | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRef {
    /**
    * The key to select.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * Specify whether the ConfigMap or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference | StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRef): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#api_version StatefulSetV1#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#field_path StatefulSetV1#field_path}
    */
    readonly fieldPath?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRefOutputReference | StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRef): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#container_name StatefulSetV1#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#divisor StatefulSetV1#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#resource StatefulSetV1#resource}
    */
    readonly resource: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference | StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRef): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRef {
    /**
    * The key of the secret to select from. Must be a valid secret key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * Specify whether the Secret or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference | StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRef): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvValueFrom {
    /**
    * config_map_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#config_map_key_ref StatefulSetV1#config_map_key_ref}
    */
    readonly configMapKeyRef?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRef;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#field_ref StatefulSetV1#field_ref}
    */
    readonly fieldRef?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#resource_field_ref StatefulSetV1#resource_field_ref}
    */
    readonly resourceFieldRef?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRef;
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#secret_key_ref StatefulSetV1#secret_key_ref}
    */
    readonly secretKeyRef?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRef;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvValueFromToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvValueFromOutputReference | StatefulSetV1SpecTemplateSpecContainerEnvValueFrom): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvValueFrom | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFrom | undefined);
    private _configMapKeyRef;
    get configMapKeyRef(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRefOutputReference;
    putConfigMapKeyRef(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRef): void;
    resetConfigMapKeyRef(): void;
    get configMapKeyRefInput(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromConfigMapKeyRef | undefined;
    private _fieldRef;
    get fieldRef(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRefOutputReference;
    putFieldRef(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRefOutputReference;
    putResourceFieldRef(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromResourceFieldRef | undefined;
    private _secretKeyRef;
    get secretKeyRef(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromSecretKeyRef | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value_from StatefulSetV1#value_from}
    */
    readonly valueFrom?: StatefulSetV1SpecTemplateSpecContainerEnvValueFrom;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnv | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): StatefulSetV1SpecTemplateSpecContainerEnvValueFromOutputReference;
    putValueFrom(value: StatefulSetV1SpecTemplateSpecContainerEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): StatefulSetV1SpecTemplateSpecContainerEnvValueFrom | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerEnvOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRefOutputReference | StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRef): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRef {
    /**
    * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvFromSecretRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRefOutputReference | StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRef): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerEnvFrom {
    /**
    * An optional identifer to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#prefix StatefulSetV1#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#config_map_ref StatefulSetV1#config_map_ref}
    */
    readonly configMapRef?: StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#secret_ref StatefulSetV1#secret_ref}
    */
    readonly secretRef?: StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRef;
}
export declare function statefulSetV1SpecTemplateSpecContainerEnvFromToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerEnvFrom | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): StatefulSetV1SpecTemplateSpecContainerEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRefOutputReference;
    putSecretRef(value: StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): StatefulSetV1SpecTemplateSpecContainerEnvFromSecretRef | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerEnvFromOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePostStartExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExecOutputReference | StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExec): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference | StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePostStartToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartTcpSocket[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePreStopExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExecOutputReference | StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExec): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference | StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecyclePreStopToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopTcpSocket[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLifecycle {
    /**
    * post_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#post_start StatefulSetV1#post_start}
    */
    readonly postStart?: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * pre_stop block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#pre_stop StatefulSetV1#pre_stop}
    */
    readonly preStop?: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerLifecycleToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLifecycleOutputReference | StatefulSetV1SpecTemplateSpecContainerLifecycle): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLifecycle | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLifecycle | undefined);
    private _postStart;
    get postStart(): StatefulSetV1SpecTemplateSpecContainerLifecyclePostStartList;
    putPostStart(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart[] | cdktf.IResolvable): void;
    resetPostStart(): void;
    get postStartInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLifecyclePostStart[] | undefined;
    private _preStop;
    get preStop(): StatefulSetV1SpecTemplateSpecContainerLifecyclePreStopList;
    putPreStop(value: StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop[] | cdktf.IResolvable): void;
    resetPreStop(): void;
    get preStopInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLifecyclePreStop[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerLivenessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecContainerLivenessProbeExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeExecOutputReference | StatefulSetV1SpecTemplateSpecContainerLivenessProbeExec): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLivenessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetOutputReference | StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#failure_threshold StatefulSetV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#initial_delay_seconds StatefulSetV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#period_seconds StatefulSetV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#success_threshold StatefulSetV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#timeout_seconds StatefulSetV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerLivenessProbeToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerLivenessProbeOutputReference | StatefulSetV1SpecTemplateSpecContainerLivenessProbe): any;
export declare class StatefulSetV1SpecTemplateSpecContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerLivenessProbe | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerLivenessProbeTcpSocket[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerPort {
    /**
    * Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#container_port StatefulSetV1#container_port}
    */
    readonly containerPort: number;
    /**
    * What host IP to bind the external port to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host_ip StatefulSetV1#host_ip}
    */
    readonly hostIp?: string;
    /**
    * Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host_port StatefulSetV1#host_port}
    */
    readonly hostPort?: number;
    /**
    * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be UDP or TCP. Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#protocol StatefulSetV1#protocol}
    */
    readonly protocol?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerPortToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerPort | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerPort | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerPort | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    get containerPortInput(): number | undefined;
    private _hostIp?;
    get hostIp(): string;
    set hostIp(value: string);
    resetHostIp(): void;
    get hostIpInput(): string | undefined;
    private _hostPort?;
    get hostPort(): number;
    set hostPort(value: number);
    resetHostPort(): void;
    get hostPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerPortOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerReadinessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecContainerReadinessProbeExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeExecOutputReference | StatefulSetV1SpecTemplateSpecContainerReadinessProbeExec): any;
export declare class StatefulSetV1SpecTemplateSpecContainerReadinessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetOutputReference | StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerReadinessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#failure_threshold StatefulSetV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#initial_delay_seconds StatefulSetV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#period_seconds StatefulSetV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#success_threshold StatefulSetV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#timeout_seconds StatefulSetV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerReadinessProbeToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerReadinessProbeOutputReference | StatefulSetV1SpecTemplateSpecContainerReadinessProbe): any;
export declare class StatefulSetV1SpecTemplateSpecContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerReadinessProbe | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerReadinessProbeTcpSocket[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerResources {
    /**
    * Describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#limits StatefulSetV1#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#requests StatefulSetV1#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function statefulSetV1SpecTemplateSpecContainerResourcesToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerResourcesOutputReference | StatefulSetV1SpecTemplateSpecContainerResources): any;
export declare class StatefulSetV1SpecTemplateSpecContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerResources | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilities {
    /**
    * Added capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#add StatefulSetV1#add}
    */
    readonly add?: string[];
    /**
    * Removed capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#drop StatefulSetV1#drop}
    */
    readonly drop?: string[];
}
export declare function statefulSetV1SpecTemplateSpecContainerSecurityContextCapabilitiesToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference | StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilities): any;
export declare class StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilities | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilities | undefined);
    private _add?;
    get add(): string[];
    set add(value: string[]);
    resetAdd(): void;
    get addInput(): string[] | undefined;
    private _drop?;
    get drop(): string[];
    set drop(value: string[]);
    resetDrop(): void;
    get dropInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#level StatefulSetV1#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#role StatefulSetV1#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#type StatefulSetV1#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#user StatefulSetV1#user}
    */
    readonly user?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference | StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptions): any;
export declare class StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#localhost_profile StatefulSetV1#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#type StatefulSetV1#type}
    */
    readonly type?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfileToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference | StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfile): any;
export declare class StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfile | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#allow_privilege_escalation StatefulSetV1#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#privileged StatefulSetV1#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#read_only_root_filesystem StatefulSetV1#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#run_as_group StatefulSetV1#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#run_as_non_root StatefulSetV1#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#run_as_user StatefulSetV1#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#capabilities StatefulSetV1#capabilities}
    */
    readonly capabilities?: StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#se_linux_options StatefulSetV1#se_linux_options}
    */
    readonly seLinuxOptions?: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#seccomp_profile StatefulSetV1#seccomp_profile}
    */
    readonly seccompProfile?: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfile;
}
export declare function statefulSetV1SpecTemplateSpecContainerSecurityContextToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerSecurityContextOutputReference | StatefulSetV1SpecTemplateSpecContainerSecurityContext): any;
export declare class StatefulSetV1SpecTemplateSpecContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerSecurityContext | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): StatefulSetV1SpecTemplateSpecContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): StatefulSetV1SpecTemplateSpecContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): StatefulSetV1SpecTemplateSpecContainerSecurityContextSeccompProfile | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecContainerStartupProbeExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerStartupProbeExecOutputReference | StatefulSetV1SpecTemplateSpecContainerStartupProbeExec): any;
export declare class StatefulSetV1SpecTemplateSpecContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerStartupProbeExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetOutputReference | StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainerStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#failure_threshold StatefulSetV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#initial_delay_seconds StatefulSetV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#period_seconds StatefulSetV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#success_threshold StatefulSetV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#timeout_seconds StatefulSetV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecContainerStartupProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerStartupProbeToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerStartupProbeOutputReference | StatefulSetV1SpecTemplateSpecContainerStartupProbe): any;
export declare class StatefulSetV1SpecTemplateSpecContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerStartupProbe | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecContainerStartupProbeExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecContainerStartupProbeExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecContainerStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerStartupProbeTcpSocket[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecContainerVolumeMount {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#mount_path StatefulSetV1#mount_path}
    */
    readonly mountPath: string;
    /**
    * Mount propagation mode. mount_propagation determines how mounts are propagated from the host to container and the other way around. Valid values are None (default), HostToContainer and Bidirectional.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#mount_propagation StatefulSetV1#mount_propagation}
    */
    readonly mountPropagation?: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#read_only StatefulSetV1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#sub_path StatefulSetV1#sub_path}
    */
    readonly subPath?: string;
}
export declare function statefulSetV1SpecTemplateSpecContainerVolumeMountToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainerVolumeMount | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerVolumeMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainerVolumeMount | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainerVolumeMount | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _mountPropagation?;
    get mountPropagation(): string;
    set mountPropagation(value: string);
    resetMountPropagation(): void;
    get mountPropagationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _subPath?;
    get subPath(): string;
    set subPath(value: string);
    resetSubPath(): void;
    get subPathInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerVolumeMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerVolumeMountOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecContainer {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#args StatefulSetV1#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/containers#containers-and-commands
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. More info: http://kubernetes.io/docs/user-guide/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#image StatefulSetV1#image}
    */
    readonly image?: string;
    /**
    * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/images#updating-images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#image_pull_policy StatefulSetV1#image_pull_policy}
    */
    readonly imagePullPolicy?: string;
    /**
    * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#stdin StatefulSetV1#stdin}
    */
    readonly stdin?: boolean | cdktf.IResolvable;
    /**
    * Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#stdin_once StatefulSetV1#stdin_once}
    */
    readonly stdinOnce?: boolean | cdktf.IResolvable;
    /**
    * Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Defaults to /dev/termination-log. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#termination_message_path StatefulSetV1#termination_message_path}
    */
    readonly terminationMessagePath?: string;
    /**
    * Optional: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#termination_message_policy StatefulSetV1#termination_message_policy}
    */
    readonly terminationMessagePolicy?: string;
    /**
    * Whether this container should allocate a TTY for itself
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tty StatefulSetV1#tty}
    */
    readonly tty?: boolean | cdktf.IResolvable;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#working_dir StatefulSetV1#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#env StatefulSetV1#env}
    */
    readonly env?: StatefulSetV1SpecTemplateSpecContainerEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#env_from StatefulSetV1#env_from}
    */
    readonly envFrom?: StatefulSetV1SpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * lifecycle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#lifecycle StatefulSetV1#lifecycle}
    */
    readonly lifecycle?: StatefulSetV1SpecTemplateSpecContainerLifecycle;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#liveness_probe StatefulSetV1#liveness_probe}
    */
    readonly livenessProbe?: StatefulSetV1SpecTemplateSpecContainerLivenessProbe;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: StatefulSetV1SpecTemplateSpecContainerPort[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#readiness_probe StatefulSetV1#readiness_probe}
    */
    readonly readinessProbe?: StatefulSetV1SpecTemplateSpecContainerReadinessProbe;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#resources StatefulSetV1#resources}
    */
    readonly resources?: StatefulSetV1SpecTemplateSpecContainerResources;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#security_context StatefulSetV1#security_context}
    */
    readonly securityContext?: StatefulSetV1SpecTemplateSpecContainerSecurityContext;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#startup_probe StatefulSetV1#startup_probe}
    */
    readonly startupProbe?: StatefulSetV1SpecTemplateSpecContainerStartupProbe;
    /**
    * volume_mount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#volume_mount StatefulSetV1#volume_mount}
    */
    readonly volumeMount?: StatefulSetV1SpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecContainerToTerraform(struct?: StatefulSetV1SpecTemplateSpecContainer | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecContainer | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imagePullPolicy?;
    get imagePullPolicy(): string;
    set imagePullPolicy(value: string);
    resetImagePullPolicy(): void;
    get imagePullPolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stdin?;
    get stdin(): boolean | cdktf.IResolvable;
    set stdin(value: boolean | cdktf.IResolvable);
    resetStdin(): void;
    get stdinInput(): boolean | cdktf.IResolvable | undefined;
    private _stdinOnce?;
    get stdinOnce(): boolean | cdktf.IResolvable;
    set stdinOnce(value: boolean | cdktf.IResolvable);
    resetStdinOnce(): void;
    get stdinOnceInput(): boolean | cdktf.IResolvable | undefined;
    private _terminationMessagePath?;
    get terminationMessagePath(): string;
    set terminationMessagePath(value: string);
    resetTerminationMessagePath(): void;
    get terminationMessagePathInput(): string | undefined;
    private _terminationMessagePolicy?;
    get terminationMessagePolicy(): string;
    set terminationMessagePolicy(value: string);
    resetTerminationMessagePolicy(): void;
    get terminationMessagePolicyInput(): string | undefined;
    private _tty?;
    get tty(): boolean | cdktf.IResolvable;
    set tty(value: boolean | cdktf.IResolvable);
    resetTty(): void;
    get ttyInput(): boolean | cdktf.IResolvable | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): StatefulSetV1SpecTemplateSpecContainerEnvList;
    putEnv(value: StatefulSetV1SpecTemplateSpecContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerEnv[] | undefined;
    private _envFrom;
    get envFrom(): StatefulSetV1SpecTemplateSpecContainerEnvFromList;
    putEnvFrom(value: StatefulSetV1SpecTemplateSpecContainerEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerEnvFrom[] | undefined;
    private _lifecycle;
    get lifecycle(): StatefulSetV1SpecTemplateSpecContainerLifecycleOutputReference;
    putLifecycle(value: StatefulSetV1SpecTemplateSpecContainerLifecycle): void;
    resetLifecycle(): void;
    get lifecycleInput(): StatefulSetV1SpecTemplateSpecContainerLifecycle | undefined;
    private _livenessProbe;
    get livenessProbe(): StatefulSetV1SpecTemplateSpecContainerLivenessProbeOutputReference;
    putLivenessProbe(value: StatefulSetV1SpecTemplateSpecContainerLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): StatefulSetV1SpecTemplateSpecContainerLivenessProbe | undefined;
    private _port;
    get port(): StatefulSetV1SpecTemplateSpecContainerPortList;
    putPort(value: StatefulSetV1SpecTemplateSpecContainerPort[] | cdktf.IResolvable): void;
    resetPort(): void;
    get portInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerPort[] | undefined;
    private _readinessProbe;
    get readinessProbe(): StatefulSetV1SpecTemplateSpecContainerReadinessProbeOutputReference;
    putReadinessProbe(value: StatefulSetV1SpecTemplateSpecContainerReadinessProbe): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): StatefulSetV1SpecTemplateSpecContainerReadinessProbe | undefined;
    private _resources;
    get resources(): StatefulSetV1SpecTemplateSpecContainerResourcesOutputReference;
    putResources(value: StatefulSetV1SpecTemplateSpecContainerResources): void;
    resetResources(): void;
    get resourcesInput(): StatefulSetV1SpecTemplateSpecContainerResources | undefined;
    private _securityContext;
    get securityContext(): StatefulSetV1SpecTemplateSpecContainerSecurityContextOutputReference;
    putSecurityContext(value: StatefulSetV1SpecTemplateSpecContainerSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): StatefulSetV1SpecTemplateSpecContainerSecurityContext | undefined;
    private _startupProbe;
    get startupProbe(): StatefulSetV1SpecTemplateSpecContainerStartupProbeOutputReference;
    putStartupProbe(value: StatefulSetV1SpecTemplateSpecContainerStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): StatefulSetV1SpecTemplateSpecContainerStartupProbe | undefined;
    private _volumeMount;
    get volumeMount(): StatefulSetV1SpecTemplateSpecContainerVolumeMountList;
    putVolumeMount(value: StatefulSetV1SpecTemplateSpecContainerVolumeMount[] | cdktf.IResolvable): void;
    resetVolumeMount(): void;
    get volumeMountInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecContainerVolumeMount[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecContainerOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecDnsConfigOption {
    /**
    * Name of the option.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Value of the option. Optional: Defaults to empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecDnsConfigOptionToTerraform(struct?: StatefulSetV1SpecTemplateSpecDnsConfigOption | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecDnsConfigOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecDnsConfigOption | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecDnsConfigOption | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecDnsConfigOptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecDnsConfigOptionOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecDnsConfig {
    /**
    * A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#nameservers StatefulSetV1#nameservers}
    */
    readonly nameservers?: string[];
    /**
    * A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#searches StatefulSetV1#searches}
    */
    readonly searches?: string[];
    /**
    * option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#option StatefulSetV1#option}
    */
    readonly option?: StatefulSetV1SpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecDnsConfigToTerraform(struct?: StatefulSetV1SpecTemplateSpecDnsConfigOutputReference | StatefulSetV1SpecTemplateSpecDnsConfig): any;
export declare class StatefulSetV1SpecTemplateSpecDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecDnsConfig | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecDnsConfig | undefined);
    private _nameservers?;
    get nameservers(): string[];
    set nameservers(value: string[]);
    resetNameservers(): void;
    get nameserversInput(): string[] | undefined;
    private _searches?;
    get searches(): string[];
    set searches(value: string[]);
    resetSearches(): void;
    get searchesInput(): string[] | undefined;
    private _option;
    get option(): StatefulSetV1SpecTemplateSpecDnsConfigOptionList;
    putOption(value: StatefulSetV1SpecTemplateSpecDnsConfigOption[] | cdktf.IResolvable): void;
    resetOption(): void;
    get optionInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecDnsConfigOption[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecHostAliases {
    /**
    * Hostnames for the IP address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#hostnames StatefulSetV1#hostnames}
    */
    readonly hostnames: string[];
    /**
    * IP address of the host file entry.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#ip StatefulSetV1#ip}
    */
    readonly ip: string;
}
export declare function statefulSetV1SpecTemplateSpecHostAliasesToTerraform(struct?: StatefulSetV1SpecTemplateSpecHostAliases | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecHostAliasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecHostAliases | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecHostAliases | cdktf.IResolvable | undefined);
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    get hostnamesInput(): string[] | undefined;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    get ipInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecHostAliasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecHostAliases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecHostAliasesOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecImagePullSecrets {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
}
export declare function statefulSetV1SpecTemplateSpecImagePullSecretsToTerraform(struct?: StatefulSetV1SpecTemplateSpecImagePullSecrets | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecImagePullSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecImagePullSecrets | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecImagePullSecrets | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecImagePullSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecImagePullSecretsOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef {
    /**
    * The key to select.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * Specify whether the ConfigMap or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference | StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#api_version StatefulSetV1#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#field_path StatefulSetV1#field_path}
    */
    readonly fieldPath?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference | StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRef): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#container_name StatefulSetV1#container_name}
    */
    readonly containerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#divisor StatefulSetV1#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#resource StatefulSetV1#resource}
    */
    readonly resource: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference | StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRef): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    resetContainerName(): void;
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRef {
    /**
    * The key of the secret to select from. Must be a valid secret key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#key StatefulSetV1#key}
    */
    readonly key?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * Specify whether the Secret or its key must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference | StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRef): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvValueFrom {
    /**
    * config_map_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#config_map_key_ref StatefulSetV1#config_map_key_ref}
    */
    readonly configMapKeyRef?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#field_ref StatefulSetV1#field_ref}
    */
    readonly fieldRef?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#resource_field_ref StatefulSetV1#resource_field_ref}
    */
    readonly resourceFieldRef?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRef;
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#secret_key_ref StatefulSetV1#secret_key_ref}
    */
    readonly secretKeyRef?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRef;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvValueFromToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromOutputReference | StatefulSetV1SpecTemplateSpecInitContainerEnvValueFrom): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFrom | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFrom | undefined);
    private _configMapKeyRef;
    get configMapKeyRef(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRefOutputReference;
    putConfigMapKeyRef(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef): void;
    resetConfigMapKeyRef(): void;
    get configMapKeyRefInput(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromConfigMapKeyRef | undefined;
    private _fieldRef;
    get fieldRef(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRefOutputReference;
    putFieldRef(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRefOutputReference;
    putResourceFieldRef(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromResourceFieldRef | undefined;
    private _secretKeyRef;
    get secretKeyRef(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromSecretKeyRef | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value_from StatefulSetV1#value_from}
    */
    readonly valueFrom?: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFrom;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnv | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFromOutputReference;
    putValueFrom(value: StatefulSetV1SpecTemplateSpecInitContainerEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): StatefulSetV1SpecTemplateSpecInitContainerEnvValueFrom | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerEnvOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference | StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRef): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRef {
    /**
    * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name: string;
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#optional StatefulSetV1#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRefToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRefOutputReference | StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRef): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRef | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerEnvFrom {
    /**
    * An optional identifer to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#prefix StatefulSetV1#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#config_map_ref StatefulSetV1#config_map_ref}
    */
    readonly configMapRef?: StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#secret_ref StatefulSetV1#secret_ref}
    */
    readonly secretRef?: StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRef;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerEnvFromToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): StatefulSetV1SpecTemplateSpecInitContainerEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRefOutputReference;
    putSecretRef(value: StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): StatefulSetV1SpecTemplateSpecInitContainerEnvFromSecretRef | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerEnvFromOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExec): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartTcpSocket[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExec): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop {
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop | cdktf.IResolvable | undefined);
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopTcpSocket[] | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLifecycle {
    /**
    * post_start block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#post_start StatefulSetV1#post_start}
    */
    readonly postStart?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable;
    /**
    * pre_stop block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#pre_stop StatefulSetV1#pre_stop}
    */
    readonly preStop?: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLifecycleToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLifecycleOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLifecycle): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLifecycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLifecycle | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLifecycle | undefined);
    private _postStart;
    get postStart(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStartList;
    putPostStart(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart[] | cdktf.IResolvable): void;
    resetPostStart(): void;
    get postStartInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePostStart[] | undefined;
    private _preStop;
    get preStop(): StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStopList;
    putPreStop(value: StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop[] | cdktf.IResolvable): void;
    resetPreStop(): void;
    get preStopInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLifecyclePreStop[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLivenessProbeExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExecOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExec): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#failure_threshold StatefulSetV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#initial_delay_seconds StatefulSetV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#period_seconds StatefulSetV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#success_threshold StatefulSetV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#timeout_seconds StatefulSetV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerLivenessProbeToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeOutputReference | StatefulSetV1SpecTemplateSpecInitContainerLivenessProbe): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbe | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerLivenessProbeTcpSocket[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerPort {
    /**
    * Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#container_port StatefulSetV1#container_port}
    */
    readonly containerPort: number;
    /**
    * What host IP to bind the external port to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host_ip StatefulSetV1#host_ip}
    */
    readonly hostIp?: string;
    /**
    * Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host_port StatefulSetV1#host_port}
    */
    readonly hostPort?: number;
    /**
    * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be UDP or TCP. Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#protocol StatefulSetV1#protocol}
    */
    readonly protocol?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerPortToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerPort | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerPort | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerPort | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    get containerPortInput(): number | undefined;
    private _hostIp?;
    get hostIp(): string;
    set hostIp(value: string);
    resetHostIp(): void;
    get hostIpInput(): string | undefined;
    private _hostPort?;
    get hostPort(): number;
    set hostPort(value: number);
    resetHostPort(): void;
    get hostPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerPortOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecInitContainerReadinessProbeExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExecOutputReference | StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExec): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference | StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerReadinessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#failure_threshold StatefulSetV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#initial_delay_seconds StatefulSetV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#period_seconds StatefulSetV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#success_threshold StatefulSetV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#timeout_seconds StatefulSetV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerReadinessProbeToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeOutputReference | StatefulSetV1SpecTemplateSpecInitContainerReadinessProbe): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbe | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerReadinessProbeTcpSocket[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerResources {
    /**
    * Describes the maximum amount of compute resources allowed. More info: http://kubernetes.io/docs/user-guide/compute-resources/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#limits StatefulSetV1#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#requests StatefulSetV1#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function statefulSetV1SpecTemplateSpecInitContainerResourcesToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerResourcesOutputReference | StatefulSetV1SpecTemplateSpecInitContainerResources): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerResources | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilities {
    /**
    * Added capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#add StatefulSetV1#add}
    */
    readonly add?: string[];
    /**
    * Removed capabilities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#drop StatefulSetV1#drop}
    */
    readonly drop?: string[];
}
export declare function statefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilitiesToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference | StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilities): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilities | undefined);
    private _add?;
    get add(): string[];
    set add(value: string[]);
    resetAdd(): void;
    get addInput(): string[] | undefined;
    private _drop?;
    get drop(): string[];
    set drop(value: string[]);
    resetDrop(): void;
    get dropInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#level StatefulSetV1#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#role StatefulSetV1#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#type StatefulSetV1#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#user StatefulSetV1#user}
    */
    readonly user?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference | StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#localhost_profile StatefulSetV1#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#type StatefulSetV1#type}
    */
    readonly type?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfileToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference | StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerSecurityContext {
    /**
    * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#allow_privilege_escalation StatefulSetV1#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#privileged StatefulSetV1#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * Whether this container has a read-only root filesystem. Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#read_only_root_filesystem StatefulSetV1#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#run_as_group StatefulSetV1#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#run_as_non_root StatefulSetV1#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#run_as_user StatefulSetV1#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#capabilities StatefulSetV1#capabilities}
    */
    readonly capabilities?: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilities;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#se_linux_options StatefulSetV1#se_linux_options}
    */
    readonly seLinuxOptions?: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#seccomp_profile StatefulSetV1#seccomp_profile}
    */
    readonly seccompProfile?: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerSecurityContextToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextOutputReference | StatefulSetV1SpecTemplateSpecInitContainerSecurityContext): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContext | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerSecurityContext | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _capabilities;
    get capabilities(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilitiesOutputReference;
    putCapabilities(value: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextCapabilities | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): StatefulSetV1SpecTemplateSpecInitContainerSecurityContextSeccompProfile | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExec {
    /**
    * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#command StatefulSetV1#command}
    */
    readonly command?: string[];
}
export declare function statefulSetV1SpecTemplateSpecInitContainerStartupProbeExecToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExecOutputReference | StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExec): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExec | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExec | undefined);
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#name StatefulSetV1#name}
    */
    readonly name?: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#value StatefulSetV1#value}
    */
    readonly value?: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGet {
    /**
    * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#host StatefulSetV1#host}
    */
    readonly host?: string;
    /**
    * Path to access on the HTTP server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#path StatefulSetV1#path}
    */
    readonly path?: string;
    /**
    * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port?: string;
    /**
    * Scheme to use for connecting to the host.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#scheme StatefulSetV1#scheme}
    */
    readonly scheme?: string;
    /**
    * http_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_header StatefulSetV1#http_header}
    */
    readonly httpHeader?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference | StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGet): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGet | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGet | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _httpHeader;
    get httpHeader(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeaderList;
    putHttpHeader(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | cdktf.IResolvable): void;
    resetHttpHeader(): void;
    get httpHeaderInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetHttpHeader[] | undefined;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket {
    /**
    * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#port StatefulSetV1#port}
    */
    readonly port: string;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocketToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket | cdktf.IResolvable | undefined);
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
}
export declare class StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocketOutputReference;
}
export interface StatefulSetV1SpecTemplateSpecInitContainerStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#failure_threshold StatefulSetV1#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before liveness probes are initiated. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#initial_delay_seconds StatefulSetV1#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#period_seconds StatefulSetV1#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Minimum consecutive successes for the probe to be considered successful after having failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#success_threshold StatefulSetV1#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Number of seconds after which the probe times out. More info: http://kubernetes.io/docs/user-guide/pod-states#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#timeout_seconds StatefulSetV1#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#exec StatefulSetV1#exec}
    */
    readonly exec?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExec;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#http_get StatefulSetV1#http_get}
    */
    readonly httpGet?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set_v1#tcp_socket StatefulSetV1#tcp_socket}
    */
    readonly tcpSocket?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable;
}
export declare function statefulSetV1SpecTemplateSpecInitContainerStartupProbeToTerraform(struct?: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeOutputReference | StatefulSetV1SpecTemplateSpecInitContainerStartupProbe): any;
export declare class StatefulSetV1SpecTemplateSpecInitContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbe | undefined;
    set internalValue(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _exec;
    get exec(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExecOutputReference;
    putExec(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExec): void;
    resetExec(): void;
    get execInput(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeExec | undefined;
    private _httpGet;
    get httpGet(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGetOutputReference;
    putHttpGet(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocketList;
    putTcpSocket(value: StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | cdktf.IResolvable): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): cdktf.IResolvable | StatefulSetV1SpecTemplateSpecInitContainerStartupProbeTcpSocket[] | undefined;
}
