import { ReplicationControllerV1Metadata, ReplicationControllerV1MetadataOutputReference, ReplicationControllerV1Spec, ReplicationControllerV1SpecOutputReference, ReplicationControllerV1Timeouts, ReplicationControllerV1TimeoutsOutputReference } from './replication-controller-v1-structs';
export * from './replication-controller-v1-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ReplicationControllerV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller_v1#id ReplicationControllerV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller_v1#metadata ReplicationControllerV1#metadata}
    */
    readonly metadata: ReplicationControllerV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller_v1#spec ReplicationControllerV1#spec}
    */
    readonly spec: ReplicationControllerV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller_v1#timeouts ReplicationControllerV1#timeouts}
    */
    readonly timeouts?: ReplicationControllerV1Timeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller_v1 kubernetes_replication_controller_v1}
*/
export declare class ReplicationControllerV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_replication_controller_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/replication_controller_v1 kubernetes_replication_controller_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ReplicationControllerV1Config
    */
    constructor(scope: Construct, id: string, config: ReplicationControllerV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ReplicationControllerV1MetadataOutputReference;
    putMetadata(value: ReplicationControllerV1Metadata): void;
    get metadataInput(): ReplicationControllerV1Metadata | undefined;
    private _spec;
    get spec(): ReplicationControllerV1SpecOutputReference;
    putSpec(value: ReplicationControllerV1Spec): void;
    get specInput(): ReplicationControllerV1Spec | undefined;
    private _timeouts;
    get timeouts(): ReplicationControllerV1TimeoutsOutputReference;
    putTimeouts(value: ReplicationControllerV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ReplicationControllerV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
