import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PodSecurityPolicyV1Beta1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#id PodSecurityPolicyV1Beta1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#metadata PodSecurityPolicyV1Beta1#metadata}
    */
    readonly metadata: PodSecurityPolicyV1Beta1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#spec PodSecurityPolicyV1Beta1#spec}
    */
    readonly spec: PodSecurityPolicyV1Beta1Spec;
}
export interface PodSecurityPolicyV1Beta1Metadata {
    /**
    * An unstructured key value map stored with the podsecuritypolicy that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#annotations PodSecurityPolicyV1Beta1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the podsecuritypolicy. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#labels PodSecurityPolicyV1Beta1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the podsecuritypolicy, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#name PodSecurityPolicyV1Beta1#name}
    */
    readonly name?: string;
}
export declare function podSecurityPolicyV1Beta1MetadataToTerraform(struct?: PodSecurityPolicyV1Beta1MetadataOutputReference | PodSecurityPolicyV1Beta1Metadata): any;
export declare class PodSecurityPolicyV1Beta1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyV1Beta1Metadata | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes {
    /**
    * driver is the name of the Flexvolume driver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#driver PodSecurityPolicyV1Beta1#driver}
    */
    readonly driver: string;
}
export declare function podSecurityPolicyV1Beta1SpecAllowedFlexVolumesToTerraform(struct?: PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecAllowedFlexVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes | cdktf.IResolvable | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecAllowedFlexVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecAllowedFlexVolumesOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecAllowedHostPaths {
    /**
    * pathPrefix is the path prefix that the host volume must match. It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.
  
  Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#path_prefix PodSecurityPolicyV1Beta1#path_prefix}
    */
    readonly pathPrefix: string;
    /**
    * when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#read_only PodSecurityPolicyV1Beta1#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podSecurityPolicyV1Beta1SpecAllowedHostPathsToTerraform(struct?: PodSecurityPolicyV1Beta1SpecAllowedHostPaths | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecAllowedHostPathsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecAllowedHostPaths | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecAllowedHostPaths | cdktf.IResolvable | undefined);
    private _pathPrefix?;
    get pathPrefix(): string;
    set pathPrefix(value: string);
    get pathPrefixInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecAllowedHostPathsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecAllowedHostPaths[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecAllowedHostPathsOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecFsGroupRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#max PodSecurityPolicyV1Beta1#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#min PodSecurityPolicyV1Beta1#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicyV1Beta1SpecFsGroupRangeToTerraform(struct?: PodSecurityPolicyV1Beta1SpecFsGroupRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecFsGroupRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecFsGroupRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecFsGroupRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecFsGroupRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecFsGroupRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecFsGroupRangeOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecFsGroup {
    /**
    * rule is the strategy that will dictate what FSGroup is used in the SecurityContext.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#rule PodSecurityPolicyV1Beta1#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#range PodSecurityPolicyV1Beta1#range}
    */
    readonly range?: PodSecurityPolicyV1Beta1SpecFsGroupRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicyV1Beta1SpecFsGroupToTerraform(struct?: PodSecurityPolicyV1Beta1SpecFsGroupOutputReference | PodSecurityPolicyV1Beta1SpecFsGroup): any;
export declare class PodSecurityPolicyV1Beta1SpecFsGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyV1Beta1SpecFsGroup | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecFsGroup | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicyV1Beta1SpecFsGroupRangeList;
    putRange(value: PodSecurityPolicyV1Beta1SpecFsGroupRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecFsGroupRange[] | undefined;
}
export interface PodSecurityPolicyV1Beta1SpecHostPorts {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#max PodSecurityPolicyV1Beta1#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#min PodSecurityPolicyV1Beta1#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicyV1Beta1SpecHostPortsToTerraform(struct?: PodSecurityPolicyV1Beta1SpecHostPorts | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecHostPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecHostPorts | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecHostPorts | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecHostPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecHostPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecHostPortsOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecRunAsGroupRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#max PodSecurityPolicyV1Beta1#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#min PodSecurityPolicyV1Beta1#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicyV1Beta1SpecRunAsGroupRangeToTerraform(struct?: PodSecurityPolicyV1Beta1SpecRunAsGroupRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecRunAsGroupRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecRunAsGroupRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecRunAsGroupRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecRunAsGroupRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecRunAsGroupRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecRunAsGroupRangeOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecRunAsGroup {
    /**
    * rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#rule PodSecurityPolicyV1Beta1#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#range PodSecurityPolicyV1Beta1#range}
    */
    readonly range?: PodSecurityPolicyV1Beta1SpecRunAsGroupRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicyV1Beta1SpecRunAsGroupToTerraform(struct?: PodSecurityPolicyV1Beta1SpecRunAsGroupOutputReference | PodSecurityPolicyV1Beta1SpecRunAsGroup): any;
export declare class PodSecurityPolicyV1Beta1SpecRunAsGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyV1Beta1SpecRunAsGroup | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecRunAsGroup | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicyV1Beta1SpecRunAsGroupRangeList;
    putRange(value: PodSecurityPolicyV1Beta1SpecRunAsGroupRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecRunAsGroupRange[] | undefined;
}
export interface PodSecurityPolicyV1Beta1SpecRunAsUserRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#max PodSecurityPolicyV1Beta1#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#min PodSecurityPolicyV1Beta1#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicyV1Beta1SpecRunAsUserRangeToTerraform(struct?: PodSecurityPolicyV1Beta1SpecRunAsUserRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecRunAsUserRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecRunAsUserRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecRunAsUserRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecRunAsUserRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecRunAsUserRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecRunAsUserRangeOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecRunAsUser {
    /**
    * rule is the strategy that will dictate the allowable RunAsUser values that may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#rule PodSecurityPolicyV1Beta1#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#range PodSecurityPolicyV1Beta1#range}
    */
    readonly range?: PodSecurityPolicyV1Beta1SpecRunAsUserRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicyV1Beta1SpecRunAsUserToTerraform(struct?: PodSecurityPolicyV1Beta1SpecRunAsUserOutputReference | PodSecurityPolicyV1Beta1SpecRunAsUser): any;
export declare class PodSecurityPolicyV1Beta1SpecRunAsUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyV1Beta1SpecRunAsUser | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecRunAsUser | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicyV1Beta1SpecRunAsUserRangeList;
    putRange(value: PodSecurityPolicyV1Beta1SpecRunAsUserRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecRunAsUserRange[] | undefined;
}
export interface PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#level PodSecurityPolicyV1Beta1#level}
    */
    readonly level: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#role PodSecurityPolicyV1Beta1#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#type PodSecurityPolicyV1Beta1#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#user PodSecurityPolicyV1Beta1#user}
    */
    readonly user: string;
}
export declare function podSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptionsToTerraform(struct?: PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions | cdktf.IResolvable | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptionsOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecSeLinux {
    /**
    * rule is the strategy that will dictate the allowable labels that may be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#rule PodSecurityPolicyV1Beta1#rule}
    */
    readonly rule: string;
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#se_linux_options PodSecurityPolicyV1Beta1#se_linux_options}
    */
    readonly seLinuxOptions?: PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions[] | cdktf.IResolvable;
}
export declare function podSecurityPolicyV1Beta1SpecSeLinuxToTerraform(struct?: PodSecurityPolicyV1Beta1SpecSeLinuxOutputReference | PodSecurityPolicyV1Beta1SpecSeLinux): any;
export declare class PodSecurityPolicyV1Beta1SpecSeLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyV1Beta1SpecSeLinux | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecSeLinux | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptionsList;
    putSeLinuxOptions(value: PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions[] | cdktf.IResolvable): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecSeLinuxSeLinuxOptions[] | undefined;
}
export interface PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange {
    /**
    * max is the end of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#max PodSecurityPolicyV1Beta1#max}
    */
    readonly max: number;
    /**
    * min is the start of the range, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#min PodSecurityPolicyV1Beta1#min}
    */
    readonly min: number;
}
export declare function podSecurityPolicyV1Beta1SpecSupplementalGroupsRangeToTerraform(struct?: PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange | cdktf.IResolvable): any;
export declare class PodSecurityPolicyV1Beta1SpecSupplementalGroupsRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange | cdktf.IResolvable | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange | cdktf.IResolvable | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    get minInput(): number | undefined;
}
export declare class PodSecurityPolicyV1Beta1SpecSupplementalGroupsRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSecurityPolicyV1Beta1SpecSupplementalGroupsRangeOutputReference;
}
export interface PodSecurityPolicyV1Beta1SpecSupplementalGroups {
    /**
    * rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#rule PodSecurityPolicyV1Beta1#rule}
    */
    readonly rule: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#range PodSecurityPolicyV1Beta1#range}
    */
    readonly range?: PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange[] | cdktf.IResolvable;
}
export declare function podSecurityPolicyV1Beta1SpecSupplementalGroupsToTerraform(struct?: PodSecurityPolicyV1Beta1SpecSupplementalGroupsOutputReference | PodSecurityPolicyV1Beta1SpecSupplementalGroups): any;
export declare class PodSecurityPolicyV1Beta1SpecSupplementalGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyV1Beta1SpecSupplementalGroups | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1SpecSupplementalGroups | undefined);
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _range;
    get range(): PodSecurityPolicyV1Beta1SpecSupplementalGroupsRangeList;
    putRange(value: PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange[] | cdktf.IResolvable): void;
    resetRange(): void;
    get rangeInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecSupplementalGroupsRange[] | undefined;
}
export interface PodSecurityPolicyV1Beta1Spec {
    /**
    * allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#allow_privilege_escalation PodSecurityPolicyV1Beta1#allow_privilege_escalation}
    */
    readonly allowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#allowed_capabilities PodSecurityPolicyV1Beta1#allowed_capabilities}
    */
    readonly allowedCapabilities?: string[];
    /**
    * AllowedProcMountTypes is an allowlist of allowed ProcMountTypes. Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#allowed_proc_mount_types PodSecurityPolicyV1Beta1#allowed_proc_mount_types}
    */
    readonly allowedProcMountTypes?: string[];
    /**
    * allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to allowlist all allowed unsafe sysctls explicitly to avoid rejection.
  
  Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#allowed_unsafe_sysctls PodSecurityPolicyV1Beta1#allowed_unsafe_sysctls}
    */
    readonly allowedUnsafeSysctls?: string[];
    /**
    * defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#default_add_capabilities PodSecurityPolicyV1Beta1#default_add_capabilities}
    */
    readonly defaultAddCapabilities?: string[];
    /**
    * defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#default_allow_privilege_escalation PodSecurityPolicyV1Beta1#default_allow_privilege_escalation}
    */
    readonly defaultAllowPrivilegeEscalation?: boolean | cdktf.IResolvable;
    /**
    * forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.
  
  Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#forbidden_sysctls PodSecurityPolicyV1Beta1#forbidden_sysctls}
    */
    readonly forbiddenSysctls?: string[];
    /**
    * hostIPC determines if the policy allows the use of HostIPC in the pod spec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#host_ipc PodSecurityPolicyV1Beta1#host_ipc}
    */
    readonly hostIpc?: boolean | cdktf.IResolvable;
    /**
    * hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#host_network PodSecurityPolicyV1Beta1#host_network}
    */
    readonly hostNetwork?: boolean | cdktf.IResolvable;
    /**
    * hostPID determines if the policy allows the use of HostPID in the pod spec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#host_pid PodSecurityPolicyV1Beta1#host_pid}
    */
    readonly hostPid?: boolean | cdktf.IResolvable;
    /**
    * privileged determines if a pod can request to be run as privileged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#privileged PodSecurityPolicyV1Beta1#privileged}
    */
    readonly privileged?: boolean | cdktf.IResolvable;
    /**
    * readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#read_only_root_filesystem PodSecurityPolicyV1Beta1#read_only_root_filesystem}
    */
    readonly readOnlyRootFilesystem?: boolean | cdktf.IResolvable;
    /**
    * requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#required_drop_capabilities PodSecurityPolicyV1Beta1#required_drop_capabilities}
    */
    readonly requiredDropCapabilities?: string[];
    /**
    * volumes is an allowlist of volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#volumes PodSecurityPolicyV1Beta1#volumes}
    */
    readonly volumes?: string[];
    /**
    * allowed_flex_volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#allowed_flex_volumes PodSecurityPolicyV1Beta1#allowed_flex_volumes}
    */
    readonly allowedFlexVolumes?: PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes[] | cdktf.IResolvable;
    /**
    * allowed_host_paths block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#allowed_host_paths PodSecurityPolicyV1Beta1#allowed_host_paths}
    */
    readonly allowedHostPaths?: PodSecurityPolicyV1Beta1SpecAllowedHostPaths[] | cdktf.IResolvable;
    /**
    * fs_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#fs_group PodSecurityPolicyV1Beta1#fs_group}
    */
    readonly fsGroup: PodSecurityPolicyV1Beta1SpecFsGroup;
    /**
    * host_ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#host_ports PodSecurityPolicyV1Beta1#host_ports}
    */
    readonly hostPorts?: PodSecurityPolicyV1Beta1SpecHostPorts[] | cdktf.IResolvable;
    /**
    * run_as_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#run_as_group PodSecurityPolicyV1Beta1#run_as_group}
    */
    readonly runAsGroup?: PodSecurityPolicyV1Beta1SpecRunAsGroup;
    /**
    * run_as_user block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#run_as_user PodSecurityPolicyV1Beta1#run_as_user}
    */
    readonly runAsUser: PodSecurityPolicyV1Beta1SpecRunAsUser;
    /**
    * se_linux block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#se_linux PodSecurityPolicyV1Beta1#se_linux}
    */
    readonly seLinux?: PodSecurityPolicyV1Beta1SpecSeLinux;
    /**
    * supplemental_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1#supplemental_groups PodSecurityPolicyV1Beta1#supplemental_groups}
    */
    readonly supplementalGroups: PodSecurityPolicyV1Beta1SpecSupplementalGroups;
}
export declare function podSecurityPolicyV1Beta1SpecToTerraform(struct?: PodSecurityPolicyV1Beta1SpecOutputReference | PodSecurityPolicyV1Beta1Spec): any;
export declare class PodSecurityPolicyV1Beta1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSecurityPolicyV1Beta1Spec | undefined;
    set internalValue(value: PodSecurityPolicyV1Beta1Spec | undefined);
    private _allowPrivilegeEscalation?;
    get allowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set allowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetAllowPrivilegeEscalation(): void;
    get allowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedCapabilities?;
    get allowedCapabilities(): string[];
    set allowedCapabilities(value: string[]);
    resetAllowedCapabilities(): void;
    get allowedCapabilitiesInput(): string[] | undefined;
    private _allowedProcMountTypes?;
    get allowedProcMountTypes(): string[];
    set allowedProcMountTypes(value: string[]);
    resetAllowedProcMountTypes(): void;
    get allowedProcMountTypesInput(): string[] | undefined;
    private _allowedUnsafeSysctls?;
    get allowedUnsafeSysctls(): string[];
    set allowedUnsafeSysctls(value: string[]);
    resetAllowedUnsafeSysctls(): void;
    get allowedUnsafeSysctlsInput(): string[] | undefined;
    private _defaultAddCapabilities?;
    get defaultAddCapabilities(): string[];
    set defaultAddCapabilities(value: string[]);
    resetDefaultAddCapabilities(): void;
    get defaultAddCapabilitiesInput(): string[] | undefined;
    private _defaultAllowPrivilegeEscalation?;
    get defaultAllowPrivilegeEscalation(): boolean | cdktf.IResolvable;
    set defaultAllowPrivilegeEscalation(value: boolean | cdktf.IResolvable);
    resetDefaultAllowPrivilegeEscalation(): void;
    get defaultAllowPrivilegeEscalationInput(): boolean | cdktf.IResolvable | undefined;
    private _forbiddenSysctls?;
    get forbiddenSysctls(): string[];
    set forbiddenSysctls(value: string[]);
    resetForbiddenSysctls(): void;
    get forbiddenSysctlsInput(): string[] | undefined;
    private _hostIpc?;
    get hostIpc(): boolean | cdktf.IResolvable;
    set hostIpc(value: boolean | cdktf.IResolvable);
    resetHostIpc(): void;
    get hostIpcInput(): boolean | cdktf.IResolvable | undefined;
    private _hostNetwork?;
    get hostNetwork(): boolean | cdktf.IResolvable;
    set hostNetwork(value: boolean | cdktf.IResolvable);
    resetHostNetwork(): void;
    get hostNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _hostPid?;
    get hostPid(): boolean | cdktf.IResolvable;
    set hostPid(value: boolean | cdktf.IResolvable);
    resetHostPid(): void;
    get hostPidInput(): boolean | cdktf.IResolvable | undefined;
    private _privileged?;
    get privileged(): boolean | cdktf.IResolvable;
    set privileged(value: boolean | cdktf.IResolvable);
    resetPrivileged(): void;
    get privilegedInput(): boolean | cdktf.IResolvable | undefined;
    private _readOnlyRootFilesystem?;
    get readOnlyRootFilesystem(): boolean | cdktf.IResolvable;
    set readOnlyRootFilesystem(value: boolean | cdktf.IResolvable);
    resetReadOnlyRootFilesystem(): void;
    get readOnlyRootFilesystemInput(): boolean | cdktf.IResolvable | undefined;
    private _requiredDropCapabilities?;
    get requiredDropCapabilities(): string[];
    set requiredDropCapabilities(value: string[]);
    resetRequiredDropCapabilities(): void;
    get requiredDropCapabilitiesInput(): string[] | undefined;
    private _volumes?;
    get volumes(): string[];
    set volumes(value: string[]);
    resetVolumes(): void;
    get volumesInput(): string[] | undefined;
    private _allowedFlexVolumes;
    get allowedFlexVolumes(): PodSecurityPolicyV1Beta1SpecAllowedFlexVolumesList;
    putAllowedFlexVolumes(value: PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes[] | cdktf.IResolvable): void;
    resetAllowedFlexVolumes(): void;
    get allowedFlexVolumesInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecAllowedFlexVolumes[] | undefined;
    private _allowedHostPaths;
    get allowedHostPaths(): PodSecurityPolicyV1Beta1SpecAllowedHostPathsList;
    putAllowedHostPaths(value: PodSecurityPolicyV1Beta1SpecAllowedHostPaths[] | cdktf.IResolvable): void;
    resetAllowedHostPaths(): void;
    get allowedHostPathsInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecAllowedHostPaths[] | undefined;
    private _fsGroup;
    get fsGroup(): PodSecurityPolicyV1Beta1SpecFsGroupOutputReference;
    putFsGroup(value: PodSecurityPolicyV1Beta1SpecFsGroup): void;
    get fsGroupInput(): PodSecurityPolicyV1Beta1SpecFsGroup | undefined;
    private _hostPorts;
    get hostPorts(): PodSecurityPolicyV1Beta1SpecHostPortsList;
    putHostPorts(value: PodSecurityPolicyV1Beta1SpecHostPorts[] | cdktf.IResolvable): void;
    resetHostPorts(): void;
    get hostPortsInput(): cdktf.IResolvable | PodSecurityPolicyV1Beta1SpecHostPorts[] | undefined;
    private _runAsGroup;
    get runAsGroup(): PodSecurityPolicyV1Beta1SpecRunAsGroupOutputReference;
    putRunAsGroup(value: PodSecurityPolicyV1Beta1SpecRunAsGroup): void;
    resetRunAsGroup(): void;
    get runAsGroupInput(): PodSecurityPolicyV1Beta1SpecRunAsGroup | undefined;
    private _runAsUser;
    get runAsUser(): PodSecurityPolicyV1Beta1SpecRunAsUserOutputReference;
    putRunAsUser(value: PodSecurityPolicyV1Beta1SpecRunAsUser): void;
    get runAsUserInput(): PodSecurityPolicyV1Beta1SpecRunAsUser | undefined;
    private _seLinux;
    get seLinux(): PodSecurityPolicyV1Beta1SpecSeLinuxOutputReference;
    putSeLinux(value: PodSecurityPolicyV1Beta1SpecSeLinux): void;
    resetSeLinux(): void;
    get seLinuxInput(): PodSecurityPolicyV1Beta1SpecSeLinux | undefined;
    private _supplementalGroups;
    get supplementalGroups(): PodSecurityPolicyV1Beta1SpecSupplementalGroupsOutputReference;
    putSupplementalGroups(value: PodSecurityPolicyV1Beta1SpecSupplementalGroups): void;
    get supplementalGroupsInput(): PodSecurityPolicyV1Beta1SpecSupplementalGroups | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1 kubernetes_pod_security_policy_v1beta1}
*/
export declare class PodSecurityPolicyV1Beta1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_pod_security_policy_v1beta1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/pod_security_policy_v1beta1 kubernetes_pod_security_policy_v1beta1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PodSecurityPolicyV1Beta1Config
    */
    constructor(scope: Construct, id: string, config: PodSecurityPolicyV1Beta1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): PodSecurityPolicyV1Beta1MetadataOutputReference;
    putMetadata(value: PodSecurityPolicyV1Beta1Metadata): void;
    get metadataInput(): PodSecurityPolicyV1Beta1Metadata | undefined;
    private _spec;
    get spec(): PodSecurityPolicyV1Beta1SpecOutputReference;
    putSpec(value: PodSecurityPolicyV1Beta1Spec): void;
    get specInput(): PodSecurityPolicyV1Beta1Spec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
