import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IngressConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#id Ingress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Terraform will wait for the load balancer to have at least 1 endpoint before considering the resource created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#wait_for_load_balancer Ingress#wait_for_load_balancer}
    */
    readonly waitForLoadBalancer?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#metadata Ingress#metadata}
    */
    readonly metadata: IngressMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#spec Ingress#spec}
    */
    readonly spec: IngressSpec;
}
export interface IngressStatusLoadBalancerIngress {
}
export declare function ingressStatusLoadBalancerIngressToTerraform(struct?: IngressStatusLoadBalancerIngress): any;
export declare class IngressStatusLoadBalancerIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressStatusLoadBalancerIngress | undefined;
    set internalValue(value: IngressStatusLoadBalancerIngress | undefined);
    get hostname(): string;
    get ip(): string;
}
export declare class IngressStatusLoadBalancerIngressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressStatusLoadBalancerIngressOutputReference;
}
export interface IngressStatusLoadBalancer {
}
export declare function ingressStatusLoadBalancerToTerraform(struct?: IngressStatusLoadBalancer): any;
export declare class IngressStatusLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressStatusLoadBalancer | undefined;
    set internalValue(value: IngressStatusLoadBalancer | undefined);
    private _ingress;
    get ingress(): IngressStatusLoadBalancerIngressList;
}
export declare class IngressStatusLoadBalancerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressStatusLoadBalancerOutputReference;
}
export interface IngressStatus {
}
export declare function ingressStatusToTerraform(struct?: IngressStatus): any;
export declare class IngressStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressStatus | undefined;
    set internalValue(value: IngressStatus | undefined);
    private _loadBalancer;
    get loadBalancer(): IngressStatusLoadBalancerList;
}
export declare class IngressStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressStatusOutputReference;
}
export interface IngressMetadata {
    /**
    * An unstructured key value map stored with the ingress that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#annotations Ingress#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#generate_name Ingress#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the ingress. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#labels Ingress#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the ingress, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#name Ingress#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the ingress must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#namespace Ingress#namespace}
    */
    readonly namespace?: string;
}
export declare function ingressMetadataToTerraform(struct?: IngressMetadataOutputReference | IngressMetadata): any;
export declare class IngressMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressMetadata | undefined;
    set internalValue(value: IngressMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface IngressSpecBackend {
    /**
    * Specifies the name of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#service_name Ingress#service_name}
    */
    readonly serviceName?: string;
    /**
    * Specifies the port of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#service_port Ingress#service_port}
    */
    readonly servicePort?: string;
}
export declare function ingressSpecBackendToTerraform(struct?: IngressSpecBackendOutputReference | IngressSpecBackend): any;
export declare class IngressSpecBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressSpecBackend | undefined;
    set internalValue(value: IngressSpecBackend | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _servicePort?;
    get servicePort(): string;
    set servicePort(value: string);
    resetServicePort(): void;
    get servicePortInput(): string | undefined;
}
export interface IngressSpecRuleHttpPathBackend {
    /**
    * Specifies the name of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#service_name Ingress#service_name}
    */
    readonly serviceName?: string;
    /**
    * Specifies the port of the referenced service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#service_port Ingress#service_port}
    */
    readonly servicePort?: string;
}
export declare function ingressSpecRuleHttpPathBackendToTerraform(struct?: IngressSpecRuleHttpPathBackendOutputReference | IngressSpecRuleHttpPathBackend): any;
export declare class IngressSpecRuleHttpPathBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressSpecRuleHttpPathBackend | undefined;
    set internalValue(value: IngressSpecRuleHttpPathBackend | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _servicePort?;
    get servicePort(): string;
    set servicePort(value: string);
    resetServicePort(): void;
    get servicePortInput(): string | undefined;
}
export interface IngressSpecRuleHttpPath {
    /**
    * Path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#path Ingress#path}
    */
    readonly path?: string;
    /**
    * backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#backend Ingress#backend}
    */
    readonly backend?: IngressSpecRuleHttpPathBackend;
}
export declare function ingressSpecRuleHttpPathToTerraform(struct?: IngressSpecRuleHttpPath | cdktf.IResolvable): any;
export declare class IngressSpecRuleHttpPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressSpecRuleHttpPath | cdktf.IResolvable | undefined;
    set internalValue(value: IngressSpecRuleHttpPath | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _backend;
    get backend(): IngressSpecRuleHttpPathBackendOutputReference;
    putBackend(value: IngressSpecRuleHttpPathBackend): void;
    resetBackend(): void;
    get backendInput(): IngressSpecRuleHttpPathBackend | undefined;
}
export declare class IngressSpecRuleHttpPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IngressSpecRuleHttpPath[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressSpecRuleHttpPathOutputReference;
}
export interface IngressSpecRuleHttp {
    /**
    * path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#path Ingress#path}
    */
    readonly path: IngressSpecRuleHttpPath[] | cdktf.IResolvable;
}
export declare function ingressSpecRuleHttpToTerraform(struct?: IngressSpecRuleHttpOutputReference | IngressSpecRuleHttp): any;
export declare class IngressSpecRuleHttpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressSpecRuleHttp | undefined;
    set internalValue(value: IngressSpecRuleHttp | undefined);
    private _path;
    get path(): IngressSpecRuleHttpPathList;
    putPath(value: IngressSpecRuleHttpPath[] | cdktf.IResolvable): void;
    get pathInput(): cdktf.IResolvable | IngressSpecRuleHttpPath[] | undefined;
}
export interface IngressSpecRule {
    /**
    * Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     the IP in the Spec of the parent Ingress.
  2. The `:` delimiter is not respected because ports are not allowed.
        Currently the port of an Ingress is implicitly :80 for http and
        :443 for https.
  Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
  
  Host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#host Ingress#host}
    */
    readonly host?: string;
    /**
    * http block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#http Ingress#http}
    */
    readonly http: IngressSpecRuleHttp;
}
export declare function ingressSpecRuleToTerraform(struct?: IngressSpecRule | cdktf.IResolvable): any;
export declare class IngressSpecRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressSpecRule | cdktf.IResolvable | undefined;
    set internalValue(value: IngressSpecRule | cdktf.IResolvable | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _http;
    get http(): IngressSpecRuleHttpOutputReference;
    putHttp(value: IngressSpecRuleHttp): void;
    get httpInput(): IngressSpecRuleHttp | undefined;
}
export declare class IngressSpecRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IngressSpecRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressSpecRuleOutputReference;
}
export interface IngressSpecTls {
    /**
    * Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#hosts Ingress#hosts}
    */
    readonly hosts?: string[];
    /**
    * SecretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#secret_name Ingress#secret_name}
    */
    readonly secretName?: string;
}
export declare function ingressSpecTlsToTerraform(struct?: IngressSpecTls | cdktf.IResolvable): any;
export declare class IngressSpecTlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IngressSpecTls | cdktf.IResolvable | undefined;
    set internalValue(value: IngressSpecTls | cdktf.IResolvable | undefined);
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    resetHosts(): void;
    get hostsInput(): string[] | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
}
export declare class IngressSpecTlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IngressSpecTls[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IngressSpecTlsOutputReference;
}
export interface IngressSpec {
    /**
    * IngressClassName is the name of the IngressClass cluster resource. The associated IngressClass defines which controller will implement the resource. This replaces the deprecated `kubernetes.io/ingress.class` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#ingress_class_name Ingress#ingress_class_name}
    */
    readonly ingressClassName?: string;
    /**
    * backend block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#backend Ingress#backend}
    */
    readonly backend?: IngressSpecBackend;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#rule Ingress#rule}
    */
    readonly rule?: IngressSpecRule[] | cdktf.IResolvable;
    /**
    * tls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress#tls Ingress#tls}
    */
    readonly tls?: IngressSpecTls[] | cdktf.IResolvable;
}
export declare function ingressSpecToTerraform(struct?: IngressSpecOutputReference | IngressSpec): any;
export declare class IngressSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IngressSpec | undefined;
    set internalValue(value: IngressSpec | undefined);
    private _ingressClassName?;
    get ingressClassName(): string;
    set ingressClassName(value: string);
    resetIngressClassName(): void;
    get ingressClassNameInput(): string | undefined;
    private _backend;
    get backend(): IngressSpecBackendOutputReference;
    putBackend(value: IngressSpecBackend): void;
    resetBackend(): void;
    get backendInput(): IngressSpecBackend | undefined;
    private _rule;
    get rule(): IngressSpecRuleList;
    putRule(value: IngressSpecRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | IngressSpecRule[] | undefined;
    private _tls;
    get tls(): IngressSpecTlsList;
    putTls(value: IngressSpecTls[] | cdktf.IResolvable): void;
    resetTls(): void;
    get tlsInput(): cdktf.IResolvable | IngressSpecTls[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress kubernetes_ingress}
*/
export declare class Ingress extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_ingress";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/ingress kubernetes_ingress} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IngressConfig
    */
    constructor(scope: Construct, id: string, config: IngressConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _status;
    get status(): IngressStatusList;
    private _waitForLoadBalancer?;
    get waitForLoadBalancer(): boolean | cdktf.IResolvable;
    set waitForLoadBalancer(value: boolean | cdktf.IResolvable);
    resetWaitForLoadBalancer(): void;
    get waitForLoadBalancerInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): IngressMetadataOutputReference;
    putMetadata(value: IngressMetadata): void;
    get metadataInput(): IngressMetadata | undefined;
    private _spec;
    get spec(): IngressSpecOutputReference;
    putSpec(value: IngressSpec): void;
    get specInput(): IngressSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
