import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account#id DataKubernetesServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account#metadata DataKubernetesServiceAccount#metadata}
    */
    readonly metadata: DataKubernetesServiceAccountMetadata;
}
export interface DataKubernetesServiceAccountImagePullSecret {
}
export declare function dataKubernetesServiceAccountImagePullSecretToTerraform(struct?: DataKubernetesServiceAccountImagePullSecret): any;
export declare class DataKubernetesServiceAccountImagePullSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceAccountImagePullSecret | undefined;
    set internalValue(value: DataKubernetesServiceAccountImagePullSecret | undefined);
    get name(): string;
}
export declare class DataKubernetesServiceAccountImagePullSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceAccountImagePullSecretOutputReference;
}
export interface DataKubernetesServiceAccountSecret {
}
export declare function dataKubernetesServiceAccountSecretToTerraform(struct?: DataKubernetesServiceAccountSecret): any;
export declare class DataKubernetesServiceAccountSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceAccountSecret | undefined;
    set internalValue(value: DataKubernetesServiceAccountSecret | undefined);
    get name(): string;
}
export declare class DataKubernetesServiceAccountSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceAccountSecretOutputReference;
}
export interface DataKubernetesServiceAccountMetadata {
    /**
    * An unstructured key value map stored with the service account that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account#annotations DataKubernetesServiceAccount#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the service account. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account#labels DataKubernetesServiceAccount#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the service account, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account#name DataKubernetesServiceAccount#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the service account must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account#namespace DataKubernetesServiceAccount#namespace}
    */
    readonly namespace?: string;
}
export declare function dataKubernetesServiceAccountMetadataToTerraform(struct?: DataKubernetesServiceAccountMetadataOutputReference | DataKubernetesServiceAccountMetadata): any;
export declare class DataKubernetesServiceAccountMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesServiceAccountMetadata | undefined;
    set internalValue(value: DataKubernetesServiceAccountMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account kubernetes_service_account}
*/
export declare class DataKubernetesServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_service_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account kubernetes_service_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesServiceAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataKubernetesServiceAccountConfig);
    get automountServiceAccountToken(): cdktf.IResolvable;
    get defaultSecretName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imagePullSecret;
    get imagePullSecret(): DataKubernetesServiceAccountImagePullSecretList;
    private _secret;
    get secret(): DataKubernetesServiceAccountSecretList;
    private _metadata;
    get metadata(): DataKubernetesServiceAccountMetadataOutputReference;
    putMetadata(value: DataKubernetesServiceAccountMetadata): void;
    get metadataInput(): DataKubernetesServiceAccountMetadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
