import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesServiceAccountV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1#id DataKubernetesServiceAccountV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1#metadata DataKubernetesServiceAccountV1#metadata}
    */
    readonly metadata: DataKubernetesServiceAccountV1Metadata;
}
export interface DataKubernetesServiceAccountV1ImagePullSecret {
}
export declare function dataKubernetesServiceAccountV1ImagePullSecretToTerraform(struct?: DataKubernetesServiceAccountV1ImagePullSecret): any;
export declare class DataKubernetesServiceAccountV1ImagePullSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceAccountV1ImagePullSecret | undefined;
    set internalValue(value: DataKubernetesServiceAccountV1ImagePullSecret | undefined);
    get name(): string;
}
export declare class DataKubernetesServiceAccountV1ImagePullSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceAccountV1ImagePullSecretOutputReference;
}
export interface DataKubernetesServiceAccountV1Secret {
}
export declare function dataKubernetesServiceAccountV1SecretToTerraform(struct?: DataKubernetesServiceAccountV1Secret): any;
export declare class DataKubernetesServiceAccountV1SecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataKubernetesServiceAccountV1Secret | undefined;
    set internalValue(value: DataKubernetesServiceAccountV1Secret | undefined);
    get name(): string;
}
export declare class DataKubernetesServiceAccountV1SecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataKubernetesServiceAccountV1SecretOutputReference;
}
export interface DataKubernetesServiceAccountV1Metadata {
    /**
    * An unstructured key value map stored with the service account that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1#annotations DataKubernetesServiceAccountV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the service account. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1#labels DataKubernetesServiceAccountV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the service account, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1#name DataKubernetesServiceAccountV1#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the service account must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1#namespace DataKubernetesServiceAccountV1#namespace}
    */
    readonly namespace?: string;
}
export declare function dataKubernetesServiceAccountV1MetadataToTerraform(struct?: DataKubernetesServiceAccountV1MetadataOutputReference | DataKubernetesServiceAccountV1Metadata): any;
export declare class DataKubernetesServiceAccountV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesServiceAccountV1Metadata | undefined;
    set internalValue(value: DataKubernetesServiceAccountV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1 kubernetes_service_account_v1}
*/
export declare class DataKubernetesServiceAccountV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_service_account_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/service_account_v1 kubernetes_service_account_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesServiceAccountV1Config
    */
    constructor(scope: Construct, id: string, config: DataKubernetesServiceAccountV1Config);
    get automountServiceAccountToken(): cdktf.IResolvable;
    get defaultSecretName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imagePullSecret;
    get imagePullSecret(): DataKubernetesServiceAccountV1ImagePullSecretList;
    private _secret;
    get secret(): DataKubernetesServiceAccountV1SecretList;
    private _metadata;
    get metadata(): DataKubernetesServiceAccountV1MetadataOutputReference;
    putMetadata(value: DataKubernetesServiceAccountV1Metadata): void;
    get metadataInput(): DataKubernetesServiceAccountV1Metadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
