import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataKubernetesSecretV1Config extends cdktf.TerraformMetaArguments {
    /**
    * A map of the secret data with values encoded in base64 format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1#binary_data DataKubernetesSecretV1#binary_data}
    */
    readonly binaryData?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1#id DataKubernetesSecretV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1#metadata DataKubernetesSecretV1#metadata}
    */
    readonly metadata: DataKubernetesSecretV1Metadata;
}
export interface DataKubernetesSecretV1Metadata {
    /**
    * An unstructured key value map stored with the secret that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1#annotations DataKubernetesSecretV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the secret. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1#labels DataKubernetesSecretV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the secret, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1#name DataKubernetesSecretV1#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the secret must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1#namespace DataKubernetesSecretV1#namespace}
    */
    readonly namespace?: string;
}
export declare function dataKubernetesSecretV1MetadataToTerraform(struct?: DataKubernetesSecretV1MetadataOutputReference | DataKubernetesSecretV1Metadata): any;
export declare class DataKubernetesSecretV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataKubernetesSecretV1Metadata | undefined;
    set internalValue(value: DataKubernetesSecretV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1 kubernetes_secret_v1}
*/
export declare class DataKubernetesSecretV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "kubernetes_secret_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/d/secret_v1 kubernetes_secret_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataKubernetesSecretV1Config
    */
    constructor(scope: Construct, id: string, config: DataKubernetesSecretV1Config);
    private _binaryData?;
    get binaryData(): {
        [key: string]: string;
    };
    set binaryData(value: {
        [key: string]: string;
    });
    resetBinaryData(): void;
    get binaryDataInput(): {
        [key: string]: string;
    } | undefined;
    private _data;
    get data(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get immutable(): cdktf.IResolvable;
    get type(): string;
    private _metadata;
    get metadata(): DataKubernetesSecretV1MetadataOutputReference;
    putMetadata(value: DataKubernetesSecretV1Metadata): void;
    get metadataInput(): DataKubernetesSecretV1Metadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
