import { DaemonSetV1Metadata, DaemonSetV1MetadataOutputReference, DaemonSetV1Spec, DaemonSetV1SpecOutputReference, DaemonSetV1Timeouts, DaemonSetV1TimeoutsOutputReference } from './daemon-set-v1-structs';
export * from './daemon-set-v1-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DaemonSetV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemon_set_v1#id DaemonSetV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Wait for the rollout of the deployment to complete. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemon_set_v1#wait_for_rollout DaemonSetV1#wait_for_rollout}
    */
    readonly waitForRollout?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemon_set_v1#metadata DaemonSetV1#metadata}
    */
    readonly metadata: DaemonSetV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemon_set_v1#spec DaemonSetV1#spec}
    */
    readonly spec: DaemonSetV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/daemon_set_v1#timeouts DaemonSetV1#timeouts}
    */
    readonly timeouts?: DaemonSetV1Timeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/daemon_set_v1 kubernetes_daemon_set_v1}
*/
export declare class DaemonSetV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_daemon_set_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/daemon_set_v1 kubernetes_daemon_set_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DaemonSetV1Config
    */
    constructor(scope: Construct, id: string, config: DaemonSetV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForRollout?;
    get waitForRollout(): boolean | cdktf.IResolvable;
    set waitForRollout(value: boolean | cdktf.IResolvable);
    resetWaitForRollout(): void;
    get waitForRolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): DaemonSetV1MetadataOutputReference;
    putMetadata(value: DaemonSetV1Metadata): void;
    get metadataInput(): DaemonSetV1Metadata | undefined;
    private _spec;
    get spec(): DaemonSetV1SpecOutputReference;
    putSpec(value: DaemonSetV1Spec): void;
    get specInput(): DaemonSetV1Spec | undefined;
    private _timeouts;
    get timeouts(): DaemonSetV1TimeoutsOutputReference;
    putTimeouts(value: DaemonSetV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DaemonSetV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
