# pytoolkit

[![Python](https://img.shields.io/badge/Python-3.6%20%7C%203.7%20%7C%203.8-green.svg)](https://www.python.org/)
[![PyPI version](https://badge.fury.io/py/pytoolkit42.svg)](https://badge.fury.io/py/pytoolkit42)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Docs](https://readthedocs.org/projects/pytoolkit42/badge/?version=latest)](https://pytoolkit42.readthedocs.io/en/latest)
[![GitHub Activity](https://img.shields.io/github/commit-activity/y/HazardDede/pytoolkit.svg)](https://github.com/HazardDede/pytoolkit/commits/main)
[![Build Status](https://travis-ci.org/HazardDede/pytoolkit.svg?branch=main)](https://travis-ci.org/HazardDede/pytoolkit)
[![Coverage Status](https://coveralls.io/repos/github/HazardDede/pytoolkit/badge.svg?branch=main)](https://coveralls.io/github/HazardDede/pytoolkit?branch=main)
![Project Maintenance](https://img.shields.io/badge/maintainer-Dennis%20Muth%20%40HazardDede-blue.svg)


> Collection of useful utilities and tools for python projects

## Installation

```bash
pip install pytoolkit42
```

## Purpose

Pretty much every utility stuff you could imagine is already written down in some python package.
But almost every time these stuff is part of a heavyweight framework with a lots of
dependencies. And on top they do it in a slightly different way - you would do it - because it
is tailored to their needs.

This is why I made up this `Yet Another Utility Package` called `pytoolkit42`.
I want this `toolkit` to be

* lightweight and
* easy to use

Right now it does not have the answer to every problem you will encounter, but it serves
well to solve problems I stumble upon on a regular basis.

The collection of functions, classes, decorator, mixins will grow when I come up with a
solution that seems to be of use for everybody else out there.

But to be honest: I try to make this package as generic as possible so it might be useful to you,
but I cannot promise. Nevertheless you are encouraged to make PRs.

## Manual

The manual is available at Read the Docs:

  [https://pytoolkit42.readthedocs.io/en/latest/](https://pytoolkit42.readthedocs.io/en/latest/)