# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6320, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.core import PipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

from ._configuration import SimulatorAPIConfiguration
from .operations import SessionOperations
from . import models


class SimulatorAPI(object):
    """This API allows simulators to provide states and receive commands from the platform.

    :ivar session: SessionOperations operations
    :vartype session: microsoft_bonsai_api.simulator.generated.operations.SessionOperations
    :param str base_url: Service URL
    """

    def __init__(
        self,
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = "https://api.bons.ai"
        self._config = SimulatorAPIConfiguration(**kwargs)
        self._client = PipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {
            k: v for k, v in models.__dict__.items() if isinstance(v, type)
        }
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.session = SessionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> SimulatorAPI
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
