# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetProductResult',
    'AwaitableGetProductResult',
    'get_product',
    'get_product_output',
]

@pulumi.output_type
class GetProductResult:
    def __init__(__self__, description=None, display_name=None, name=None, product_category=None, product_labels=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if product_category and not isinstance(product_category, str):
            raise TypeError("Expected argument 'product_category' to be a str")
        pulumi.set(__self__, "product_category", product_category)
        if product_labels and not isinstance(product_labels, list):
            raise TypeError("Expected argument 'product_labels' to be a list")
        pulumi.set(__self__, "product_labels", product_labels)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User-provided metadata to be stored with this product. Must be at most 4096 characters long.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-provided name for this Product. Must not be empty. Must be at most 4096 characters long.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the product. Format is: `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`. This field is ignored when creating a product.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productCategory")
    def product_category(self) -> str:
        """
        Immutable. The category for the product identified by the reference image. This should be one of "homegoods-v2", "apparel-v2", "toys-v2", "packagedgoods-v1" or "general-v1". The legacy categories "homegoods", "apparel", and "toys" are still supported, but these should not be used for new products.
        """
        return pulumi.get(self, "product_category")

    @property
    @pulumi.getter(name="productLabels")
    def product_labels(self) -> Sequence['outputs.KeyValueResponse']:
        """
        Key-value pairs that can be attached to a product. At query time, constraints can be specified based on the product_labels. Note that integer values can be provided as strings, e.g. "1199". Only strings with integer values can match a range-based restriction which is to be supported soon. Multiple values can be assigned to the same key. One product may have up to 500 product_labels. Notice that the total number of distinct product_labels over all products in one ProductSet cannot exceed 1M, otherwise the product search pipeline will refuse to work for that ProductSet.
        """
        return pulumi.get(self, "product_labels")


class AwaitableGetProductResult(GetProductResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductResult(
            description=self.description,
            display_name=self.display_name,
            name=self.name,
            product_category=self.product_category,
            product_labels=self.product_labels)


def get_product(location: Optional[str] = None,
                product_id: Optional[str] = None,
                project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductResult:
    """
    Gets information associated with a Product. Possible errors: * Returns NOT_FOUND if the Product does not exist.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['productId'] = product_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:vision/v1:getProduct', __args__, opts=opts, typ=GetProductResult).value

    return AwaitableGetProductResult(
        description=__ret__.description,
        display_name=__ret__.display_name,
        name=__ret__.name,
        product_category=__ret__.product_category,
        product_labels=__ret__.product_labels)


@_utilities.lift_output_func(get_product)
def get_product_output(location: Optional[pulumi.Input[str]] = None,
                       product_id: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProductResult]:
    """
    Gets information associated with a Product. Possible errors: * Returns NOT_FOUND if the Product does not exist.
    """
    ...
