# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ... import iam as _iam

__all__ = ['ObjectIamMemberArgs', 'ObjectIamMember']

@pulumi.input_type
class ObjectIamMemberArgs:
    def __init__(__self__, *,
                 member: pulumi.Input[str],
                 name: pulumi.Input[str],
                 role: pulumi.Input[str],
                 condition: Optional[pulumi.Input['_iam.v1.ConditionArgs']] = None):
        """
        The set of arguments for constructing a ObjectIamMember resource.
        :param pulumi.Input[str] member: Identity that will be granted the privilege in role. The entry can have one of the following values:
               
                * user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
                * serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
                * group:{emailid}: An email address that represents a Google group. For example, admins@example.com.
                * domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        :param pulumi.Input[str] name: The name of the resource to manage IAM policies for.
        :param pulumi.Input[str] role: The role that should be applied.
        :param pulumi.Input['_iam.v1.ConditionArgs'] condition: An IAM Condition for a given binding.
        """
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role", role)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def member(self) -> pulumi.Input[str]:
        """
        Identity that will be granted the privilege in role. The entry can have one of the following values:

         * user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
         * serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
         * group:{emailid}: An email address that represents a Google group. For example, admins@example.com.
         * domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: pulumi.Input[str]):
        pulumi.set(self, "member", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the resource to manage IAM policies for.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        The role that should be applied.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['_iam.v1.ConditionArgs']]:
        """
        An IAM Condition for a given binding.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['_iam.v1.ConditionArgs']]):
        pulumi.set(self, "condition", value)


class ObjectIamMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[pulumi.InputType['_iam.v1.ConditionArgs']]] = None,
                 member: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Updates an IAM policy for the specified object.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['_iam.v1.ConditionArgs']] condition: An IAM Condition for a given binding.
        :param pulumi.Input[str] member: Identity that will be granted the privilege in role. The entry can have one of the following values:
               
                * user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com.
                * serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com.
                * group:{emailid}: An email address that represents a Google group. For example, admins@example.com.
                * domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
        :param pulumi.Input[str] name: The name of the resource to manage IAM policies for.
        :param pulumi.Input[str] role: The role that should be applied.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectIamMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Updates an IAM policy for the specified object.

        :param str resource_name: The name of the resource.
        :param ObjectIamMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectIamMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 condition: Optional[pulumi.Input[pulumi.InputType['_iam.v1.ConditionArgs']]] = None,
                 member: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectIamMemberArgs.__new__(ObjectIamMemberArgs)

            __props__.__dict__["condition"] = condition
            if member is None and not opts.urn:
                raise TypeError("Missing required property 'member'")
            __props__.__dict__["member"] = member
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["etag"] = None
            __props__.__dict__["project"] = None
        super(ObjectIamMember, __self__).__init__(
            'google-native:storage/v1:ObjectIamMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ObjectIamMember':
        """
        Get an existing ObjectIamMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ObjectIamMemberArgs.__new__(ObjectIamMemberArgs)

        __props__.__dict__["condition"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["member"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["role"] = None
        return ObjectIamMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['_iam.v1.outputs.Condition']]:
        """
        An IAM Condition for a given binding. See https://cloud.google.com/iam/docs/conditions-overview for additional details.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The etag of the resource's IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def member(self) -> pulumi.Output[str]:
        """
        A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
        - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
        - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
        - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
        - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
        - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
        - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
        - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
        - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
        - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        """
        return pulumi.get(self, "member")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource to manage IAM policies for.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project in which the resource belongs. If it is not provided, a default will be supplied.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
        The new IAM roles are:  
        - roles/storage.admin — Full control of Google Cloud Storage resources.  
        - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
        - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
        - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
        - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
        - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
        - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
        - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
        - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        return pulumi.get(self, "role")

