# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceConfigArgs', 'InstanceConfig']

@pulumi.input_type
class InstanceConfigArgs:
    def __init__(__self__, *,
                 instance_config_id: pulumi.Input[str],
                 base_config: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 leader_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaInfoArgs']]]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a InstanceConfig resource.
        :param pulumi.Input[str] instance_config_id: The ID of the instance config to create. Valid identifiers are of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in length. The `custom-` prefix is required to avoid name conflicts with Google managed configurations.
        :param pulumi.Input[str] base_config: Base configuration name, e.g. projects//instanceConfigs/nam3, based on which this configuration is created. Only set for user managed configurations. `base_config` must refer to a configuration of type GOOGLE_MANAGED in the same project as this configuration.
        :param pulumi.Input[str] display_name: The name of this instance configuration as it appears in UIs.
        :param pulumi.Input[str] etag: etag is used for optimistic concurrency control as a way to help prevent simultaneous updates of a instance config from overwriting each other. It is strongly suggested that systems make use of the etag in the read-modify-write cycle to perform instance config updates in order to avoid race conditions: An etag is returned in the response which contains instance configs, and systems are expected to put that etag in the request to update instance config to ensure that their change will be applied to the same version of the instance config. If no etag is provided in the call to update instance config, then the existing instance config is overwritten blindly.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Cloud Labels are a flexible and lightweight mechanism for organizing cloud resources into groups that reflect a customer's organizational needs and deployment strategies. Cloud Labels can be used to filter collections of resources. They can be used to control how resource metrics are aggregated. And they can be used as arguments to policy management rules (e.g. route, firewall, load balancing, etc.). * Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `a-z{0,62}`. * Label values must be between 0 and 63 characters long and must conform to the regular expression `[a-z0-9_-]{0,63}`. * No more than 64 labels can be associated with a given resource. See https://goo.gl/xmQnxf for more information on and examples of labels. If you plan to use labels in your own code, please note that additional characters may be allowed in the future. Therefore, you are advised to use an internal label representation, such as JSON, which doesn't rely upon specific characters being disallowed. For example, representing labels as the string: name + "_" + value would prove problematic if we were to allow "_" in a future release.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] leader_options: Allowed values of the "default_leader" schema option for databases in instances that use this instance configuration.
        :param pulumi.Input[str] name: A unique identifier for the instance configuration. Values are of the form `projects//instanceConfigs/a-z*`.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicaInfoArgs']]] replicas: The geographic placement of nodes in this instance configuration and their replication properties.
        :param pulumi.Input[bool] validate_only: An option to validate, but not actually execute, a request, and provide the same response.
        """
        pulumi.set(__self__, "instance_config_id", instance_config_id)
        if base_config is not None:
            pulumi.set(__self__, "base_config", base_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if leader_options is not None:
            pulumi.set(__self__, "leader_options", leader_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="instanceConfigId")
    def instance_config_id(self) -> pulumi.Input[str]:
        """
        The ID of the instance config to create. Valid identifiers are of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in length. The `custom-` prefix is required to avoid name conflicts with Google managed configurations.
        """
        return pulumi.get(self, "instance_config_id")

    @instance_config_id.setter
    def instance_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_config_id", value)

    @property
    @pulumi.getter(name="baseConfig")
    def base_config(self) -> Optional[pulumi.Input[str]]:
        """
        Base configuration name, e.g. projects//instanceConfigs/nam3, based on which this configuration is created. Only set for user managed configurations. `base_config` must refer to a configuration of type GOOGLE_MANAGED in the same project as this configuration.
        """
        return pulumi.get(self, "base_config")

    @base_config.setter
    def base_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this instance configuration as it appears in UIs.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        etag is used for optimistic concurrency control as a way to help prevent simultaneous updates of a instance config from overwriting each other. It is strongly suggested that systems make use of the etag in the read-modify-write cycle to perform instance config updates in order to avoid race conditions: An etag is returned in the response which contains instance configs, and systems are expected to put that etag in the request to update instance config to ensure that their change will be applied to the same version of the instance config. If no etag is provided in the call to update instance config, then the existing instance config is overwritten blindly.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Cloud Labels are a flexible and lightweight mechanism for organizing cloud resources into groups that reflect a customer's organizational needs and deployment strategies. Cloud Labels can be used to filter collections of resources. They can be used to control how resource metrics are aggregated. And they can be used as arguments to policy management rules (e.g. route, firewall, load balancing, etc.). * Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `a-z{0,62}`. * Label values must be between 0 and 63 characters long and must conform to the regular expression `[a-z0-9_-]{0,63}`. * No more than 64 labels can be associated with a given resource. See https://goo.gl/xmQnxf for more information on and examples of labels. If you plan to use labels in your own code, please note that additional characters may be allowed in the future. Therefore, you are advised to use an internal label representation, such as JSON, which doesn't rely upon specific characters being disallowed. For example, representing labels as the string: name + "_" + value would prove problematic if we were to allow "_" in a future release.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="leaderOptions")
    def leader_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed values of the "default_leader" schema option for databases in instances that use this instance configuration.
        """
        return pulumi.get(self, "leader_options")

    @leader_options.setter
    def leader_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "leader_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the instance configuration. Values are of the form `projects//instanceConfigs/a-z*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaInfoArgs']]]]:
        """
        The geographic placement of nodes in this instance configuration and their replication properties.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicaInfoArgs']]]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[pulumi.Input[bool]]:
        """
        An option to validate, but not actually execute, a request, and provide the same response.
        """
        return pulumi.get(self, "validate_only")

    @validate_only.setter
    def validate_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_only", value)


class InstanceConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_config: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 instance_config_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 leader_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicaInfoArgs']]]]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Creates an instance config and begins preparing it to be used. The returned long-running operation can be used to track the progress of preparing the new instance config. The instance config name is assigned by the caller. If the named instance config already exists, `CreateInstanceConfig` returns `ALREADY_EXISTS`. Immediately after the request returns: * The instance config is readable via the API, with all requested attributes. The instance config's reconciling field is set to true. Its state is `CREATING`. While the operation is pending: * Cancelling the operation renders the instance config immediately unreadable via the API. * Except for deleting the creating resource, all other attempts to modify the instance config are rejected. Upon completion of the returned operation: * Instances can be created using the instance configuration. * The instance config's reconciling field becomes false. Its state becomes `READY`. The returned long-running operation will have a name of the format `/operations/` and can be used to track creation of the instance config. The metadata field type is CreateInstanceConfigMetadata. The response field type is InstanceConfig, if successful. Authorization requires `spanner.instanceConfigs.create` permission on the resource parent.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_config: Base configuration name, e.g. projects//instanceConfigs/nam3, based on which this configuration is created. Only set for user managed configurations. `base_config` must refer to a configuration of type GOOGLE_MANAGED in the same project as this configuration.
        :param pulumi.Input[str] display_name: The name of this instance configuration as it appears in UIs.
        :param pulumi.Input[str] etag: etag is used for optimistic concurrency control as a way to help prevent simultaneous updates of a instance config from overwriting each other. It is strongly suggested that systems make use of the etag in the read-modify-write cycle to perform instance config updates in order to avoid race conditions: An etag is returned in the response which contains instance configs, and systems are expected to put that etag in the request to update instance config to ensure that their change will be applied to the same version of the instance config. If no etag is provided in the call to update instance config, then the existing instance config is overwritten blindly.
        :param pulumi.Input[str] instance_config_id: The ID of the instance config to create. Valid identifiers are of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in length. The `custom-` prefix is required to avoid name conflicts with Google managed configurations.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Cloud Labels are a flexible and lightweight mechanism for organizing cloud resources into groups that reflect a customer's organizational needs and deployment strategies. Cloud Labels can be used to filter collections of resources. They can be used to control how resource metrics are aggregated. And they can be used as arguments to policy management rules (e.g. route, firewall, load balancing, etc.). * Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `a-z{0,62}`. * Label values must be between 0 and 63 characters long and must conform to the regular expression `[a-z0-9_-]{0,63}`. * No more than 64 labels can be associated with a given resource. See https://goo.gl/xmQnxf for more information on and examples of labels. If you plan to use labels in your own code, please note that additional characters may be allowed in the future. Therefore, you are advised to use an internal label representation, such as JSON, which doesn't rely upon specific characters being disallowed. For example, representing labels as the string: name + "_" + value would prove problematic if we were to allow "_" in a future release.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] leader_options: Allowed values of the "default_leader" schema option for databases in instances that use this instance configuration.
        :param pulumi.Input[str] name: A unique identifier for the instance configuration. Values are of the form `projects//instanceConfigs/a-z*`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicaInfoArgs']]]] replicas: The geographic placement of nodes in this instance configuration and their replication properties.
        :param pulumi.Input[bool] validate_only: An option to validate, but not actually execute, a request, and provide the same response.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an instance config and begins preparing it to be used. The returned long-running operation can be used to track the progress of preparing the new instance config. The instance config name is assigned by the caller. If the named instance config already exists, `CreateInstanceConfig` returns `ALREADY_EXISTS`. Immediately after the request returns: * The instance config is readable via the API, with all requested attributes. The instance config's reconciling field is set to true. Its state is `CREATING`. While the operation is pending: * Cancelling the operation renders the instance config immediately unreadable via the API. * Except for deleting the creating resource, all other attempts to modify the instance config are rejected. Upon completion of the returned operation: * Instances can be created using the instance configuration. * The instance config's reconciling field becomes false. Its state becomes `READY`. The returned long-running operation will have a name of the format `/operations/` and can be used to track creation of the instance config. The metadata field type is CreateInstanceConfigMetadata. The response field type is InstanceConfig, if successful. Authorization requires `spanner.instanceConfigs.create` permission on the resource parent.

        :param str resource_name: The name of the resource.
        :param InstanceConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_config: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 instance_config_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 leader_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicaInfoArgs']]]]] = None,
                 validate_only: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceConfigArgs.__new__(InstanceConfigArgs)

            __props__.__dict__["base_config"] = base_config
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["etag"] = etag
            if instance_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_config_id'")
            __props__.__dict__["instance_config_id"] = instance_config_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["leader_options"] = leader_options
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["validate_only"] = validate_only
            __props__.__dict__["config_type"] = None
            __props__.__dict__["free_instance_availability"] = None
            __props__.__dict__["optional_replicas"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InstanceConfig, __self__).__init__(
            'google-native:spanner/v1:InstanceConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InstanceConfig':
        """
        Get an existing InstanceConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceConfigArgs.__new__(InstanceConfigArgs)

        __props__.__dict__["base_config"] = None
        __props__.__dict__["config_type"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["free_instance_availability"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["leader_options"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["optional_replicas"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["reconciling"] = None
        __props__.__dict__["replicas"] = None
        __props__.__dict__["state"] = None
        return InstanceConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baseConfig")
    def base_config(self) -> pulumi.Output[str]:
        """
        Base configuration name, e.g. projects//instanceConfigs/nam3, based on which this configuration is created. Only set for user managed configurations. `base_config` must refer to a configuration of type GOOGLE_MANAGED in the same project as this configuration.
        """
        return pulumi.get(self, "base_config")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[str]:
        """
        Whether this instance config is a Google or User Managed Configuration.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The name of this instance configuration as it appears in UIs.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        etag is used for optimistic concurrency control as a way to help prevent simultaneous updates of a instance config from overwriting each other. It is strongly suggested that systems make use of the etag in the read-modify-write cycle to perform instance config updates in order to avoid race conditions: An etag is returned in the response which contains instance configs, and systems are expected to put that etag in the request to update instance config to ensure that their change will be applied to the same version of the instance config. If no etag is provided in the call to update instance config, then the existing instance config is overwritten blindly.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="freeInstanceAvailability")
    def free_instance_availability(self) -> pulumi.Output[str]:
        """
        Describes whether free instances are available to be created in this instance config.
        """
        return pulumi.get(self, "free_instance_availability")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Cloud Labels are a flexible and lightweight mechanism for organizing cloud resources into groups that reflect a customer's organizational needs and deployment strategies. Cloud Labels can be used to filter collections of resources. They can be used to control how resource metrics are aggregated. And they can be used as arguments to policy management rules (e.g. route, firewall, load balancing, etc.). * Label keys must be between 1 and 63 characters long and must conform to the following regular expression: `a-z{0,62}`. * Label values must be between 0 and 63 characters long and must conform to the regular expression `[a-z0-9_-]{0,63}`. * No more than 64 labels can be associated with a given resource. See https://goo.gl/xmQnxf for more information on and examples of labels. If you plan to use labels in your own code, please note that additional characters may be allowed in the future. Therefore, you are advised to use an internal label representation, such as JSON, which doesn't rely upon specific characters being disallowed. For example, representing labels as the string: name + "_" + value would prove problematic if we were to allow "_" in a future release.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="leaderOptions")
    def leader_options(self) -> pulumi.Output[Sequence[str]]:
        """
        Allowed values of the "default_leader" schema option for databases in instances that use this instance configuration.
        """
        return pulumi.get(self, "leader_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique identifier for the instance configuration. Values are of the form `projects//instanceConfigs/a-z*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optionalReplicas")
    def optional_replicas(self) -> pulumi.Output[Sequence['outputs.ReplicaInfoResponse']]:
        """
        The available optional replicas to choose from for user managed configurations. Populated for Google managed configurations.
        """
        return pulumi.get(self, "optional_replicas")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        If true, the instance config is being created or updated. If false, there are no ongoing operations for the instance config.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Sequence['outputs.ReplicaInfoResponse']]:
        """
        The geographic placement of nodes in this instance configuration and their replication properties.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current instance config state.
        """
        return pulumi.get(self, "state")

