# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetOrganizationMuteConfigResult',
    'AwaitableGetOrganizationMuteConfigResult',
    'get_organization_mute_config',
    'get_organization_mute_config_output',
]

@pulumi.output_type
class GetOrganizationMuteConfigResult:
    def __init__(__self__, create_time=None, description=None, display_name=None, filter=None, most_recent_editor=None, name=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if most_recent_editor and not isinstance(most_recent_editor, str):
            raise TypeError("Expected argument 'most_recent_editor' to be a str")
        pulumi.set(__self__, "most_recent_editor", most_recent_editor)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the mute config was created. This field is set by the server and will be ignored if provided on config creation.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the mute config.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human readable name to be displayed for the mute config.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        An expression that defines the filter to apply across create/update events of findings. While creating a filter string, be mindful of the scope in which the mute configuration is being created. E.g., If a filter contains project = X but is created under the project = Y scope, it might not match any findings. The following field and operator combinations are supported: * severity: `=`, `:` * category: `=`, `:` * resource.name: `=`, `:` * resource.project_name: `=`, `:` * resource.project_display_name: `=`, `:` * resource.folders.resource_folder: `=`, `:` * resource.parent_name: `=`, `:` * resource.parent_display_name: `=`, `:` * resource.type: `=`, `:` * finding_class: `=`, `:` * indicator.ip_addresses: `=`, `:` * indicator.domains: `=`, `:`
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> str:
        """
        Email address of the user who last edited the mute config. This field is set by the server and will be ignored if provided on config creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This field will be ignored if provided on config creation. Format "organizations/{organization}/muteConfigs/{mute_config}" "folders/{folder}/muteConfigs/{mute_config}" "projects/{project}/muteConfigs/{mute_config}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The most recent time at which the mute config was updated. This field is set by the server and will be ignored if provided on config creation or update.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetOrganizationMuteConfigResult(GetOrganizationMuteConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationMuteConfigResult(
            create_time=self.create_time,
            description=self.description,
            display_name=self.display_name,
            filter=self.filter,
            most_recent_editor=self.most_recent_editor,
            name=self.name,
            update_time=self.update_time)


def get_organization_mute_config(mute_config_id: Optional[str] = None,
                                 organization_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationMuteConfigResult:
    """
    Gets a mute config.
    """
    __args__ = dict()
    __args__['muteConfigId'] = mute_config_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:securitycenter/v1:getOrganizationMuteConfig', __args__, opts=opts, typ=GetOrganizationMuteConfigResult).value

    return AwaitableGetOrganizationMuteConfigResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        display_name=__ret__.display_name,
        filter=__ret__.filter,
        most_recent_editor=__ret__.most_recent_editor,
        name=__ret__.name,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_organization_mute_config)
def get_organization_mute_config_output(mute_config_id: Optional[pulumi.Input[str]] = None,
                                        organization_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationMuteConfigResult]:
    """
    Gets a mute config.
    """
    ...
