# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetGroupResult',
    'AwaitableGetGroupResult',
    'get_group',
    'get_group_output',
]

@pulumi.output_type
class GetGroupResult:
    def __init__(__self__, display_name=None, filter=None, is_cluster=None, name=None, parent_name=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if is_cluster and not isinstance(is_cluster, bool):
            raise TypeError("Expected argument 'is_cluster' to be a bool")
        pulumi.set(__self__, "is_cluster", is_cluster)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_name and not isinstance(parent_name, str):
            raise TypeError("Expected argument 'parent_name' to be a str")
        pulumi.set(__self__, "parent_name", parent_name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-assigned name for this group, used only for display purposes.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        The filter used to determine which monitored resources belong to this group.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> bool:
        """
        If true, the members of this group are considered to be a cluster. The system can perform additional analysis on groups that are clusters.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this group. The format is: projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID] When creating a group, this field is ignored and a new name is created consisting of the project specified in the call to CreateGroup and a unique [GROUP_ID] that is generated automatically.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> str:
        """
        The name of the group's parent, if it has one. The format is: projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID] For groups with no parent, parent_name is the empty string, "".
        """
        return pulumi.get(self, "parent_name")


class AwaitableGetGroupResult(GetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupResult(
            display_name=self.display_name,
            filter=self.filter,
            is_cluster=self.is_cluster,
            name=self.name,
            parent_name=self.parent_name)


def get_group(group_id: Optional[str] = None,
              project: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupResult:
    """
    Gets a single group.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:monitoring/v3:getGroup', __args__, opts=opts, typ=GetGroupResult).value

    return AwaitableGetGroupResult(
        display_name=__ret__.display_name,
        filter=__ret__.filter,
        is_cluster=__ret__.is_cluster,
        name=__ret__.name,
        parent_name=__ret__.parent_name)


@_utilities.lift_output_func(get_group)
def get_group_output(group_id: Optional[pulumi.Input[str]] = None,
                     project: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGroupResult]:
    """
    Gets a single group.
    """
    ...
