# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AggregationResponse',
    'AlertChartResponse',
    'AxisResponse',
    'ChartOptionsResponse',
    'CollapsibleGroupResponse',
    'ColumnLayoutResponse',
    'ColumnResponse',
    'DashboardFilterResponse',
    'DataSetResponse',
    'EmptyResponse',
    'GaugeViewResponse',
    'GridLayoutResponse',
    'LogsPanelResponse',
    'MosaicLayoutResponse',
    'PickTimeSeriesFilterResponse',
    'RatioPartResponse',
    'RowLayoutResponse',
    'RowResponse',
    'ScorecardResponse',
    'SparkChartViewResponse',
    'StatisticalTimeSeriesFilterResponse',
    'TableDataSetResponse',
    'TableDisplayOptionsResponse',
    'TextResponse',
    'ThresholdResponse',
    'TileResponse',
    'TimeSeriesFilterRatioResponse',
    'TimeSeriesFilterResponse',
    'TimeSeriesQueryResponse',
    'TimeSeriesTableResponse',
    'WidgetResponse',
    'XyChartResponse',
]

@pulumi.output_type
class AggregationResponse(dict):
    """
    Describes how to combine multiple time series to provide a different view of the data. Aggregation of time series is done in two steps. First, each time series in the set is aligned to the same time interval boundaries, then the set of time series is optionally reduced in number.Alignment consists of applying the per_series_aligner operation to each time series after its data has been divided into regular alignment_period time intervals. This process takes all of the data points in an alignment period, applies a mathematical transformation such as averaging, minimum, maximum, delta, etc., and converts them into a single data point per period.Reduction is when the aligned and transformed time series can optionally be combined, reducing the number of time series through similar mathematical transformations. Reduction involves applying a cross_series_reducer to all the time series, optionally sorting the time series into subsets with group_by_fields, and applying the reducer to each subset.The raw time series data can contain a huge amount of information from multiple sources. Alignment and reduction transforms this mass of data into a more manageable and representative collection of data, for example "the 95% latency across the average of all tasks in a cluster". This representative data can be more easily graphed and comprehended, and the individual time series data is still available for later drilldown. For more details, see Filtering and aggregation (https://cloud.google.com/monitoring/api/v3/aggregation).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AggregationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AggregationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AggregationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: str,
                 cross_series_reducer: str,
                 group_by_fields: Sequence[str],
                 per_series_aligner: str):
        """
        Describes how to combine multiple time series to provide a different view of the data. Aggregation of time series is done in two steps. First, each time series in the set is aligned to the same time interval boundaries, then the set of time series is optionally reduced in number.Alignment consists of applying the per_series_aligner operation to each time series after its data has been divided into regular alignment_period time intervals. This process takes all of the data points in an alignment period, applies a mathematical transformation such as averaging, minimum, maximum, delta, etc., and converts them into a single data point per period.Reduction is when the aligned and transformed time series can optionally be combined, reducing the number of time series through similar mathematical transformations. Reduction involves applying a cross_series_reducer to all the time series, optionally sorting the time series into subsets with group_by_fields, and applying the reducer to each subset.The raw time series data can contain a huge amount of information from multiple sources. Alignment and reduction transforms this mass of data into a more manageable and representative collection of data, for example "the 95% latency across the average of all tasks in a cluster". This representative data can be more easily graphed and comprehended, and the individual time series data is still available for later drilldown. For more details, see Filtering and aggregation (https://cloud.google.com/monitoring/api/v3/aggregation).
        :param str alignment_period: The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 2 years, or 104 weeks.
        :param str cross_series_reducer: The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        :param Sequence[str] group_by_fields: The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        :param str per_series_aligner: An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        pulumi.set(__self__, "alignment_period", alignment_period)
        pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        pulumi.set(__self__, "group_by_fields", group_by_fields)
        pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> str:
        """
        The alignment_period specifies a time interval, in seconds, that is used to divide the data in all the time series into consistent blocks of time. This will be done before the per-series aligner can be applied to the data.The value must be at least 60 seconds. If a per-series aligner other than ALIGN_NONE is specified, this field is required or an error is returned. If no per-series aligner is specified, or the aligner ALIGN_NONE is specified, then this field is ignored.The maximum value of the alignment_period is 2 years, or 104 weeks.
        """
        return pulumi.get(self, "alignment_period")

    @property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> str:
        """
        The reduction operation to be used to combine time series into a single time series, where the value of each data point in the resulting series is a function of all the already aligned values in the input time series.Not all reducer operations can be applied to all time series. The valid choices depend on the metric_kind and the value_type of the original time series. Reduction can yield a time series with a different metric_kind or value_type than the input time series.Time series data must first be aligned (see per_series_aligner) in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified, and must not be ALIGN_NONE. An alignment_period must also be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "cross_series_reducer")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Sequence[str]:
        """
        The set of fields to preserve when cross_series_reducer is specified. The group_by_fields determine how the time series are partitioned into subsets prior to applying the aggregation operation. Each subset contains time series that have the same value for each of the grouping fields. Each individual time series is a member of exactly one subset. The cross_series_reducer is applied to each subset of time series. It is not possible to reduce across different resource types, so this field implicitly contains resource.type. Fields not specified in group_by_fields are aggregated away. If group_by_fields is not specified and all the time series have the same resource type, then the time series are aggregated into a single output time series. If cross_series_reducer is not defined, this field is ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> str:
        """
        An Aligner describes how to bring the data points in a single time series into temporal alignment. Except for ALIGN_NONE, all alignments cause all the data points in an alignment_period to be mathematically grouped together, resulting in a single data point for each alignment_period with end timestamp at the end of the period.Not all alignment operations may be applied to all time series. The valid choices depend on the metric_kind and value_type of the original time series. Alignment can change the metric_kind or the value_type of the time series.Time series data must be aligned in order to perform cross-time series reduction. If cross_series_reducer is specified, then per_series_aligner must be specified and not equal to ALIGN_NONE and alignment_period must be specified; otherwise, an error is returned.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AlertChartResponse(dict):
    """
    A chart that displays alert policy data.
    """
    def __init__(__self__, *,
                 name: str):
        """
        A chart that displays alert policy data.
        :param str name: The resource name of the alert policy. The format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID] 
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the alert policy. The format is: projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID] 
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AxisResponse(dict):
    """
    A chart axis.
    """
    def __init__(__self__, *,
                 label: str,
                 scale: str):
        """
        A chart axis.
        :param str label: The label of the axis.
        :param str scale: The axis scale. By default, a linear scale is used.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label of the axis.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def scale(self) -> str:
        """
        The axis scale. By default, a linear scale is used.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class ChartOptionsResponse(dict):
    """
    Options to control visual rendering of a chart.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        Options to control visual rendering of a chart.
        :param str mode: The chart mode.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The chart mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class CollapsibleGroupResponse(dict):
    """
    A widget that groups the other widgets. All widgets that are within the area spanned by the grouping widget are considered member widgets.
    """
    def __init__(__self__, *,
                 collapsed: bool):
        """
        A widget that groups the other widgets. All widgets that are within the area spanned by the grouping widget are considered member widgets.
        :param bool collapsed: The collapsed state of the widget on first page load.
        """
        pulumi.set(__self__, "collapsed", collapsed)

    @property
    @pulumi.getter
    def collapsed(self) -> bool:
        """
        The collapsed state of the widget on first page load.
        """
        return pulumi.get(self, "collapsed")


@pulumi.output_type
class ColumnLayoutResponse(dict):
    """
    A simplified layout that divides the available space into vertical columns and arranges a set of widgets vertically in each column.
    """
    def __init__(__self__, *,
                 columns: Sequence['outputs.ColumnResponse']):
        """
        A simplified layout that divides the available space into vertical columns and arranges a set of widgets vertically in each column.
        :param Sequence['ColumnResponse'] columns: The columns of content to display.
        """
        pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Sequence['outputs.ColumnResponse']:
        """
        The columns of content to display.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class ColumnResponse(dict):
    """
    Defines the layout properties and content for a column.
    """
    def __init__(__self__, *,
                 weight: str,
                 widgets: Sequence['outputs.WidgetResponse']):
        """
        Defines the layout properties and content for a column.
        :param str weight: The relative weight of this column. The column weight is used to adjust the width of columns on the screen (relative to peers). Greater the weight, greater the width of the column on the screen. If omitted, a value of 1 is used while rendering.
        :param Sequence['WidgetResponse'] widgets: The display widgets arranged vertically in this column.
        """
        pulumi.set(__self__, "weight", weight)
        pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter
    def weight(self) -> str:
        """
        The relative weight of this column. The column weight is used to adjust the width of columns on the screen (relative to peers). Greater the weight, greater the width of the column on the screen. If omitted, a value of 1 is used while rendering.
        """
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter
    def widgets(self) -> Sequence['outputs.WidgetResponse']:
        """
        The display widgets arranged vertically in this column.
        """
        return pulumi.get(self, "widgets")


@pulumi.output_type
class DashboardFilterResponse(dict):
    """
    A filter to reduce the amount of data charted in relevant widgets.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"
        elif key == "labelKey":
            suggest = "label_key"
        elif key == "stringValue":
            suggest = "string_value"
        elif key == "templateVariable":
            suggest = "template_variable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_type: str,
                 label_key: str,
                 string_value: str,
                 template_variable: str):
        """
        A filter to reduce the amount of data charted in relevant widgets.
        :param str filter_type: The specified filter type
        :param str label_key: The key for the label
        :param str string_value: A variable-length string value.
        :param str template_variable: The placeholder text that can be referenced in a filter string or MQL query. If omitted, the dashboard filter will be applied to all relevant widgets in the dashboard.
        """
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "label_key", label_key)
        pulumi.set(__self__, "string_value", string_value)
        pulumi.set(__self__, "template_variable", template_variable)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> str:
        """
        The specified filter type
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter(name="labelKey")
    def label_key(self) -> str:
        """
        The key for the label
        """
        return pulumi.get(self, "label_key")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> str:
        """
        A variable-length string value.
        """
        return pulumi.get(self, "string_value")

    @property
    @pulumi.getter(name="templateVariable")
    def template_variable(self) -> str:
        """
        The placeholder text that can be referenced in a filter string or MQL query. If omitted, the dashboard filter will be applied to all relevant widgets in the dashboard.
        """
        return pulumi.get(self, "template_variable")


@pulumi.output_type
class DataSetResponse(dict):
    """
    Groups a time series query definition with charting options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "legendTemplate":
            suggest = "legend_template"
        elif key == "minAlignmentPeriod":
            suggest = "min_alignment_period"
        elif key == "plotType":
            suggest = "plot_type"
        elif key == "targetAxis":
            suggest = "target_axis"
        elif key == "timeSeriesQuery":
            suggest = "time_series_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 legend_template: str,
                 min_alignment_period: str,
                 plot_type: str,
                 target_axis: str,
                 time_series_query: 'outputs.TimeSeriesQueryResponse'):
        """
        Groups a time series query definition with charting options.
        :param str legend_template: A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value.
        :param str min_alignment_period: Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        :param str plot_type: How this data should be plotted on the chart.
        :param str target_axis: Optional. The target axis to use for plotting the metric.
        :param 'TimeSeriesQueryResponse' time_series_query: Fields for querying time series data from the Stackdriver metrics API.
        """
        pulumi.set(__self__, "legend_template", legend_template)
        pulumi.set(__self__, "min_alignment_period", min_alignment_period)
        pulumi.set(__self__, "plot_type", plot_type)
        pulumi.set(__self__, "target_axis", target_axis)
        pulumi.set(__self__, "time_series_query", time_series_query)

    @property
    @pulumi.getter(name="legendTemplate")
    def legend_template(self) -> str:
        """
        A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value.
        """
        return pulumi.get(self, "legend_template")

    @property
    @pulumi.getter(name="minAlignmentPeriod")
    def min_alignment_period(self) -> str:
        """
        Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        """
        return pulumi.get(self, "min_alignment_period")

    @property
    @pulumi.getter(name="plotType")
    def plot_type(self) -> str:
        """
        How this data should be plotted on the chart.
        """
        return pulumi.get(self, "plot_type")

    @property
    @pulumi.getter(name="targetAxis")
    def target_axis(self) -> str:
        """
        Optional. The target axis to use for plotting the metric.
        """
        return pulumi.get(self, "target_axis")

    @property
    @pulumi.getter(name="timeSeriesQuery")
    def time_series_query(self) -> 'outputs.TimeSeriesQueryResponse':
        """
        Fields for querying time series data from the Stackdriver metrics API.
        """
        return pulumi.get(self, "time_series_query")


@pulumi.output_type
class EmptyResponse(dict):
    """
    A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } 
    """
    def __init__(__self__):
        """
        A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } 
        """
        pass


@pulumi.output_type
class GaugeViewResponse(dict):
    """
    A gauge chart shows where the current value sits within a pre-defined range. The upper and lower bounds should define the possible range of values for the scorecard's query (inclusive).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lowerBound":
            suggest = "lower_bound"
        elif key == "upperBound":
            suggest = "upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GaugeViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GaugeViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GaugeViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lower_bound: float,
                 upper_bound: float):
        """
        A gauge chart shows where the current value sits within a pre-defined range. The upper and lower bounds should define the possible range of values for the scorecard's query (inclusive).
        :param float lower_bound: The lower bound for this gauge chart. The value of the chart should always be greater than or equal to this.
        :param float upper_bound: The upper bound for this gauge chart. The value of the chart should always be less than or equal to this.
        """
        pulumi.set(__self__, "lower_bound", lower_bound)
        pulumi.set(__self__, "upper_bound", upper_bound)

    @property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> float:
        """
        The lower bound for this gauge chart. The value of the chart should always be greater than or equal to this.
        """
        return pulumi.get(self, "lower_bound")

    @property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> float:
        """
        The upper bound for this gauge chart. The value of the chart should always be less than or equal to this.
        """
        return pulumi.get(self, "upper_bound")


@pulumi.output_type
class GridLayoutResponse(dict):
    """
    A basic layout divides the available space into vertical columns of equal width and arranges a list of widgets using a row-first strategy.
    """
    def __init__(__self__, *,
                 columns: str,
                 widgets: Sequence['outputs.WidgetResponse']):
        """
        A basic layout divides the available space into vertical columns of equal width and arranges a list of widgets using a row-first strategy.
        :param str columns: The number of columns into which the view's width is divided. If omitted or set to zero, a system default will be used while rendering.
        :param Sequence['WidgetResponse'] widgets: The informational elements that are arranged into the columns row-first.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter
    def columns(self) -> str:
        """
        The number of columns into which the view's width is divided. If omitted or set to zero, a system default will be used while rendering.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def widgets(self) -> Sequence['outputs.WidgetResponse']:
        """
        The informational elements that are arranged into the columns row-first.
        """
        return pulumi.get(self, "widgets")


@pulumi.output_type
class LogsPanelResponse(dict):
    """
    A widget that displays a stream of log.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceNames":
            suggest = "resource_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogsPanelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogsPanelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogsPanelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 resource_names: Sequence[str]):
        """
        A widget that displays a stream of log.
        :param str filter: A filter that chooses which log entries to return. See Advanced Logs Queries (https://cloud.google.com/logging/docs/view/advanced-queries). Only log entries that match the filter are returned. An empty filter matches all log entries.
        :param Sequence[str] resource_names: The names of logging resources to collect logs for. Currently only projects are supported. If empty, the widget will default to the host project.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "resource_names", resource_names)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        A filter that chooses which log entries to return. See Advanced Logs Queries (https://cloud.google.com/logging/docs/view/advanced-queries). Only log entries that match the filter are returned. An empty filter matches all log entries.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Sequence[str]:
        """
        The names of logging resources to collect logs for. Currently only projects are supported. If empty, the widget will default to the host project.
        """
        return pulumi.get(self, "resource_names")


@pulumi.output_type
class MosaicLayoutResponse(dict):
    """
    A mosaic layout divides the available space into a grid of blocks, and overlays the grid with tiles. Unlike GridLayout, tiles may span multiple grid blocks and can be placed at arbitrary locations in the grid.
    """
    def __init__(__self__, *,
                 columns: int,
                 tiles: Sequence['outputs.TileResponse']):
        """
        A mosaic layout divides the available space into a grid of blocks, and overlays the grid with tiles. Unlike GridLayout, tiles may span multiple grid blocks and can be placed at arbitrary locations in the grid.
        :param int columns: The number of columns in the mosaic grid. The number of columns must be between 1 and 12, inclusive.
        :param Sequence['TileResponse'] tiles: The tiles to display.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "tiles", tiles)

    @property
    @pulumi.getter
    def columns(self) -> int:
        """
        The number of columns in the mosaic grid. The number of columns must be between 1 and 12, inclusive.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def tiles(self) -> Sequence['outputs.TileResponse']:
        """
        The tiles to display.
        """
        return pulumi.get(self, "tiles")


@pulumi.output_type
class PickTimeSeriesFilterResponse(dict):
    """
    Describes a ranking-based time series filter. Each input time series is ranked with an aligner. The filter will allow up to num_time_series time series to pass through it, selecting them based on the relative ranking.For example, if ranking_method is METHOD_MEAN,direction is BOTTOM, and num_time_series is 3, then the 3 times series with the lowest mean values will pass through the filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numTimeSeries":
            suggest = "num_time_series"
        elif key == "rankingMethod":
            suggest = "ranking_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PickTimeSeriesFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PickTimeSeriesFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PickTimeSeriesFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direction: str,
                 num_time_series: int,
                 ranking_method: str):
        """
        Describes a ranking-based time series filter. Each input time series is ranked with an aligner. The filter will allow up to num_time_series time series to pass through it, selecting them based on the relative ranking.For example, if ranking_method is METHOD_MEAN,direction is BOTTOM, and num_time_series is 3, then the 3 times series with the lowest mean values will pass through the filter.
        :param str direction: How to use the ranking to select time series that pass through the filter.
        :param int num_time_series: How many time series to allow to pass through the filter.
        :param str ranking_method: ranking_method is applied to each time series independently to produce the value which will be used to compare the time series to other time series.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "num_time_series", num_time_series)
        pulumi.set(__self__, "ranking_method", ranking_method)

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        How to use the ranking to select time series that pass through the filter.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="numTimeSeries")
    def num_time_series(self) -> int:
        """
        How many time series to allow to pass through the filter.
        """
        return pulumi.get(self, "num_time_series")

    @property
    @pulumi.getter(name="rankingMethod")
    def ranking_method(self) -> str:
        """
        ranking_method is applied to each time series independently to produce the value which will be used to compare the time series to other time series.
        """
        return pulumi.get(self, "ranking_method")


@pulumi.output_type
class RatioPartResponse(dict):
    """
    Describes a query to build the numerator or denominator of a TimeSeriesFilterRatio.
    """
    def __init__(__self__, *,
                 aggregation: 'outputs.AggregationResponse',
                 filter: str):
        """
        Describes a query to build the numerator or denominator of a TimeSeriesFilterRatio.
        :param 'AggregationResponse' aggregation: By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        :param str filter: The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        """
        pulumi.set(__self__, "aggregation", aggregation)
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def aggregation(self) -> 'outputs.AggregationResponse':
        """
        By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class RowLayoutResponse(dict):
    """
    A simplified layout that divides the available space into rows and arranges a set of widgets horizontally in each row.
    """
    def __init__(__self__, *,
                 rows: Sequence['outputs.RowResponse']):
        """
        A simplified layout that divides the available space into rows and arranges a set of widgets horizontally in each row.
        :param Sequence['RowResponse'] rows: The rows of content to display.
        """
        pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.RowResponse']:
        """
        The rows of content to display.
        """
        return pulumi.get(self, "rows")


@pulumi.output_type
class RowResponse(dict):
    """
    Defines the layout properties and content for a row.
    """
    def __init__(__self__, *,
                 weight: str,
                 widgets: Sequence['outputs.WidgetResponse']):
        """
        Defines the layout properties and content for a row.
        :param str weight: The relative weight of this row. The row weight is used to adjust the height of rows on the screen (relative to peers). Greater the weight, greater the height of the row on the screen. If omitted, a value of 1 is used while rendering.
        :param Sequence['WidgetResponse'] widgets: The display widgets arranged horizontally in this row.
        """
        pulumi.set(__self__, "weight", weight)
        pulumi.set(__self__, "widgets", widgets)

    @property
    @pulumi.getter
    def weight(self) -> str:
        """
        The relative weight of this row. The row weight is used to adjust the height of rows on the screen (relative to peers). Greater the weight, greater the height of the row on the screen. If omitted, a value of 1 is used while rendering.
        """
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter
    def widgets(self) -> Sequence['outputs.WidgetResponse']:
        """
        The display widgets arranged horizontally in this row.
        """
        return pulumi.get(self, "widgets")


@pulumi.output_type
class ScorecardResponse(dict):
    """
    A widget showing the latest value of a metric, and how this value relates to one or more thresholds.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gaugeView":
            suggest = "gauge_view"
        elif key == "sparkChartView":
            suggest = "spark_chart_view"
        elif key == "timeSeriesQuery":
            suggest = "time_series_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScorecardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScorecardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScorecardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gauge_view: 'outputs.GaugeViewResponse',
                 spark_chart_view: 'outputs.SparkChartViewResponse',
                 thresholds: Sequence['outputs.ThresholdResponse'],
                 time_series_query: 'outputs.TimeSeriesQueryResponse'):
        """
        A widget showing the latest value of a metric, and how this value relates to one or more thresholds.
        :param 'GaugeViewResponse' gauge_view: Will cause the scorecard to show a gauge chart.
        :param 'SparkChartViewResponse' spark_chart_view: Will cause the scorecard to show a spark chart.
        :param Sequence['ThresholdResponse'] thresholds: The thresholds used to determine the state of the scorecard given the time series' current value. For an actual value x, the scorecard is in a danger state if x is less than or equal to a danger threshold that triggers below, or greater than or equal to a danger threshold that triggers above. Similarly, if x is above/below a warning threshold that triggers above/below, then the scorecard is in a warning state - unless x also puts it in a danger state. (Danger trumps warning.)As an example, consider a scorecard with the following four thresholds: { value: 90, category: 'DANGER', trigger: 'ABOVE', }, { value: 70, category: 'WARNING', trigger: 'ABOVE', }, { value: 10, category: 'DANGER', trigger: 'BELOW', }, { value: 20, category: 'WARNING', trigger: 'BELOW', }Then: values less than or equal to 10 would put the scorecard in a DANGER state, values greater than 10 but less than or equal to 20 a WARNING state, values strictly between 20 and 70 an OK state, values greater than or equal to 70 but less than 90 a WARNING state, and values greater than or equal to 90 a DANGER state.
        :param 'TimeSeriesQueryResponse' time_series_query: Fields for querying time series data from the Stackdriver metrics API.
        """
        pulumi.set(__self__, "gauge_view", gauge_view)
        pulumi.set(__self__, "spark_chart_view", spark_chart_view)
        pulumi.set(__self__, "thresholds", thresholds)
        pulumi.set(__self__, "time_series_query", time_series_query)

    @property
    @pulumi.getter(name="gaugeView")
    def gauge_view(self) -> 'outputs.GaugeViewResponse':
        """
        Will cause the scorecard to show a gauge chart.
        """
        return pulumi.get(self, "gauge_view")

    @property
    @pulumi.getter(name="sparkChartView")
    def spark_chart_view(self) -> 'outputs.SparkChartViewResponse':
        """
        Will cause the scorecard to show a spark chart.
        """
        return pulumi.get(self, "spark_chart_view")

    @property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.ThresholdResponse']:
        """
        The thresholds used to determine the state of the scorecard given the time series' current value. For an actual value x, the scorecard is in a danger state if x is less than or equal to a danger threshold that triggers below, or greater than or equal to a danger threshold that triggers above. Similarly, if x is above/below a warning threshold that triggers above/below, then the scorecard is in a warning state - unless x also puts it in a danger state. (Danger trumps warning.)As an example, consider a scorecard with the following four thresholds: { value: 90, category: 'DANGER', trigger: 'ABOVE', }, { value: 70, category: 'WARNING', trigger: 'ABOVE', }, { value: 10, category: 'DANGER', trigger: 'BELOW', }, { value: 20, category: 'WARNING', trigger: 'BELOW', }Then: values less than or equal to 10 would put the scorecard in a DANGER state, values greater than 10 but less than or equal to 20 a WARNING state, values strictly between 20 and 70 an OK state, values greater than or equal to 70 but less than 90 a WARNING state, and values greater than or equal to 90 a DANGER state.
        """
        return pulumi.get(self, "thresholds")

    @property
    @pulumi.getter(name="timeSeriesQuery")
    def time_series_query(self) -> 'outputs.TimeSeriesQueryResponse':
        """
        Fields for querying time series data from the Stackdriver metrics API.
        """
        return pulumi.get(self, "time_series_query")


@pulumi.output_type
class SparkChartViewResponse(dict):
    """
    A sparkChart is a small chart suitable for inclusion in a table-cell or inline in text. This message contains the configuration for a sparkChart to show up on a Scorecard, showing recent trends of the scorecard's timeseries.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAlignmentPeriod":
            suggest = "min_alignment_period"
        elif key == "sparkChartType":
            suggest = "spark_chart_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkChartViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkChartViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkChartViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_alignment_period: str,
                 spark_chart_type: str):
        """
        A sparkChart is a small chart suitable for inclusion in a table-cell or inline in text. This message contains the configuration for a sparkChart to show up on a Scorecard, showing recent trends of the scorecard's timeseries.
        :param str min_alignment_period: The lower bound on data point frequency in the chart implemented by specifying the minimum alignment period to use in a time series query. For example, if the data is published once every 10 minutes it would not make sense to fetch and align data at one minute intervals. This field is optional and exists only as a hint.
        :param str spark_chart_type: The type of sparkchart to show in this chartView.
        """
        pulumi.set(__self__, "min_alignment_period", min_alignment_period)
        pulumi.set(__self__, "spark_chart_type", spark_chart_type)

    @property
    @pulumi.getter(name="minAlignmentPeriod")
    def min_alignment_period(self) -> str:
        """
        The lower bound on data point frequency in the chart implemented by specifying the minimum alignment period to use in a time series query. For example, if the data is published once every 10 minutes it would not make sense to fetch and align data at one minute intervals. This field is optional and exists only as a hint.
        """
        return pulumi.get(self, "min_alignment_period")

    @property
    @pulumi.getter(name="sparkChartType")
    def spark_chart_type(self) -> str:
        """
        The type of sparkchart to show in this chartView.
        """
        return pulumi.get(self, "spark_chart_type")


@pulumi.output_type
class StatisticalTimeSeriesFilterResponse(dict):
    """
    A filter that ranks streams based on their statistical relation to other streams in a request. Note: This field is deprecated and completely ignored by the API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numTimeSeries":
            suggest = "num_time_series"
        elif key == "rankingMethod":
            suggest = "ranking_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatisticalTimeSeriesFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatisticalTimeSeriesFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatisticalTimeSeriesFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_time_series: int,
                 ranking_method: str):
        """
        A filter that ranks streams based on their statistical relation to other streams in a request. Note: This field is deprecated and completely ignored by the API.
        :param int num_time_series: How many time series to output.
        :param str ranking_method: rankingMethod is applied to a set of time series, and then the produced value for each individual time series is used to compare a given time series to others. These are methods that cannot be applied stream-by-stream, but rather require the full context of a request to evaluate time series.
        """
        pulumi.set(__self__, "num_time_series", num_time_series)
        pulumi.set(__self__, "ranking_method", ranking_method)

    @property
    @pulumi.getter(name="numTimeSeries")
    def num_time_series(self) -> int:
        """
        How many time series to output.
        """
        return pulumi.get(self, "num_time_series")

    @property
    @pulumi.getter(name="rankingMethod")
    def ranking_method(self) -> str:
        """
        rankingMethod is applied to a set of time series, and then the produced value for each individual time series is used to compare a given time series to others. These are methods that cannot be applied stream-by-stream, but rather require the full context of a request to evaluate time series.
        """
        return pulumi.get(self, "ranking_method")


@pulumi.output_type
class TableDataSetResponse(dict):
    """
    Groups a time series query definition with table options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAlignmentPeriod":
            suggest = "min_alignment_period"
        elif key == "tableDisplayOptions":
            suggest = "table_display_options"
        elif key == "tableTemplate":
            suggest = "table_template"
        elif key == "timeSeriesQuery":
            suggest = "time_series_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableDataSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableDataSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableDataSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_alignment_period: str,
                 table_display_options: 'outputs.TableDisplayOptionsResponse',
                 table_template: str,
                 time_series_query: 'outputs.TimeSeriesQueryResponse'):
        """
        Groups a time series query definition with table options.
        :param str min_alignment_period: Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        :param 'TableDisplayOptionsResponse' table_display_options: Optional. Table display options for configuring how the table is rendered.
        :param str table_template: Optional. A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value i.e. "${resource.labels.project_id}."
        :param 'TimeSeriesQueryResponse' time_series_query: Fields for querying time series data from the Stackdriver metrics API.
        """
        pulumi.set(__self__, "min_alignment_period", min_alignment_period)
        pulumi.set(__self__, "table_display_options", table_display_options)
        pulumi.set(__self__, "table_template", table_template)
        pulumi.set(__self__, "time_series_query", time_series_query)

    @property
    @pulumi.getter(name="minAlignmentPeriod")
    def min_alignment_period(self) -> str:
        """
        Optional. The lower bound on data point frequency for this data set, implemented by specifying the minimum alignment period to use in a time series query For example, if the data is published once every 10 minutes, the min_alignment_period should be at least 10 minutes. It would not make sense to fetch and align data at one minute intervals.
        """
        return pulumi.get(self, "min_alignment_period")

    @property
    @pulumi.getter(name="tableDisplayOptions")
    def table_display_options(self) -> 'outputs.TableDisplayOptionsResponse':
        """
        Optional. Table display options for configuring how the table is rendered.
        """
        return pulumi.get(self, "table_display_options")

    @property
    @pulumi.getter(name="tableTemplate")
    def table_template(self) -> str:
        """
        Optional. A template string for naming TimeSeries in the resulting data set. This should be a string with interpolations of the form ${label_name}, which will resolve to the label's value i.e. "${resource.labels.project_id}."
        """
        return pulumi.get(self, "table_template")

    @property
    @pulumi.getter(name="timeSeriesQuery")
    def time_series_query(self) -> 'outputs.TimeSeriesQueryResponse':
        """
        Fields for querying time series data from the Stackdriver metrics API.
        """
        return pulumi.get(self, "time_series_query")


@pulumi.output_type
class TableDisplayOptionsResponse(dict):
    """
    Table display options that can be reused.
    """
    def __init__(__self__):
        """
        Table display options that can be reused.
        """
        pass


@pulumi.output_type
class TextResponse(dict):
    """
    A widget that displays textual content.
    """
    def __init__(__self__, *,
                 content: str,
                 format: str):
        """
        A widget that displays textual content.
        :param str content: The text content to be displayed.
        :param str format: How the text content is formatted.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The text content to be displayed.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        How the text content is formatted.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class ThresholdResponse(dict):
    """
    Defines a threshold for categorizing time series values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetAxis":
            suggest = "target_axis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThresholdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThresholdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThresholdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 color: str,
                 direction: str,
                 label: str,
                 target_axis: str,
                 value: float):
        """
        Defines a threshold for categorizing time series values.
        :param str color: The state color for this threshold. Color is not allowed in a XyChart.
        :param str direction: The direction for the current threshold. Direction is not allowed in a XyChart.
        :param str label: A label for the threshold.
        :param str target_axis: The target axis to use for plotting the threshold. Target axis is not allowed in a Scorecard.
        :param float value: The value of the threshold. The value should be defined in the native scale of the metric.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "target_axis", target_axis)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def color(self) -> str:
        """
        The state color for this threshold. Color is not allowed in a XyChart.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction for the current threshold. Direction is not allowed in a XyChart.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        A label for the threshold.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="targetAxis")
    def target_axis(self) -> str:
        """
        The target axis to use for plotting the threshold. Target axis is not allowed in a Scorecard.
        """
        return pulumi.get(self, "target_axis")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The value of the threshold. The value should be defined in the native scale of the metric.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TileResponse(dict):
    """
    A single tile in the mosaic. The placement and size of the tile are configurable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xPos":
            suggest = "x_pos"
        elif key == "yPos":
            suggest = "y_pos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 height: int,
                 widget: 'outputs.WidgetResponse',
                 width: int,
                 x_pos: int,
                 y_pos: int):
        """
        A single tile in the mosaic. The placement and size of the tile are configurable.
        :param int height: The height of the tile, measured in grid blocks. Tiles must have a minimum height of 1.
        :param 'WidgetResponse' widget: The informational widget contained in the tile. For example an XyChart.
        :param int width: The width of the tile, measured in grid blocks. Tiles must have a minimum width of 1.
        :param int x_pos: The zero-indexed position of the tile in grid blocks relative to the left edge of the grid. Tiles must be contained within the specified number of columns. x_pos cannot be negative.
        :param int y_pos: The zero-indexed position of the tile in grid blocks relative to the top edge of the grid. y_pos cannot be negative.
        """
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "widget", widget)
        pulumi.set(__self__, "width", width)
        pulumi.set(__self__, "x_pos", x_pos)
        pulumi.set(__self__, "y_pos", y_pos)

    @property
    @pulumi.getter
    def height(self) -> int:
        """
        The height of the tile, measured in grid blocks. Tiles must have a minimum height of 1.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def widget(self) -> 'outputs.WidgetResponse':
        """
        The informational widget contained in the tile. For example an XyChart.
        """
        return pulumi.get(self, "widget")

    @property
    @pulumi.getter
    def width(self) -> int:
        """
        The width of the tile, measured in grid blocks. Tiles must have a minimum width of 1.
        """
        return pulumi.get(self, "width")

    @property
    @pulumi.getter(name="xPos")
    def x_pos(self) -> int:
        """
        The zero-indexed position of the tile in grid blocks relative to the left edge of the grid. Tiles must be contained within the specified number of columns. x_pos cannot be negative.
        """
        return pulumi.get(self, "x_pos")

    @property
    @pulumi.getter(name="yPos")
    def y_pos(self) -> int:
        """
        The zero-indexed position of the tile in grid blocks relative to the top edge of the grid. y_pos cannot be negative.
        """
        return pulumi.get(self, "y_pos")


@pulumi.output_type
class TimeSeriesFilterRatioResponse(dict):
    """
    A pair of time series filters that define a ratio computation. The output time series is the pair-wise division of each aligned element from the numerator and denominator time series.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pickTimeSeriesFilter":
            suggest = "pick_time_series_filter"
        elif key == "secondaryAggregation":
            suggest = "secondary_aggregation"
        elif key == "statisticalTimeSeriesFilter":
            suggest = "statistical_time_series_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeSeriesFilterRatioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeSeriesFilterRatioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeSeriesFilterRatioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 denominator: 'outputs.RatioPartResponse',
                 numerator: 'outputs.RatioPartResponse',
                 pick_time_series_filter: 'outputs.PickTimeSeriesFilterResponse',
                 secondary_aggregation: 'outputs.AggregationResponse',
                 statistical_time_series_filter: 'outputs.StatisticalTimeSeriesFilterResponse'):
        """
        A pair of time series filters that define a ratio computation. The output time series is the pair-wise division of each aligned element from the numerator and denominator time series.
        :param 'RatioPartResponse' denominator: The denominator of the ratio.
        :param 'RatioPartResponse' numerator: The numerator of the ratio.
        :param 'PickTimeSeriesFilterResponse' pick_time_series_filter: Ranking based time series filter.
        :param 'AggregationResponse' secondary_aggregation: Apply a second aggregation after the ratio is computed.
        :param 'StatisticalTimeSeriesFilterResponse' statistical_time_series_filter: Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        pulumi.set(__self__, "denominator", denominator)
        pulumi.set(__self__, "numerator", numerator)
        pulumi.set(__self__, "pick_time_series_filter", pick_time_series_filter)
        pulumi.set(__self__, "secondary_aggregation", secondary_aggregation)
        pulumi.set(__self__, "statistical_time_series_filter", statistical_time_series_filter)

    @property
    @pulumi.getter
    def denominator(self) -> 'outputs.RatioPartResponse':
        """
        The denominator of the ratio.
        """
        return pulumi.get(self, "denominator")

    @property
    @pulumi.getter
    def numerator(self) -> 'outputs.RatioPartResponse':
        """
        The numerator of the ratio.
        """
        return pulumi.get(self, "numerator")

    @property
    @pulumi.getter(name="pickTimeSeriesFilter")
    def pick_time_series_filter(self) -> 'outputs.PickTimeSeriesFilterResponse':
        """
        Ranking based time series filter.
        """
        return pulumi.get(self, "pick_time_series_filter")

    @property
    @pulumi.getter(name="secondaryAggregation")
    def secondary_aggregation(self) -> 'outputs.AggregationResponse':
        """
        Apply a second aggregation after the ratio is computed.
        """
        return pulumi.get(self, "secondary_aggregation")

    @property
    @pulumi.getter(name="statisticalTimeSeriesFilter")
    def statistical_time_series_filter(self) -> 'outputs.StatisticalTimeSeriesFilterResponse':
        """
        Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        return pulumi.get(self, "statistical_time_series_filter")


@pulumi.output_type
class TimeSeriesFilterResponse(dict):
    """
    A filter that defines a subset of time series data that is displayed in a widget. Time series data is fetched using the ListTimeSeries (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) method.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pickTimeSeriesFilter":
            suggest = "pick_time_series_filter"
        elif key == "secondaryAggregation":
            suggest = "secondary_aggregation"
        elif key == "statisticalTimeSeriesFilter":
            suggest = "statistical_time_series_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeSeriesFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeSeriesFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeSeriesFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation: 'outputs.AggregationResponse',
                 filter: str,
                 pick_time_series_filter: 'outputs.PickTimeSeriesFilterResponse',
                 secondary_aggregation: 'outputs.AggregationResponse',
                 statistical_time_series_filter: 'outputs.StatisticalTimeSeriesFilterResponse'):
        """
        A filter that defines a subset of time series data that is displayed in a widget. Time series data is fetched using the ListTimeSeries (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) method.
        :param 'AggregationResponse' aggregation: By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        :param str filter: The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        :param 'PickTimeSeriesFilterResponse' pick_time_series_filter: Ranking based time series filter.
        :param 'AggregationResponse' secondary_aggregation: Apply a second aggregation after aggregation is applied.
        :param 'StatisticalTimeSeriesFilterResponse' statistical_time_series_filter: Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        pulumi.set(__self__, "aggregation", aggregation)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "pick_time_series_filter", pick_time_series_filter)
        pulumi.set(__self__, "secondary_aggregation", secondary_aggregation)
        pulumi.set(__self__, "statistical_time_series_filter", statistical_time_series_filter)

    @property
    @pulumi.getter
    def aggregation(self) -> 'outputs.AggregationResponse':
        """
        By default, the raw time series data is returned. Use this field to combine multiple time series for different views of the data.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        The monitoring filter (https://cloud.google.com/monitoring/api/v3/filters) that identifies the metric types, resources, and projects to query.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="pickTimeSeriesFilter")
    def pick_time_series_filter(self) -> 'outputs.PickTimeSeriesFilterResponse':
        """
        Ranking based time series filter.
        """
        return pulumi.get(self, "pick_time_series_filter")

    @property
    @pulumi.getter(name="secondaryAggregation")
    def secondary_aggregation(self) -> 'outputs.AggregationResponse':
        """
        Apply a second aggregation after aggregation is applied.
        """
        return pulumi.get(self, "secondary_aggregation")

    @property
    @pulumi.getter(name="statisticalTimeSeriesFilter")
    def statistical_time_series_filter(self) -> 'outputs.StatisticalTimeSeriesFilterResponse':
        """
        Statistics based time series filter. Note: This field is deprecated and completely ignored by the API.
        """
        return pulumi.get(self, "statistical_time_series_filter")


@pulumi.output_type
class TimeSeriesQueryResponse(dict):
    """
    TimeSeriesQuery collects the set of supported methods for querying time series data from the Stackdriver metrics API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prometheusQuery":
            suggest = "prometheus_query"
        elif key == "timeSeriesFilter":
            suggest = "time_series_filter"
        elif key == "timeSeriesFilterRatio":
            suggest = "time_series_filter_ratio"
        elif key == "timeSeriesQueryLanguage":
            suggest = "time_series_query_language"
        elif key == "unitOverride":
            suggest = "unit_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeSeriesQueryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeSeriesQueryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeSeriesQueryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prometheus_query: str,
                 time_series_filter: 'outputs.TimeSeriesFilterResponse',
                 time_series_filter_ratio: 'outputs.TimeSeriesFilterRatioResponse',
                 time_series_query_language: str,
                 unit_override: str):
        """
        TimeSeriesQuery collects the set of supported methods for querying time series data from the Stackdriver metrics API.
        :param str prometheus_query: A query used to fetch time series with PromQL.
        :param 'TimeSeriesFilterResponse' time_series_filter: Filter parameters to fetch time series.
        :param 'TimeSeriesFilterRatioResponse' time_series_filter_ratio: Parameters to fetch a ratio between two time series filters.
        :param str time_series_query_language: A query used to fetch time series with MQL.
        :param str unit_override: The unit of data contained in fetched time series. If non-empty, this unit will override any unit that accompanies fetched data. The format is the same as the unit (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors) field in MetricDescriptor.
        """
        pulumi.set(__self__, "prometheus_query", prometheus_query)
        pulumi.set(__self__, "time_series_filter", time_series_filter)
        pulumi.set(__self__, "time_series_filter_ratio", time_series_filter_ratio)
        pulumi.set(__self__, "time_series_query_language", time_series_query_language)
        pulumi.set(__self__, "unit_override", unit_override)

    @property
    @pulumi.getter(name="prometheusQuery")
    def prometheus_query(self) -> str:
        """
        A query used to fetch time series with PromQL.
        """
        return pulumi.get(self, "prometheus_query")

    @property
    @pulumi.getter(name="timeSeriesFilter")
    def time_series_filter(self) -> 'outputs.TimeSeriesFilterResponse':
        """
        Filter parameters to fetch time series.
        """
        return pulumi.get(self, "time_series_filter")

    @property
    @pulumi.getter(name="timeSeriesFilterRatio")
    def time_series_filter_ratio(self) -> 'outputs.TimeSeriesFilterRatioResponse':
        """
        Parameters to fetch a ratio between two time series filters.
        """
        return pulumi.get(self, "time_series_filter_ratio")

    @property
    @pulumi.getter(name="timeSeriesQueryLanguage")
    def time_series_query_language(self) -> str:
        """
        A query used to fetch time series with MQL.
        """
        return pulumi.get(self, "time_series_query_language")

    @property
    @pulumi.getter(name="unitOverride")
    def unit_override(self) -> str:
        """
        The unit of data contained in fetched time series. If non-empty, this unit will override any unit that accompanies fetched data. The format is the same as the unit (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors) field in MetricDescriptor.
        """
        return pulumi.get(self, "unit_override")


@pulumi.output_type
class TimeSeriesTableResponse(dict):
    """
    A table that displays time series data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSets":
            suggest = "data_sets"
        elif key == "metricVisualization":
            suggest = "metric_visualization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeSeriesTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeSeriesTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeSeriesTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_sets: Sequence['outputs.TableDataSetResponse'],
                 metric_visualization: str):
        """
        A table that displays time series data.
        :param Sequence['TableDataSetResponse'] data_sets: The data displayed in this table.
        :param str metric_visualization: Optional. Store rendering strategy
        """
        pulumi.set(__self__, "data_sets", data_sets)
        pulumi.set(__self__, "metric_visualization", metric_visualization)

    @property
    @pulumi.getter(name="dataSets")
    def data_sets(self) -> Sequence['outputs.TableDataSetResponse']:
        """
        The data displayed in this table.
        """
        return pulumi.get(self, "data_sets")

    @property
    @pulumi.getter(name="metricVisualization")
    def metric_visualization(self) -> str:
        """
        Optional. Store rendering strategy
        """
        return pulumi.get(self, "metric_visualization")


@pulumi.output_type
class WidgetResponse(dict):
    """
    Widget contains a single dashboard component and configuration of how to present the component in the dashboard.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertChart":
            suggest = "alert_chart"
        elif key == "collapsibleGroup":
            suggest = "collapsible_group"
        elif key == "logsPanel":
            suggest = "logs_panel"
        elif key == "timeSeriesTable":
            suggest = "time_series_table"
        elif key == "xyChart":
            suggest = "xy_chart"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WidgetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WidgetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WidgetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_chart: 'outputs.AlertChartResponse',
                 blank: 'outputs.EmptyResponse',
                 collapsible_group: 'outputs.CollapsibleGroupResponse',
                 logs_panel: 'outputs.LogsPanelResponse',
                 scorecard: 'outputs.ScorecardResponse',
                 text: 'outputs.TextResponse',
                 time_series_table: 'outputs.TimeSeriesTableResponse',
                 title: str,
                 xy_chart: 'outputs.XyChartResponse'):
        """
        Widget contains a single dashboard component and configuration of how to present the component in the dashboard.
        :param 'AlertChartResponse' alert_chart: A chart of alert policy data.
        :param 'EmptyResponse' blank: A blank space.
        :param 'CollapsibleGroupResponse' collapsible_group: A widget that groups the other widgets. All widgets that are within the area spanned by the grouping widget are considered member widgets.
        :param 'LogsPanelResponse' logs_panel: A widget that shows a stream of logs.
        :param 'ScorecardResponse' scorecard: A scorecard summarizing time series data.
        :param 'TextResponse' text: A raw string or markdown displaying textual content.
        :param 'TimeSeriesTableResponse' time_series_table: A widget that displays time series data in a tabular format.
        :param str title: Optional. The title of the widget.
        :param 'XyChartResponse' xy_chart: A chart of time series data.
        """
        pulumi.set(__self__, "alert_chart", alert_chart)
        pulumi.set(__self__, "blank", blank)
        pulumi.set(__self__, "collapsible_group", collapsible_group)
        pulumi.set(__self__, "logs_panel", logs_panel)
        pulumi.set(__self__, "scorecard", scorecard)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "time_series_table", time_series_table)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "xy_chart", xy_chart)

    @property
    @pulumi.getter(name="alertChart")
    def alert_chart(self) -> 'outputs.AlertChartResponse':
        """
        A chart of alert policy data.
        """
        return pulumi.get(self, "alert_chart")

    @property
    @pulumi.getter
    def blank(self) -> 'outputs.EmptyResponse':
        """
        A blank space.
        """
        return pulumi.get(self, "blank")

    @property
    @pulumi.getter(name="collapsibleGroup")
    def collapsible_group(self) -> 'outputs.CollapsibleGroupResponse':
        """
        A widget that groups the other widgets. All widgets that are within the area spanned by the grouping widget are considered member widgets.
        """
        return pulumi.get(self, "collapsible_group")

    @property
    @pulumi.getter(name="logsPanel")
    def logs_panel(self) -> 'outputs.LogsPanelResponse':
        """
        A widget that shows a stream of logs.
        """
        return pulumi.get(self, "logs_panel")

    @property
    @pulumi.getter
    def scorecard(self) -> 'outputs.ScorecardResponse':
        """
        A scorecard summarizing time series data.
        """
        return pulumi.get(self, "scorecard")

    @property
    @pulumi.getter
    def text(self) -> 'outputs.TextResponse':
        """
        A raw string or markdown displaying textual content.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="timeSeriesTable")
    def time_series_table(self) -> 'outputs.TimeSeriesTableResponse':
        """
        A widget that displays time series data in a tabular format.
        """
        return pulumi.get(self, "time_series_table")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. The title of the widget.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="xyChart")
    def xy_chart(self) -> 'outputs.XyChartResponse':
        """
        A chart of time series data.
        """
        return pulumi.get(self, "xy_chart")


@pulumi.output_type
class XyChartResponse(dict):
    """
    A chart that displays data on a 2D (X and Y axes) plane.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartOptions":
            suggest = "chart_options"
        elif key == "dataSets":
            suggest = "data_sets"
        elif key == "timeshiftDuration":
            suggest = "timeshift_duration"
        elif key == "xAxis":
            suggest = "x_axis"
        elif key == "y2Axis":
            suggest = "y2_axis"
        elif key == "yAxis":
            suggest = "y_axis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in XyChartResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        XyChartResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        XyChartResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_options: 'outputs.ChartOptionsResponse',
                 data_sets: Sequence['outputs.DataSetResponse'],
                 thresholds: Sequence['outputs.ThresholdResponse'],
                 timeshift_duration: str,
                 x_axis: 'outputs.AxisResponse',
                 y2_axis: 'outputs.AxisResponse',
                 y_axis: 'outputs.AxisResponse'):
        """
        A chart that displays data on a 2D (X and Y axes) plane.
        :param 'ChartOptionsResponse' chart_options: Display options for the chart.
        :param Sequence['DataSetResponse'] data_sets: The data displayed in this chart.
        :param Sequence['ThresholdResponse'] thresholds: Threshold lines drawn horizontally across the chart.
        :param str timeshift_duration: The duration used to display a comparison chart. A comparison chart simultaneously shows values from two similar-length time periods (e.g., week-over-week metrics). The duration must be positive, and it can only be applied to charts with data sets of LINE plot type.
        :param 'AxisResponse' x_axis: The properties applied to the X axis.
        :param 'AxisResponse' y2_axis: The properties applied to the Y2 axis.
        :param 'AxisResponse' y_axis: The properties applied to the Y axis.
        """
        pulumi.set(__self__, "chart_options", chart_options)
        pulumi.set(__self__, "data_sets", data_sets)
        pulumi.set(__self__, "thresholds", thresholds)
        pulumi.set(__self__, "timeshift_duration", timeshift_duration)
        pulumi.set(__self__, "x_axis", x_axis)
        pulumi.set(__self__, "y2_axis", y2_axis)
        pulumi.set(__self__, "y_axis", y_axis)

    @property
    @pulumi.getter(name="chartOptions")
    def chart_options(self) -> 'outputs.ChartOptionsResponse':
        """
        Display options for the chart.
        """
        return pulumi.get(self, "chart_options")

    @property
    @pulumi.getter(name="dataSets")
    def data_sets(self) -> Sequence['outputs.DataSetResponse']:
        """
        The data displayed in this chart.
        """
        return pulumi.get(self, "data_sets")

    @property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.ThresholdResponse']:
        """
        Threshold lines drawn horizontally across the chart.
        """
        return pulumi.get(self, "thresholds")

    @property
    @pulumi.getter(name="timeshiftDuration")
    def timeshift_duration(self) -> str:
        """
        The duration used to display a comparison chart. A comparison chart simultaneously shows values from two similar-length time periods (e.g., week-over-week metrics). The duration must be positive, and it can only be applied to charts with data sets of LINE plot type.
        """
        return pulumi.get(self, "timeshift_duration")

    @property
    @pulumi.getter(name="xAxis")
    def x_axis(self) -> 'outputs.AxisResponse':
        """
        The properties applied to the X axis.
        """
        return pulumi.get(self, "x_axis")

    @property
    @pulumi.getter(name="y2Axis")
    def y2_axis(self) -> 'outputs.AxisResponse':
        """
        The properties applied to the Y2 axis.
        """
        return pulumi.get(self, "y2_axis")

    @property
    @pulumi.getter(name="yAxis")
    def y_axis(self) -> 'outputs.AxisResponse':
        """
        The properties applied to the Y axis.
        """
        return pulumi.get(self, "y_axis")


