# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InboundSamlConfigArgs', 'InboundSamlConfig']

@pulumi.input_type
class InboundSamlConfigArgs:
    def __init__(__self__, *,
                 tenant_id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_config: Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2IdpConfigArgs']] = None,
                 inbound_saml_config_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sp_config: Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2SpConfigArgs']] = None):
        """
        The set of arguments for constructing a InboundSamlConfig resource.
        :param pulumi.Input[str] display_name: The config's display name set by developers.
        :param pulumi.Input[bool] enabled: True if allows the user to sign in with the provider.
        :param pulumi.Input['GoogleCloudIdentitytoolkitAdminV2IdpConfigArgs'] idp_config: The SAML IdP (Identity Provider) configuration when the project acts as the relying party.
        :param pulumi.Input[str] inbound_saml_config_id: The id to use for this config.
        :param pulumi.Input[str] name: The name of the InboundSamlConfig resource, for example: 'projects/my-awesome-project/inboundSamlConfigs/my-config-id'. Ignored during create requests.
        :param pulumi.Input['GoogleCloudIdentitytoolkitAdminV2SpConfigArgs'] sp_config: The SAML SP (Service Provider) configuration when the project acts as the relying party to receive and accept an authentication assertion issued by a SAML identity provider.
        """
        pulumi.set(__self__, "tenant_id", tenant_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_config is not None:
            pulumi.set(__self__, "idp_config", idp_config)
        if inbound_saml_config_id is not None:
            pulumi.set(__self__, "inbound_saml_config_id", inbound_saml_config_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sp_config is not None:
            pulumi.set(__self__, "sp_config", sp_config)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The config's display name set by developers.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True if allows the user to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2IdpConfigArgs']]:
        """
        The SAML IdP (Identity Provider) configuration when the project acts as the relying party.
        """
        return pulumi.get(self, "idp_config")

    @idp_config.setter
    def idp_config(self, value: Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2IdpConfigArgs']]):
        pulumi.set(self, "idp_config", value)

    @property
    @pulumi.getter(name="inboundSamlConfigId")
    def inbound_saml_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id to use for this config.
        """
        return pulumi.get(self, "inbound_saml_config_id")

    @inbound_saml_config_id.setter
    def inbound_saml_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inbound_saml_config_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the InboundSamlConfig resource, for example: 'projects/my-awesome-project/inboundSamlConfigs/my-config-id'. Ignored during create requests.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="spConfig")
    def sp_config(self) -> Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2SpConfigArgs']]:
        """
        The SAML SP (Service Provider) configuration when the project acts as the relying party to receive and accept an authentication assertion issued by a SAML identity provider.
        """
        return pulumi.get(self, "sp_config")

    @sp_config.setter
    def sp_config(self, value: Optional[pulumi.Input['GoogleCloudIdentitytoolkitAdminV2SpConfigArgs']]):
        pulumi.set(self, "sp_config", value)


class InboundSamlConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2IdpConfigArgs']]] = None,
                 inbound_saml_config_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sp_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2SpConfigArgs']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create an inbound SAML configuration for an Identity Toolkit project.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: The config's display name set by developers.
        :param pulumi.Input[bool] enabled: True if allows the user to sign in with the provider.
        :param pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2IdpConfigArgs']] idp_config: The SAML IdP (Identity Provider) configuration when the project acts as the relying party.
        :param pulumi.Input[str] inbound_saml_config_id: The id to use for this config.
        :param pulumi.Input[str] name: The name of the InboundSamlConfig resource, for example: 'projects/my-awesome-project/inboundSamlConfigs/my-config-id'. Ignored during create requests.
        :param pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2SpConfigArgs']] sp_config: The SAML SP (Service Provider) configuration when the project acts as the relying party to receive and accept an authentication assertion issued by a SAML identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InboundSamlConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an inbound SAML configuration for an Identity Toolkit project.

        :param str resource_name: The name of the resource.
        :param InboundSamlConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InboundSamlConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2IdpConfigArgs']]] = None,
                 inbound_saml_config_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sp_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudIdentitytoolkitAdminV2SpConfigArgs']]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InboundSamlConfigArgs.__new__(InboundSamlConfigArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["idp_config"] = idp_config
            __props__.__dict__["inbound_saml_config_id"] = inbound_saml_config_id
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["sp_config"] = sp_config
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project", "tenant_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InboundSamlConfig, __self__).__init__(
            'google-native:identitytoolkit/v2:InboundSamlConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InboundSamlConfig':
        """
        Get an existing InboundSamlConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InboundSamlConfigArgs.__new__(InboundSamlConfigArgs)

        __props__.__dict__["display_name"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["idp_config"] = None
        __props__.__dict__["inbound_saml_config_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["sp_config"] = None
        __props__.__dict__["tenant_id"] = None
        return InboundSamlConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The config's display name set by developers.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        True if allows the user to sign in with the provider.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> pulumi.Output['outputs.GoogleCloudIdentitytoolkitAdminV2IdpConfigResponse']:
        """
        The SAML IdP (Identity Provider) configuration when the project acts as the relying party.
        """
        return pulumi.get(self, "idp_config")

    @property
    @pulumi.getter(name="inboundSamlConfigId")
    def inbound_saml_config_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id to use for this config.
        """
        return pulumi.get(self, "inbound_saml_config_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the InboundSamlConfig resource, for example: 'projects/my-awesome-project/inboundSamlConfigs/my-config-id'. Ignored during create requests.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="spConfig")
    def sp_config(self) -> pulumi.Output['outputs.GoogleCloudIdentitytoolkitAdminV2SpConfigResponse']:
        """
        The SAML SP (Service Provider) configuration when the project acts as the relying party to receive and accept an authentication assertion issued by a SAML identity provider.
        """
        return pulumi.get(self, "sp_config")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "tenant_id")

