# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DnsKeySpecResponse',
    'ExprResponse',
    'GoogleIamV1AuditConfigResponse',
    'GoogleIamV1AuditLogConfigResponse',
    'GoogleIamV1BindingResponse',
    'ManagedZoneCloudLoggingConfigResponse',
    'ManagedZoneDnsSecConfigResponse',
    'ManagedZoneForwardingConfigNameServerTargetResponse',
    'ManagedZoneForwardingConfigResponse',
    'ManagedZonePeeringConfigResponse',
    'ManagedZonePeeringConfigTargetNetworkResponse',
    'ManagedZonePrivateVisibilityConfigGKEClusterResponse',
    'ManagedZonePrivateVisibilityConfigNetworkResponse',
    'ManagedZonePrivateVisibilityConfigResponse',
    'ManagedZoneReverseLookupConfigResponse',
    'ManagedZoneServiceDirectoryConfigNamespaceResponse',
    'ManagedZoneServiceDirectoryConfigResponse',
    'PolicyAlternativeNameServerConfigResponse',
    'PolicyAlternativeNameServerConfigTargetNameServerResponse',
    'PolicyNetworkResponse',
    'RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse',
    'RRSetRoutingPolicyGeoPolicyResponse',
    'RRSetRoutingPolicyHealthCheckTargetsResponse',
    'RRSetRoutingPolicyLoadBalancerTargetResponse',
    'RRSetRoutingPolicyPrimaryBackupPolicyResponse',
    'RRSetRoutingPolicyResponse',
    'RRSetRoutingPolicyWrrPolicyResponse',
    'RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse',
    'ResourceRecordSetResponse',
    'ResponsePolicyGKEClusterResponse',
    'ResponsePolicyNetworkResponse',
    'ResponsePolicyRuleLocalDataResponse',
]

@pulumi.output_type
class DnsKeySpecResponse(dict):
    """
    Parameters for DnsKey key generation. Used for generating initial keys for a new ManagedZone and as default when adding a new DnsKey.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyLength":
            suggest = "key_length"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DnsKeySpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DnsKeySpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DnsKeySpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 key_length: int,
                 key_type: str,
                 kind: str):
        """
        Parameters for DnsKey key generation. Used for generating initial keys for a new ManagedZone and as default when adding a new DnsKey.
        :param str algorithm: String mnemonic specifying the DNSSEC algorithm of this key.
        :param int key_length: Length of the keys in bits.
        :param str key_type: Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys have the Secure Entry Point flag set and, when active, are only used to sign resource record sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used to sign all other types of resource record sets.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "key_length", key_length)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        String mnemonic specifying the DNSSEC algorithm of this key.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> int:
        """
        Length of the keys in bits.
        """
        return pulumi.get(self, "key_length")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK). Key signing keys have the Secure Entry Point flag set and, when active, are only used to sign resource record sets of type DNSKEY. Zone signing keys do not have the Secure Entry Point flag set and are used to sign all other types of resource record sets.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleIamV1AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GoogleIamV1AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['GoogleIamV1AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GoogleIamV1AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleIamV1AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GoogleIamV1BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ManagedZoneCloudLoggingConfigResponse(dict):
    """
    Cloud Logging configurations for publicly visible zones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableLogging":
            suggest = "enable_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneCloudLoggingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneCloudLoggingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneCloudLoggingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_logging: bool,
                 kind: str):
        """
        Cloud Logging configurations for publicly visible zones.
        :param bool enable_logging: If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        pulumi.set(__self__, "enable_logging", enable_logging)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> bool:
        """
        If set, enable query logging for this ManagedZone. False by default, making logging opt-in.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneDnsSecConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKeySpecs":
            suggest = "default_key_specs"
        elif key == "nonExistence":
            suggest = "non_existence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneDnsSecConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneDnsSecConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneDnsSecConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_key_specs: Sequence['outputs.DnsKeySpecResponse'],
                 kind: str,
                 non_existence: str,
                 state: str):
        """
        :param Sequence['DnsKeySpecResponse'] default_key_specs: Specifies parameters for generating initial DnsKeys for this ManagedZone. Can only be changed while the state is OFF.
        :param str non_existence: Specifies the mechanism for authenticated denial-of-existence responses. Can only be changed while the state is OFF.
        :param str state: Specifies whether DNSSEC is enabled, and what mode it is in.
        """
        pulumi.set(__self__, "default_key_specs", default_key_specs)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "non_existence", non_existence)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="defaultKeySpecs")
    def default_key_specs(self) -> Sequence['outputs.DnsKeySpecResponse']:
        """
        Specifies parameters for generating initial DnsKeys for this ManagedZone. Can only be changed while the state is OFF.
        """
        return pulumi.get(self, "default_key_specs")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="nonExistence")
    def non_existence(self) -> str:
        """
        Specifies the mechanism for authenticated denial-of-existence responses. Can only be changed while the state is OFF.
        """
        return pulumi.get(self, "non_existence")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Specifies whether DNSSEC is enabled, and what mode it is in.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedZoneForwardingConfigNameServerTargetResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingPath":
            suggest = "forwarding_path"
        elif key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv6Address":
            suggest = "ipv6_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneForwardingConfigNameServerTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneForwardingConfigNameServerTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneForwardingConfigNameServerTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarding_path: str,
                 ipv4_address: str,
                 ipv6_address: str,
                 kind: str):
        """
        :param str forwarding_path: Forwarding path for this NameServerTarget. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on IP address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        :param str ipv4_address: IPv4 address of a target name server.
        :param str ipv6_address: IPv6 address of a target name server. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        pulumi.set(__self__, "forwarding_path", forwarding_path)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> str:
        """
        Forwarding path for this NameServerTarget. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on IP address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        """
        return pulumi.get(self, "forwarding_path")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        IPv4 address of a target name server.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        IPv6 address of a target name server. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneForwardingConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNameServers":
            suggest = "target_name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneForwardingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneForwardingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneForwardingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 target_name_servers: Sequence['outputs.ManagedZoneForwardingConfigNameServerTargetResponse']):
        """
        :param Sequence['ManagedZoneForwardingConfigNameServerTargetResponse'] target_name_servers: List of target name servers to forward to. Cloud DNS selects the best available name server if more than one target is given.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Sequence['outputs.ManagedZoneForwardingConfigNameServerTargetResponse']:
        """
        List of target name servers to forward to. Cloud DNS selects the best available name server if more than one target is given.
        """
        return pulumi.get(self, "target_name_servers")


@pulumi.output_type
class ManagedZonePeeringConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNetwork":
            suggest = "target_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 target_network: 'outputs.ManagedZonePeeringConfigTargetNetworkResponse'):
        """
        :param 'ManagedZonePeeringConfigTargetNetworkResponse' target_network: The network with which to peer.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "target_network", target_network)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="targetNetwork")
    def target_network(self) -> 'outputs.ManagedZonePeeringConfigTargetNetworkResponse':
        """
        The network with which to peer.
        """
        return pulumi.get(self, "target_network")


@pulumi.output_type
class ManagedZonePeeringConfigTargetNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deactivateTime":
            suggest = "deactivate_time"
        elif key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePeeringConfigTargetNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePeeringConfigTargetNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePeeringConfigTargetNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deactivate_time: str,
                 kind: str,
                 network_url: str):
        """
        :param str deactivate_time: The time at which the zone was deactivated, in RFC 3339 date-time format. An empty string indicates that the peering connection is active. The producer network can deactivate a zone. The zone is automatically deactivated if the producer network that the zone targeted is deleted. Output only.
        :param str network_url: The fully qualified URL of the VPC network to forward queries to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "deactivate_time", deactivate_time)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter(name="deactivateTime")
    def deactivate_time(self) -> str:
        """
        The time at which the zone was deactivated, in RFC 3339 date-time format. An empty string indicates that the peering connection is active. The producer network can deactivate a zone. The zone is automatically deactivated if the producer network that the zone targeted is deleted. Output only.
        """
        return pulumi.get(self, "deactivate_time")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to forward queries to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigGKEClusterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterName":
            suggest = "gke_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigGKEClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigGKEClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigGKEClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_name: str,
                 kind: str):
        """
        :param str gke_cluster_name: The resource name of the cluster to bind this ManagedZone to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> str:
        """
        The resource name of the cluster to bind this ManagedZone to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        return pulumi.get(self, "gke_cluster_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 network_url: str):
        """
        :param str network_url: The fully qualified URL of the VPC network to bind to. Format this URL like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to bind to. Format this URL like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ManagedZonePrivateVisibilityConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusters":
            suggest = "gke_clusters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZonePrivateVisibilityConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZonePrivateVisibilityConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZonePrivateVisibilityConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_clusters: Sequence['outputs.ManagedZonePrivateVisibilityConfigGKEClusterResponse'],
                 kind: str,
                 networks: Sequence['outputs.ManagedZonePrivateVisibilityConfigNetworkResponse']):
        """
        :param Sequence['ManagedZonePrivateVisibilityConfigGKEClusterResponse'] gke_clusters: The list of Google Kubernetes Engine clusters that can see this zone.
        :param Sequence['ManagedZonePrivateVisibilityConfigNetworkResponse'] networks: The list of VPC networks that can see this zone.
        """
        pulumi.set(__self__, "gke_clusters", gke_clusters)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "networks", networks)

    @property
    @pulumi.getter(name="gkeClusters")
    def gke_clusters(self) -> Sequence['outputs.ManagedZonePrivateVisibilityConfigGKEClusterResponse']:
        """
        The list of Google Kubernetes Engine clusters that can see this zone.
        """
        return pulumi.get(self, "gke_clusters")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.ManagedZonePrivateVisibilityConfigNetworkResponse']:
        """
        The list of VPC networks that can see this zone.
        """
        return pulumi.get(self, "networks")


@pulumi.output_type
class ManagedZoneReverseLookupConfigResponse(dict):
    def __init__(__self__, *,
                 kind: str):
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ManagedZoneServiceDirectoryConfigNamespaceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deletionTime":
            suggest = "deletion_time"
        elif key == "namespaceUrl":
            suggest = "namespace_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedZoneServiceDirectoryConfigNamespaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedZoneServiceDirectoryConfigNamespaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedZoneServiceDirectoryConfigNamespaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deletion_time: str,
                 kind: str,
                 namespace_url: str):
        """
        :param str deletion_time: The time that the namespace backing this zone was deleted; an empty string if it still exists. This is in RFC3339 text format. Output only.
        :param str namespace_url: The fully qualified URL of the namespace associated with the zone. Format must be https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
        """
        pulumi.set(__self__, "deletion_time", deletion_time)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespace_url", namespace_url)

    @property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> str:
        """
        The time that the namespace backing this zone was deleted; an empty string if it still exists. This is in RFC3339 text format. Output only.
        """
        return pulumi.get(self, "deletion_time")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="namespaceUrl")
    def namespace_url(self) -> str:
        """
        The fully qualified URL of the namespace associated with the zone. Format must be https://servicedirectory.googleapis.com/v1/projects/{project}/locations/{location}/namespaces/{namespace}
        """
        return pulumi.get(self, "namespace_url")


@pulumi.output_type
class ManagedZoneServiceDirectoryConfigResponse(dict):
    """
    Contains information about Service Directory-backed zones.
    """
    def __init__(__self__, *,
                 kind: str,
                 namespace: 'outputs.ManagedZoneServiceDirectoryConfigNamespaceResponse'):
        """
        Contains information about Service Directory-backed zones.
        :param 'ManagedZoneServiceDirectoryConfigNamespaceResponse' namespace: Contains information about the namespace associated with the zone.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def namespace(self) -> 'outputs.ManagedZoneServiceDirectoryConfigNamespaceResponse':
        """
        Contains information about the namespace associated with the zone.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class PolicyAlternativeNameServerConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetNameServers":
            suggest = "target_name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAlternativeNameServerConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAlternativeNameServerConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAlternativeNameServerConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 target_name_servers: Sequence['outputs.PolicyAlternativeNameServerConfigTargetNameServerResponse']):
        """
        :param Sequence['PolicyAlternativeNameServerConfigTargetNameServerResponse'] target_name_servers: Sets an alternative name server for the associated networks. When specified, all DNS queries are forwarded to a name server that you choose. Names such as .internal are not available when an alternative name server is specified.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "target_name_servers", target_name_servers)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="targetNameServers")
    def target_name_servers(self) -> Sequence['outputs.PolicyAlternativeNameServerConfigTargetNameServerResponse']:
        """
        Sets an alternative name server for the associated networks. When specified, all DNS queries are forwarded to a name server that you choose. Names such as .internal are not available when an alternative name server is specified.
        """
        return pulumi.get(self, "target_name_servers")


@pulumi.output_type
class PolicyAlternativeNameServerConfigTargetNameServerResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardingPath":
            suggest = "forwarding_path"
        elif key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv6Address":
            suggest = "ipv6_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyAlternativeNameServerConfigTargetNameServerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyAlternativeNameServerConfigTargetNameServerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyAlternativeNameServerConfigTargetNameServerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarding_path: str,
                 ipv4_address: str,
                 ipv6_address: str,
                 kind: str):
        """
        :param str forwarding_path: Forwarding path for this TargetNameServer. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        :param str ipv4_address: IPv4 address to forward queries to.
        :param str ipv6_address: IPv6 address to forward to. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        pulumi.set(__self__, "forwarding_path", forwarding_path)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="forwardingPath")
    def forwarding_path(self) -> str:
        """
        Forwarding path for this TargetNameServer. If unset or set to DEFAULT, Cloud DNS makes forwarding decisions based on address ranges; that is, RFC1918 addresses go to the VPC network, non-RFC1918 addresses go to the internet. When set to PRIVATE, Cloud DNS always sends queries through the VPC network for this target.
        """
        return pulumi.get(self, "forwarding_path")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        IPv4 address to forward queries to.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        IPv6 address to forward to. Does not accept both fields (ipv4 & ipv6) being populated.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class PolicyNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 network_url: str):
        """
        :param str network_url: The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse(dict):
    """
    ResourceRecordSet data for one geo location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckedTargets":
            suggest = "health_checked_targets"
        elif key == "signatureRrdatas":
            suggest = "signature_rrdatas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_checked_targets: 'outputs.RRSetRoutingPolicyHealthCheckTargetsResponse',
                 kind: str,
                 location: str,
                 rrdatas: Sequence[str],
                 signature_rrdatas: Sequence[str]):
        """
        ResourceRecordSet data for one geo location.
        :param 'RRSetRoutingPolicyHealthCheckTargetsResponse' health_checked_targets: For A and AAAA types only. Endpoints to return in the query result only if they are healthy. These can be specified along with rrdata within this item.
        :param str location: The geo-location granularity is a GCP region. This location string should correspond to a GCP region. e.g. "us-east1", "southamerica-east1", "asia-east1", etc.
        :param Sequence[str] signature_rrdatas: DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        """
        pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "rrdatas", rrdatas)
        pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> 'outputs.RRSetRoutingPolicyHealthCheckTargetsResponse':
        """
        For A and AAAA types only. Endpoints to return in the query result only if they are healthy. These can be specified along with rrdata within this item.
        """
        return pulumi.get(self, "health_checked_targets")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location granularity is a GCP region. This location string should correspond to a GCP region. e.g. "us-east1", "southamerica-east1", "asia-east1", etc.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def rrdatas(self) -> Sequence[str]:
        return pulumi.get(self, "rrdatas")

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Sequence[str]:
        """
        DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        """
        return pulumi.get(self, "signature_rrdatas")


@pulumi.output_type
class RRSetRoutingPolicyGeoPolicyResponse(dict):
    """
    Configures a RRSetRoutingPolicy that routes based on the geo location of the querying user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableFencing":
            suggest = "enable_fencing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyGeoPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyGeoPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyGeoPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_fencing: bool,
                 items: Sequence['outputs.RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse'],
                 kind: str):
        """
        Configures a RRSetRoutingPolicy that routes based on the geo location of the querying user.
        :param bool enable_fencing: Without fencing, if health check fails for all configured items in the current geo bucket, we'll failover to the next nearest geo bucket. With fencing, if health check is enabled, as long as some targets in the current geo bucket are healthy, we'll return only the healthy targets. However, if they're all unhealthy, we won't failover to the next nearest bucket, we'll simply return all the items in the current bucket even though they're unhealthy.
        :param Sequence['RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse'] items: The primary geo routing configuration. If there are multiple items with the same location, an error is returned instead.
        """
        pulumi.set(__self__, "enable_fencing", enable_fencing)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="enableFencing")
    def enable_fencing(self) -> bool:
        """
        Without fencing, if health check fails for all configured items in the current geo bucket, we'll failover to the next nearest geo bucket. With fencing, if health check is enabled, as long as some targets in the current geo bucket are healthy, we'll return only the healthy targets. However, if they're all unhealthy, we won't failover to the next nearest bucket, we'll simply return all the items in the current bucket even though they're unhealthy.
        """
        return pulumi.get(self, "enable_fencing")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.RRSetRoutingPolicyGeoPolicyGeoPolicyItemResponse']:
        """
        The primary geo routing configuration. If there are multiple items with the same location, an error is returned instead.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class RRSetRoutingPolicyHealthCheckTargetsResponse(dict):
    """
    HealthCheckTargets describes endpoints to health-check when responding to Routing Policy queries. Only the healthy endpoints will be included in the response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalLoadBalancers":
            suggest = "internal_load_balancers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyHealthCheckTargetsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyHealthCheckTargetsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyHealthCheckTargetsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 internal_load_balancers: Sequence['outputs.RRSetRoutingPolicyLoadBalancerTargetResponse']):
        """
        HealthCheckTargets describes endpoints to health-check when responding to Routing Policy queries. Only the healthy endpoints will be included in the response.
        """
        pulumi.set(__self__, "internal_load_balancers", internal_load_balancers)

    @property
    @pulumi.getter(name="internalLoadBalancers")
    def internal_load_balancers(self) -> Sequence['outputs.RRSetRoutingPolicyLoadBalancerTargetResponse']:
        return pulumi.get(self, "internal_load_balancers")


@pulumi.output_type
class RRSetRoutingPolicyLoadBalancerTargetResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"
        elif key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyLoadBalancerTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyLoadBalancerTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyLoadBalancerTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: str,
                 ip_protocol: str,
                 kind: str,
                 load_balancer_type: str,
                 network_url: str,
                 port: str,
                 project: str,
                 region: str):
        """
        :param str ip_address: The frontend IP address of the
        :param str network_url: The fully qualified url of the network on which the ILB is
        :param str port: Load Balancer to health check. The configured port of the Load Balancer.
        :param str project: present. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network} The project ID in which the ILB exists.
        :param str region: The region for regional ILBs.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "network_url", network_url)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The frontend IP address of the
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified url of the network on which the ILB is
        """
        return pulumi.get(self, "network_url")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        Load Balancer to health check. The configured port of the Load Balancer.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        present. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network} The project ID in which the ILB exists.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region for regional ILBs.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RRSetRoutingPolicyPrimaryBackupPolicyResponse(dict):
    """
    Configures a RRSetRoutingPolicy such that all queries are responded with the primary_targets if they are healthy. And if all of them are unhealthy, then we fallback to a geo localized policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupGeoTargets":
            suggest = "backup_geo_targets"
        elif key == "primaryTargets":
            suggest = "primary_targets"
        elif key == "trickleTraffic":
            suggest = "trickle_traffic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyPrimaryBackupPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyPrimaryBackupPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyPrimaryBackupPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_geo_targets: 'outputs.RRSetRoutingPolicyGeoPolicyResponse',
                 kind: str,
                 primary_targets: 'outputs.RRSetRoutingPolicyHealthCheckTargetsResponse',
                 trickle_traffic: float):
        """
        Configures a RRSetRoutingPolicy such that all queries are responded with the primary_targets if they are healthy. And if all of them are unhealthy, then we fallback to a geo localized policy.
        :param 'RRSetRoutingPolicyGeoPolicyResponse' backup_geo_targets: Backup targets provide a regional failover policy for the otherwise global primary targets. If serving state is set to BACKUP, this policy essentially becomes a geo routing policy.
        :param float trickle_traffic: When serving state is PRIMARY, this field provides the option of sending a small percentage of the traffic to the backup targets.
        """
        pulumi.set(__self__, "backup_geo_targets", backup_geo_targets)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "primary_targets", primary_targets)
        pulumi.set(__self__, "trickle_traffic", trickle_traffic)

    @property
    @pulumi.getter(name="backupGeoTargets")
    def backup_geo_targets(self) -> 'outputs.RRSetRoutingPolicyGeoPolicyResponse':
        """
        Backup targets provide a regional failover policy for the otherwise global primary targets. If serving state is set to BACKUP, this policy essentially becomes a geo routing policy.
        """
        return pulumi.get(self, "backup_geo_targets")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="primaryTargets")
    def primary_targets(self) -> 'outputs.RRSetRoutingPolicyHealthCheckTargetsResponse':
        return pulumi.get(self, "primary_targets")

    @property
    @pulumi.getter(name="trickleTraffic")
    def trickle_traffic(self) -> float:
        """
        When serving state is PRIMARY, this field provides the option of sending a small percentage of the traffic to the backup targets.
        """
        return pulumi.get(self, "trickle_traffic")


@pulumi.output_type
class RRSetRoutingPolicyResponse(dict):
    """
    A RRSetRoutingPolicy represents ResourceRecordSet data that is returned dynamically with the response varying based on configured properties such as geolocation or by weighted random selection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoPolicy":
            suggest = "geo_policy"
        elif key == "primaryBackup":
            suggest = "primary_backup"
        elif key == "wrrPolicy":
            suggest = "wrr_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 geo: 'outputs.RRSetRoutingPolicyGeoPolicyResponse',
                 geo_policy: 'outputs.RRSetRoutingPolicyGeoPolicyResponse',
                 kind: str,
                 primary_backup: 'outputs.RRSetRoutingPolicyPrimaryBackupPolicyResponse',
                 wrr: 'outputs.RRSetRoutingPolicyWrrPolicyResponse',
                 wrr_policy: 'outputs.RRSetRoutingPolicyWrrPolicyResponse'):
        """
        A RRSetRoutingPolicy represents ResourceRecordSet data that is returned dynamically with the response varying based on configured properties such as geolocation or by weighted random selection.
        """
        pulumi.set(__self__, "geo", geo)
        pulumi.set(__self__, "geo_policy", geo_policy)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "primary_backup", primary_backup)
        pulumi.set(__self__, "wrr", wrr)
        pulumi.set(__self__, "wrr_policy", wrr_policy)

    @property
    @pulumi.getter
    def geo(self) -> 'outputs.RRSetRoutingPolicyGeoPolicyResponse':
        return pulumi.get(self, "geo")

    @property
    @pulumi.getter(name="geoPolicy")
    def geo_policy(self) -> 'outputs.RRSetRoutingPolicyGeoPolicyResponse':
        return pulumi.get(self, "geo_policy")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="primaryBackup")
    def primary_backup(self) -> 'outputs.RRSetRoutingPolicyPrimaryBackupPolicyResponse':
        return pulumi.get(self, "primary_backup")

    @property
    @pulumi.getter
    def wrr(self) -> 'outputs.RRSetRoutingPolicyWrrPolicyResponse':
        return pulumi.get(self, "wrr")

    @property
    @pulumi.getter(name="wrrPolicy")
    def wrr_policy(self) -> 'outputs.RRSetRoutingPolicyWrrPolicyResponse':
        return pulumi.get(self, "wrr_policy")


@pulumi.output_type
class RRSetRoutingPolicyWrrPolicyResponse(dict):
    """
    Configures a RRSetRoutingPolicy that routes in a weighted round robin fashion.
    """
    def __init__(__self__, *,
                 items: Sequence['outputs.RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse'],
                 kind: str):
        """
        Configures a RRSetRoutingPolicy that routes in a weighted round robin fashion.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse(dict):
    """
    A routing block which contains the routing information for one WRR item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckedTargets":
            suggest = "health_checked_targets"
        elif key == "signatureRrdatas":
            suggest = "signature_rrdatas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RRSetRoutingPolicyWrrPolicyWrrPolicyItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_checked_targets: 'outputs.RRSetRoutingPolicyHealthCheckTargetsResponse',
                 kind: str,
                 rrdatas: Sequence[str],
                 signature_rrdatas: Sequence[str],
                 weight: float):
        """
        A routing block which contains the routing information for one WRR item.
        :param 'RRSetRoutingPolicyHealthCheckTargetsResponse' health_checked_targets: endpoints that need to be health checked before making the routing decision. The unhealthy endpoints will be omitted from the result. If all endpoints within a buckete are unhealthy, we'll choose a different bucket (sampled w.r.t. its weight) for responding. Note that if DNSSEC is enabled for this zone, only one of rrdata or health_checked_targets can be set.
        :param Sequence[str] signature_rrdatas: DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        :param float weight: The weight corresponding to this subset of rrdata. When multiple WeightedRoundRobinPolicyItems are configured, the probability of returning an rrset is proportional to its weight relative to the sum of weights configured for all items. This weight should be non-negative.
        """
        pulumi.set(__self__, "health_checked_targets", health_checked_targets)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "rrdatas", rrdatas)
        pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="healthCheckedTargets")
    def health_checked_targets(self) -> 'outputs.RRSetRoutingPolicyHealthCheckTargetsResponse':
        """
        endpoints that need to be health checked before making the routing decision. The unhealthy endpoints will be omitted from the result. If all endpoints within a buckete are unhealthy, we'll choose a different bucket (sampled w.r.t. its weight) for responding. Note that if DNSSEC is enabled for this zone, only one of rrdata or health_checked_targets can be set.
        """
        return pulumi.get(self, "health_checked_targets")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def rrdatas(self) -> Sequence[str]:
        return pulumi.get(self, "rrdatas")

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Sequence[str]:
        """
        DNSSEC generated signatures for all the rrdata within this item. Note that if health checked targets are provided for DNSSEC enabled zones, there's a restriction of 1 ip per item. .
        """
        return pulumi.get(self, "signature_rrdatas")

    @property
    @pulumi.getter
    def weight(self) -> float:
        """
        The weight corresponding to this subset of rrdata. When multiple WeightedRoundRobinPolicyItems are configured, the probability of returning an rrset is proportional to its weight relative to the sum of weights configured for all items. This weight should be non-negative.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ResourceRecordSetResponse(dict):
    """
    A unit of data that is returned by the DNS servers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routingPolicy":
            suggest = "routing_policy"
        elif key == "signatureRrdatas":
            suggest = "signature_rrdatas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceRecordSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceRecordSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceRecordSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: str,
                 routing_policy: 'outputs.RRSetRoutingPolicyResponse',
                 rrdatas: Sequence[str],
                 signature_rrdatas: Sequence[str],
                 ttl: int,
                 type: str):
        """
        A unit of data that is returned by the DNS servers.
        :param str name: For example, www.example.com.
        :param 'RRSetRoutingPolicyResponse' routing_policy: Configures dynamic query responses based on geo location of querying user or a weighted round robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or routing_policy (dynamic). An error is returned otherwise.
        :param Sequence[str] rrdatas: As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
        :param Sequence[str] signature_rrdatas: As defined in RFC 4034 (section 3.2).
        :param int ttl: Number of seconds that this ResourceRecordSet can be cached by resolvers.
        :param str type: The identifier of a supported record type. See the list of Supported DNS record types.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routing_policy", routing_policy)
        pulumi.set(__self__, "rrdatas", rrdatas)
        pulumi.set(__self__, "signature_rrdatas", signature_rrdatas)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        For example, www.example.com.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingPolicy")
    def routing_policy(self) -> 'outputs.RRSetRoutingPolicyResponse':
        """
        Configures dynamic query responses based on geo location of querying user or a weighted round robin based routing policy. A ResourceRecordSet should only have either rrdata (static) or routing_policy (dynamic). An error is returned otherwise.
        """
        return pulumi.get(self, "routing_policy")

    @property
    @pulumi.getter
    def rrdatas(self) -> Sequence[str]:
        """
        As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1) -- see examples.
        """
        return pulumi.get(self, "rrdatas")

    @property
    @pulumi.getter(name="signatureRrdatas")
    def signature_rrdatas(self) -> Sequence[str]:
        """
        As defined in RFC 4034 (section 3.2).
        """
        return pulumi.get(self, "signature_rrdatas")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        Number of seconds that this ResourceRecordSet can be cached by resolvers.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identifier of a supported record type. See the list of Supported DNS record types.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResponsePolicyGKEClusterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gkeClusterName":
            suggest = "gke_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyGKEClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyGKEClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyGKEClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gke_cluster_name: str,
                 kind: str):
        """
        :param str gke_cluster_name: The resource name of the cluster to bind this response policy to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        pulumi.set(__self__, "gke_cluster_name", gke_cluster_name)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="gkeClusterName")
    def gke_cluster_name(self) -> str:
        """
        The resource name of the cluster to bind this response policy to. This should be specified in the format like: projects/*/locations/*/clusters/*. This is referenced from GKE projects.locations.clusters.get API: https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/get
        """
        return pulumi.get(self, "gke_cluster_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")


@pulumi.output_type
class ResponsePolicyNetworkResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkUrl":
            suggest = "network_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyNetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyNetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyNetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 network_url: str):
        """
        :param str network_url: The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "network_url", network_url)

    @property
    @pulumi.getter
    def kind(self) -> str:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="networkUrl")
    def network_url(self) -> str:
        """
        The fully qualified URL of the VPC network to bind to. This should be formatted like https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
        """
        return pulumi.get(self, "network_url")


@pulumi.output_type
class ResponsePolicyRuleLocalDataResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localDatas":
            suggest = "local_datas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponsePolicyRuleLocalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponsePolicyRuleLocalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponsePolicyRuleLocalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_datas: Sequence['outputs.ResourceRecordSetResponse']):
        """
        :param Sequence['ResourceRecordSetResponse'] local_datas: All resource record sets for this selector, one per resource record type. The name must match the dns_name.
        """
        pulumi.set(__self__, "local_datas", local_datas)

    @property
    @pulumi.getter(name="localDatas")
    def local_datas(self) -> Sequence['outputs.ResourceRecordSetResponse']:
        """
        All resource record sets for this selector, one per resource record type. The name must match the dns_name.
        """
        return pulumi.get(self, "local_datas")


