# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AutoscalingSettingsAlgorithm',
    'EnvironmentFlexResourceSchedulingGoal',
    'ExecutionStageStateExecutionStageState',
    'ExecutionStageSummaryKind',
    'JobCurrentState',
    'JobRequestedState',
    'JobType',
    'RuntimeEnvironmentIpConfiguration',
    'SdkVersionSdkSupportStatus',
    'TransformSummaryKind',
    'WorkerPoolDefaultPackageSet',
    'WorkerPoolIpConfiguration',
    'WorkerPoolTeardownPolicy',
]


class AutoscalingSettingsAlgorithm(str, Enum):
    """
    The algorithm to use for autoscaling.
    """
    AUTOSCALING_ALGORITHM_UNKNOWN = "AUTOSCALING_ALGORITHM_UNKNOWN"
    """
    The algorithm is unknown, or unspecified.
    """
    AUTOSCALING_ALGORITHM_NONE = "AUTOSCALING_ALGORITHM_NONE"
    """
    Disable autoscaling.
    """
    AUTOSCALING_ALGORITHM_BASIC = "AUTOSCALING_ALGORITHM_BASIC"
    """
    Increase worker count over time to reduce job execution time.
    """


class EnvironmentFlexResourceSchedulingGoal(str, Enum):
    """
    Which Flexible Resource Scheduling mode to run in.
    """
    FLEXRS_UNSPECIFIED = "FLEXRS_UNSPECIFIED"
    """
    Run in the default mode.
    """
    FLEXRS_SPEED_OPTIMIZED = "FLEXRS_SPEED_OPTIMIZED"
    """
    Optimize for lower execution time.
    """
    FLEXRS_COST_OPTIMIZED = "FLEXRS_COST_OPTIMIZED"
    """
    Optimize for lower cost.
    """


class ExecutionStageStateExecutionStageState(str, Enum):
    """
    Executions stage states allow the same set of values as JobState.
    """
    JOB_STATE_UNKNOWN = "JOB_STATE_UNKNOWN"
    """
    The job's run state isn't specified.
    """
    JOB_STATE_STOPPED = "JOB_STATE_STOPPED"
    """
    `JOB_STATE_STOPPED` indicates that the job has not yet started to run.
    """
    JOB_STATE_RUNNING = "JOB_STATE_RUNNING"
    """
    `JOB_STATE_RUNNING` indicates that the job is currently running.
    """
    JOB_STATE_DONE = "JOB_STATE_DONE"
    """
    `JOB_STATE_DONE` indicates that the job has successfully completed. This is a terminal job state. This state may be set by the Cloud Dataflow service, as a transition from `JOB_STATE_RUNNING`. It may also be set via a Cloud Dataflow `UpdateJob` call, if the job has not yet reached a terminal state.
    """
    JOB_STATE_FAILED = "JOB_STATE_FAILED"
    """
    `JOB_STATE_FAILED` indicates that the job has failed. This is a terminal job state. This state may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_RUNNING`.
    """
    JOB_STATE_CANCELLED = "JOB_STATE_CANCELLED"
    """
    `JOB_STATE_CANCELLED` indicates that the job has been explicitly cancelled. This is a terminal job state. This state may only be set via a Cloud Dataflow `UpdateJob` call, and only if the job has not yet reached another terminal state.
    """
    JOB_STATE_UPDATED = "JOB_STATE_UPDATED"
    """
    `JOB_STATE_UPDATED` indicates that the job was successfully updated, meaning that this job was stopped and another job was started, inheriting state from this one. This is a terminal job state. This state may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_RUNNING`.
    """
    JOB_STATE_DRAINING = "JOB_STATE_DRAINING"
    """
    `JOB_STATE_DRAINING` indicates that the job is in the process of draining. A draining job has stopped pulling from its input sources and is processing any data that remains in-flight. This state may be set via a Cloud Dataflow `UpdateJob` call, but only as a transition from `JOB_STATE_RUNNING`. Jobs that are draining may only transition to `JOB_STATE_DRAINED`, `JOB_STATE_CANCELLED`, or `JOB_STATE_FAILED`.
    """
    JOB_STATE_DRAINED = "JOB_STATE_DRAINED"
    """
    `JOB_STATE_DRAINED` indicates that the job has been drained. A drained job terminated by stopping pulling from its input sources and processing any data that remained in-flight when draining was requested. This state is a terminal state, may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_DRAINING`.
    """
    JOB_STATE_PENDING = "JOB_STATE_PENDING"
    """
    `JOB_STATE_PENDING` indicates that the job has been created but is not yet running. Jobs that are pending may only transition to `JOB_STATE_RUNNING`, or `JOB_STATE_FAILED`.
    """
    JOB_STATE_CANCELLING = "JOB_STATE_CANCELLING"
    """
    `JOB_STATE_CANCELLING` indicates that the job has been explicitly cancelled and is in the process of stopping. Jobs that are cancelling may only transition to `JOB_STATE_CANCELLED` or `JOB_STATE_FAILED`.
    """
    JOB_STATE_QUEUED = "JOB_STATE_QUEUED"
    """
    `JOB_STATE_QUEUED` indicates that the job has been created but is being delayed until launch. Jobs that are queued may only transition to `JOB_STATE_PENDING` or `JOB_STATE_CANCELLED`.
    """
    JOB_STATE_RESOURCE_CLEANING_UP = "JOB_STATE_RESOURCE_CLEANING_UP"
    """
    `JOB_STATE_RESOURCE_CLEANING_UP` indicates that the batch job's associated resources are currently being cleaned up after a successful run. Currently, this is an opt-in feature, please reach out to Cloud support team if you are interested.
    """


class ExecutionStageSummaryKind(str, Enum):
    """
    Type of transform this stage is executing.
    """
    UNKNOWN_KIND = "UNKNOWN_KIND"
    """
    Unrecognized transform type.
    """
    PAR_DO_KIND = "PAR_DO_KIND"
    """
    ParDo transform.
    """
    GROUP_BY_KEY_KIND = "GROUP_BY_KEY_KIND"
    """
    Group By Key transform.
    """
    FLATTEN_KIND = "FLATTEN_KIND"
    """
    Flatten transform.
    """
    READ_KIND = "READ_KIND"
    """
    Read transform.
    """
    WRITE_KIND = "WRITE_KIND"
    """
    Write transform.
    """
    CONSTANT_KIND = "CONSTANT_KIND"
    """
    Constructs from a constant value, such as with Create.of.
    """
    SINGLETON_KIND = "SINGLETON_KIND"
    """
    Creates a Singleton view of a collection.
    """
    SHUFFLE_KIND = "SHUFFLE_KIND"
    """
    Opening or closing a shuffle session, often as part of a GroupByKey.
    """


class JobCurrentState(str, Enum):
    """
    The current state of the job. Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise specified. A job in the `JOB_STATE_RUNNING` state may asynchronously enter a terminal state. After a job has reached a terminal state, no further state updates may be made. This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
    """
    JOB_STATE_UNKNOWN = "JOB_STATE_UNKNOWN"
    """
    The job's run state isn't specified.
    """
    JOB_STATE_STOPPED = "JOB_STATE_STOPPED"
    """
    `JOB_STATE_STOPPED` indicates that the job has not yet started to run.
    """
    JOB_STATE_RUNNING = "JOB_STATE_RUNNING"
    """
    `JOB_STATE_RUNNING` indicates that the job is currently running.
    """
    JOB_STATE_DONE = "JOB_STATE_DONE"
    """
    `JOB_STATE_DONE` indicates that the job has successfully completed. This is a terminal job state. This state may be set by the Cloud Dataflow service, as a transition from `JOB_STATE_RUNNING`. It may also be set via a Cloud Dataflow `UpdateJob` call, if the job has not yet reached a terminal state.
    """
    JOB_STATE_FAILED = "JOB_STATE_FAILED"
    """
    `JOB_STATE_FAILED` indicates that the job has failed. This is a terminal job state. This state may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_RUNNING`.
    """
    JOB_STATE_CANCELLED = "JOB_STATE_CANCELLED"
    """
    `JOB_STATE_CANCELLED` indicates that the job has been explicitly cancelled. This is a terminal job state. This state may only be set via a Cloud Dataflow `UpdateJob` call, and only if the job has not yet reached another terminal state.
    """
    JOB_STATE_UPDATED = "JOB_STATE_UPDATED"
    """
    `JOB_STATE_UPDATED` indicates that the job was successfully updated, meaning that this job was stopped and another job was started, inheriting state from this one. This is a terminal job state. This state may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_RUNNING`.
    """
    JOB_STATE_DRAINING = "JOB_STATE_DRAINING"
    """
    `JOB_STATE_DRAINING` indicates that the job is in the process of draining. A draining job has stopped pulling from its input sources and is processing any data that remains in-flight. This state may be set via a Cloud Dataflow `UpdateJob` call, but only as a transition from `JOB_STATE_RUNNING`. Jobs that are draining may only transition to `JOB_STATE_DRAINED`, `JOB_STATE_CANCELLED`, or `JOB_STATE_FAILED`.
    """
    JOB_STATE_DRAINED = "JOB_STATE_DRAINED"
    """
    `JOB_STATE_DRAINED` indicates that the job has been drained. A drained job terminated by stopping pulling from its input sources and processing any data that remained in-flight when draining was requested. This state is a terminal state, may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_DRAINING`.
    """
    JOB_STATE_PENDING = "JOB_STATE_PENDING"
    """
    `JOB_STATE_PENDING` indicates that the job has been created but is not yet running. Jobs that are pending may only transition to `JOB_STATE_RUNNING`, or `JOB_STATE_FAILED`.
    """
    JOB_STATE_CANCELLING = "JOB_STATE_CANCELLING"
    """
    `JOB_STATE_CANCELLING` indicates that the job has been explicitly cancelled and is in the process of stopping. Jobs that are cancelling may only transition to `JOB_STATE_CANCELLED` or `JOB_STATE_FAILED`.
    """
    JOB_STATE_QUEUED = "JOB_STATE_QUEUED"
    """
    `JOB_STATE_QUEUED` indicates that the job has been created but is being delayed until launch. Jobs that are queued may only transition to `JOB_STATE_PENDING` or `JOB_STATE_CANCELLED`.
    """
    JOB_STATE_RESOURCE_CLEANING_UP = "JOB_STATE_RESOURCE_CLEANING_UP"
    """
    `JOB_STATE_RESOURCE_CLEANING_UP` indicates that the batch job's associated resources are currently being cleaned up after a successful run. Currently, this is an opt-in feature, please reach out to Cloud support team if you are interested.
    """


class JobRequestedState(str, Enum):
    """
    The job's requested state. `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING` states, by setting requested_state. `UpdateJob` may also be used to directly set a job's requested state to `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the job if it has not already reached a terminal state.
    """
    JOB_STATE_UNKNOWN = "JOB_STATE_UNKNOWN"
    """
    The job's run state isn't specified.
    """
    JOB_STATE_STOPPED = "JOB_STATE_STOPPED"
    """
    `JOB_STATE_STOPPED` indicates that the job has not yet started to run.
    """
    JOB_STATE_RUNNING = "JOB_STATE_RUNNING"
    """
    `JOB_STATE_RUNNING` indicates that the job is currently running.
    """
    JOB_STATE_DONE = "JOB_STATE_DONE"
    """
    `JOB_STATE_DONE` indicates that the job has successfully completed. This is a terminal job state. This state may be set by the Cloud Dataflow service, as a transition from `JOB_STATE_RUNNING`. It may also be set via a Cloud Dataflow `UpdateJob` call, if the job has not yet reached a terminal state.
    """
    JOB_STATE_FAILED = "JOB_STATE_FAILED"
    """
    `JOB_STATE_FAILED` indicates that the job has failed. This is a terminal job state. This state may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_RUNNING`.
    """
    JOB_STATE_CANCELLED = "JOB_STATE_CANCELLED"
    """
    `JOB_STATE_CANCELLED` indicates that the job has been explicitly cancelled. This is a terminal job state. This state may only be set via a Cloud Dataflow `UpdateJob` call, and only if the job has not yet reached another terminal state.
    """
    JOB_STATE_UPDATED = "JOB_STATE_UPDATED"
    """
    `JOB_STATE_UPDATED` indicates that the job was successfully updated, meaning that this job was stopped and another job was started, inheriting state from this one. This is a terminal job state. This state may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_RUNNING`.
    """
    JOB_STATE_DRAINING = "JOB_STATE_DRAINING"
    """
    `JOB_STATE_DRAINING` indicates that the job is in the process of draining. A draining job has stopped pulling from its input sources and is processing any data that remains in-flight. This state may be set via a Cloud Dataflow `UpdateJob` call, but only as a transition from `JOB_STATE_RUNNING`. Jobs that are draining may only transition to `JOB_STATE_DRAINED`, `JOB_STATE_CANCELLED`, or `JOB_STATE_FAILED`.
    """
    JOB_STATE_DRAINED = "JOB_STATE_DRAINED"
    """
    `JOB_STATE_DRAINED` indicates that the job has been drained. A drained job terminated by stopping pulling from its input sources and processing any data that remained in-flight when draining was requested. This state is a terminal state, may only be set by the Cloud Dataflow service, and only as a transition from `JOB_STATE_DRAINING`.
    """
    JOB_STATE_PENDING = "JOB_STATE_PENDING"
    """
    `JOB_STATE_PENDING` indicates that the job has been created but is not yet running. Jobs that are pending may only transition to `JOB_STATE_RUNNING`, or `JOB_STATE_FAILED`.
    """
    JOB_STATE_CANCELLING = "JOB_STATE_CANCELLING"
    """
    `JOB_STATE_CANCELLING` indicates that the job has been explicitly cancelled and is in the process of stopping. Jobs that are cancelling may only transition to `JOB_STATE_CANCELLED` or `JOB_STATE_FAILED`.
    """
    JOB_STATE_QUEUED = "JOB_STATE_QUEUED"
    """
    `JOB_STATE_QUEUED` indicates that the job has been created but is being delayed until launch. Jobs that are queued may only transition to `JOB_STATE_PENDING` or `JOB_STATE_CANCELLED`.
    """
    JOB_STATE_RESOURCE_CLEANING_UP = "JOB_STATE_RESOURCE_CLEANING_UP"
    """
    `JOB_STATE_RESOURCE_CLEANING_UP` indicates that the batch job's associated resources are currently being cleaned up after a successful run. Currently, this is an opt-in feature, please reach out to Cloud support team if you are interested.
    """


class JobType(str, Enum):
    """
    The type of Cloud Dataflow job.
    """
    JOB_TYPE_UNKNOWN = "JOB_TYPE_UNKNOWN"
    """
    The type of the job is unspecified, or unknown.
    """
    JOB_TYPE_BATCH = "JOB_TYPE_BATCH"
    """
    A batch job with a well-defined end point: data is read, data is processed, data is written, and the job is done.
    """
    JOB_TYPE_STREAMING = "JOB_TYPE_STREAMING"
    """
    A continuously streaming job with no end: data is read, processed, and written continuously.
    """


class RuntimeEnvironmentIpConfiguration(str, Enum):
    """
    Configuration for VM IPs.
    """
    WORKER_IP_UNSPECIFIED = "WORKER_IP_UNSPECIFIED"
    """
    The configuration is unknown, or unspecified.
    """
    WORKER_IP_PUBLIC = "WORKER_IP_PUBLIC"
    """
    Workers should have public IP addresses.
    """
    WORKER_IP_PRIVATE = "WORKER_IP_PRIVATE"
    """
    Workers should have private IP addresses.
    """


class SdkVersionSdkSupportStatus(str, Enum):
    """
    The support status for this SDK version.
    """
    UNKNOWN = "UNKNOWN"
    """
    Cloud Dataflow is unaware of this version.
    """
    SUPPORTED = "SUPPORTED"
    """
    This is a known version of an SDK, and is supported.
    """
    STALE = "STALE"
    """
    A newer version of the SDK family exists, and an update is recommended.
    """
    DEPRECATED = "DEPRECATED"
    """
    This version of the SDK is deprecated and will eventually be unsupported.
    """
    UNSUPPORTED = "UNSUPPORTED"
    """
    Support for this SDK version has ended and it should no longer be used.
    """


class TransformSummaryKind(str, Enum):
    """
    Type of transform.
    """
    UNKNOWN_KIND = "UNKNOWN_KIND"
    """
    Unrecognized transform type.
    """
    PAR_DO_KIND = "PAR_DO_KIND"
    """
    ParDo transform.
    """
    GROUP_BY_KEY_KIND = "GROUP_BY_KEY_KIND"
    """
    Group By Key transform.
    """
    FLATTEN_KIND = "FLATTEN_KIND"
    """
    Flatten transform.
    """
    READ_KIND = "READ_KIND"
    """
    Read transform.
    """
    WRITE_KIND = "WRITE_KIND"
    """
    Write transform.
    """
    CONSTANT_KIND = "CONSTANT_KIND"
    """
    Constructs from a constant value, such as with Create.of.
    """
    SINGLETON_KIND = "SINGLETON_KIND"
    """
    Creates a Singleton view of a collection.
    """
    SHUFFLE_KIND = "SHUFFLE_KIND"
    """
    Opening or closing a shuffle session, often as part of a GroupByKey.
    """


class WorkerPoolDefaultPackageSet(str, Enum):
    """
    The default package set to install. This allows the service to select a default set of packages which are useful to worker harnesses written in a particular language.
    """
    DEFAULT_PACKAGE_SET_UNKNOWN = "DEFAULT_PACKAGE_SET_UNKNOWN"
    """
    The default set of packages to stage is unknown, or unspecified.
    """
    DEFAULT_PACKAGE_SET_NONE = "DEFAULT_PACKAGE_SET_NONE"
    """
    Indicates that no packages should be staged at the worker unless explicitly specified by the job.
    """
    DEFAULT_PACKAGE_SET_JAVA = "DEFAULT_PACKAGE_SET_JAVA"
    """
    Stage packages typically useful to workers written in Java.
    """
    DEFAULT_PACKAGE_SET_PYTHON = "DEFAULT_PACKAGE_SET_PYTHON"
    """
    Stage packages typically useful to workers written in Python.
    """


class WorkerPoolIpConfiguration(str, Enum):
    """
    Configuration for VM IPs.
    """
    WORKER_IP_UNSPECIFIED = "WORKER_IP_UNSPECIFIED"
    """
    The configuration is unknown, or unspecified.
    """
    WORKER_IP_PUBLIC = "WORKER_IP_PUBLIC"
    """
    Workers should have public IP addresses.
    """
    WORKER_IP_PRIVATE = "WORKER_IP_PRIVATE"
    """
    Workers should have private IP addresses.
    """


class WorkerPoolTeardownPolicy(str, Enum):
    """
    Sets the policy for determining when to turndown worker pool. Allowed values are: `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn down. If the workers are not torn down by the service, they will continue to run and use Google Compute Engine VM resources in the user's project until they are explicitly terminated by the user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small, manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a reasonable default.
    """
    TEARDOWN_POLICY_UNKNOWN = "TEARDOWN_POLICY_UNKNOWN"
    """
    The teardown policy isn't specified, or is unknown.
    """
    TEARDOWN_ALWAYS = "TEARDOWN_ALWAYS"
    """
    Always teardown the resource.
    """
    TEARDOWN_ON_SUCCESS = "TEARDOWN_ON_SUCCESS"
    """
    Teardown the resource on success. This is useful for debugging failures.
    """
    TEARDOWN_NEVER = "TEARDOWN_NEVER"
    """
    Never teardown the resource. This is useful for debugging and development.
    """
