# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetDocumentResult',
    'AwaitableGetDocumentResult',
    'get_document',
    'get_document_output',
]

@pulumi.output_type
class GetDocumentResult:
    def __init__(__self__, async_enabled=None, cloud_ai_document=None, create_time=None, creator=None, display_name=None, display_uri=None, document_schema_name=None, inline_raw_document=None, name=None, plain_text=None, properties=None, raw_document_file_type=None, raw_document_path=None, reference_id=None, structured_content_uri=None, text_extraction_disabled=None, title=None, update_time=None, updater=None):
        if async_enabled and not isinstance(async_enabled, bool):
            raise TypeError("Expected argument 'async_enabled' to be a bool")
        pulumi.set(__self__, "async_enabled", async_enabled)
        if cloud_ai_document and not isinstance(cloud_ai_document, dict):
            raise TypeError("Expected argument 'cloud_ai_document' to be a dict")
        pulumi.set(__self__, "cloud_ai_document", cloud_ai_document)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if creator and not isinstance(creator, str):
            raise TypeError("Expected argument 'creator' to be a str")
        pulumi.set(__self__, "creator", creator)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_uri and not isinstance(display_uri, str):
            raise TypeError("Expected argument 'display_uri' to be a str")
        pulumi.set(__self__, "display_uri", display_uri)
        if document_schema_name and not isinstance(document_schema_name, str):
            raise TypeError("Expected argument 'document_schema_name' to be a str")
        pulumi.set(__self__, "document_schema_name", document_schema_name)
        if inline_raw_document and not isinstance(inline_raw_document, str):
            raise TypeError("Expected argument 'inline_raw_document' to be a str")
        pulumi.set(__self__, "inline_raw_document", inline_raw_document)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plain_text and not isinstance(plain_text, str):
            raise TypeError("Expected argument 'plain_text' to be a str")
        pulumi.set(__self__, "plain_text", plain_text)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if raw_document_file_type and not isinstance(raw_document_file_type, str):
            raise TypeError("Expected argument 'raw_document_file_type' to be a str")
        pulumi.set(__self__, "raw_document_file_type", raw_document_file_type)
        if raw_document_path and not isinstance(raw_document_path, str):
            raise TypeError("Expected argument 'raw_document_path' to be a str")
        pulumi.set(__self__, "raw_document_path", raw_document_path)
        if reference_id and not isinstance(reference_id, str):
            raise TypeError("Expected argument 'reference_id' to be a str")
        pulumi.set(__self__, "reference_id", reference_id)
        if structured_content_uri and not isinstance(structured_content_uri, str):
            raise TypeError("Expected argument 'structured_content_uri' to be a str")
        pulumi.set(__self__, "structured_content_uri", structured_content_uri)
        if text_extraction_disabled and not isinstance(text_extraction_disabled, bool):
            raise TypeError("Expected argument 'text_extraction_disabled' to be a bool")
        pulumi.set(__self__, "text_extraction_disabled", text_extraction_disabled)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if updater and not isinstance(updater, str):
            raise TypeError("Expected argument 'updater' to be a str")
        pulumi.set(__self__, "updater", updater)

    @property
    @pulumi.getter(name="asyncEnabled")
    def async_enabled(self) -> bool:
        """
        If true, makes the document visible to asynchronous policies and rules.
        """
        return pulumi.get(self, "async_enabled")

    @property
    @pulumi.getter(name="cloudAiDocument")
    def cloud_ai_document(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentResponse':
        """
        Document AI format to save the structured content, including OCR.
        """
        return pulumi.get(self, "cloud_ai_document")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the document is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        The user who creates the document.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the document given by the user. This name will be displayed in the UI. Customer can populate this field with the name of the document. This differs from the 'title' field as 'title' is optional and stores the top heading in the document.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayUri")
    def display_uri(self) -> str:
        """
        Uri to display the document, for example, in the UI.
        """
        return pulumi.get(self, "display_uri")

    @property
    @pulumi.getter(name="documentSchemaName")
    def document_schema_name(self) -> str:
        """
        The Document schema name. Format: projects/{project_number}/locations/{location}/documentSchemas/{document_schema_id}.
        """
        return pulumi.get(self, "document_schema_name")

    @property
    @pulumi.getter(name="inlineRawDocument")
    def inline_raw_document(self) -> str:
        """
        Raw document content.
        """
        return pulumi.get(self, "inline_raw_document")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the document. Format: projects/{project_number}/locations/{location}/documents/{document_id}. The name is ignored when creating a document.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="plainText")
    def plain_text(self) -> str:
        """
        Other document format, such as PPTX, XLXS
        """
        return pulumi.get(self, "plain_text")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GoogleCloudContentwarehouseV1PropertyResponse']:
        """
        List of values that are user supplied metadata.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="rawDocumentFileType")
    def raw_document_file_type(self) -> str:
        """
        This is used when DocAI was not used to load the document and parsing/ extracting is needed for the inline_raw_document. For example, if inline_raw_document is the byte representation of a PDF file, then this should be set to: RAW_DOCUMENT_FILE_TYPE_PDF.
        """
        return pulumi.get(self, "raw_document_file_type")

    @property
    @pulumi.getter(name="rawDocumentPath")
    def raw_document_path(self) -> str:
        """
        Raw document file in Cloud Storage path.
        """
        return pulumi.get(self, "raw_document_path")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> str:
        """
        The reference ID set by customers. Must be unique per project and location.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="structuredContentUri")
    def structured_content_uri(self) -> str:
        """
        A path linked to structured content file.
        """
        return pulumi.get(self, "structured_content_uri")

    @property
    @pulumi.getter(name="textExtractionDisabled")
    def text_extraction_disabled(self) -> bool:
        """
        If true, text extraction will not be performed.
        """
        return pulumi.get(self, "text_extraction_disabled")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Title that describes the document. This is usually present in the top section of the document, and is a mandatory field for the question-answering feature.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the document is last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def updater(self) -> str:
        """
        The user who lastly updates the document.
        """
        return pulumi.get(self, "updater")


class AwaitableGetDocumentResult(GetDocumentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDocumentResult(
            async_enabled=self.async_enabled,
            cloud_ai_document=self.cloud_ai_document,
            create_time=self.create_time,
            creator=self.creator,
            display_name=self.display_name,
            display_uri=self.display_uri,
            document_schema_name=self.document_schema_name,
            inline_raw_document=self.inline_raw_document,
            name=self.name,
            plain_text=self.plain_text,
            properties=self.properties,
            raw_document_file_type=self.raw_document_file_type,
            raw_document_path=self.raw_document_path,
            reference_id=self.reference_id,
            structured_content_uri=self.structured_content_uri,
            text_extraction_disabled=self.text_extraction_disabled,
            title=self.title,
            update_time=self.update_time,
            updater=self.updater)


def get_document(document_id: Optional[str] = None,
                 location: Optional[str] = None,
                 project: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDocumentResult:
    """
    Gets a document. Returns NOT_FOUND if the document does not exist.
    """
    __args__ = dict()
    __args__['documentId'] = document_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:contentwarehouse/v1:getDocument', __args__, opts=opts, typ=GetDocumentResult).value

    return AwaitableGetDocumentResult(
        async_enabled=__ret__.async_enabled,
        cloud_ai_document=__ret__.cloud_ai_document,
        create_time=__ret__.create_time,
        creator=__ret__.creator,
        display_name=__ret__.display_name,
        display_uri=__ret__.display_uri,
        document_schema_name=__ret__.document_schema_name,
        inline_raw_document=__ret__.inline_raw_document,
        name=__ret__.name,
        plain_text=__ret__.plain_text,
        properties=__ret__.properties,
        raw_document_file_type=__ret__.raw_document_file_type,
        raw_document_path=__ret__.raw_document_path,
        reference_id=__ret__.reference_id,
        structured_content_uri=__ret__.structured_content_uri,
        text_extraction_disabled=__ret__.text_extraction_disabled,
        title=__ret__.title,
        update_time=__ret__.update_time,
        updater=__ret__.updater)


@_utilities.lift_output_func(get_document)
def get_document_output(document_id: Optional[pulumi.Input[str]] = None,
                        location: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDocumentResult]:
    """
    Gets a document. Returns NOT_FOUND if the document does not exist.
    """
    ...
