# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    def __init__(__self__, addons_config=None, authenticator_groups_config=None, autopilot=None, autoscaling=None, binary_authorization=None, cluster_ipv4_cidr=None, conditions=None, confidential_nodes=None, cost_management_config=None, create_time=None, current_master_version=None, current_node_count=None, current_node_version=None, database_encryption=None, default_max_pods_constraint=None, description=None, enable_kubernetes_alpha=None, enable_tpu=None, endpoint=None, expire_time=None, identity_service_config=None, initial_cluster_version=None, initial_node_count=None, instance_group_urls=None, ip_allocation_policy=None, label_fingerprint=None, legacy_abac=None, location=None, locations=None, logging_config=None, logging_service=None, maintenance_policy=None, master_auth=None, master_authorized_networks_config=None, mesh_certificates=None, monitoring_config=None, monitoring_service=None, name=None, network=None, network_config=None, network_policy=None, node_config=None, node_ipv4_cidr_size=None, node_pool_auto_config=None, node_pool_defaults=None, node_pools=None, notification_config=None, private_cluster_config=None, release_channel=None, resource_labels=None, resource_usage_export_config=None, self_link=None, services_ipv4_cidr=None, shielded_nodes=None, status=None, status_message=None, subnetwork=None, tpu_ipv4_cidr_block=None, vertical_pod_autoscaling=None, workload_identity_config=None, zone=None):
        if addons_config and not isinstance(addons_config, dict):
            raise TypeError("Expected argument 'addons_config' to be a dict")
        pulumi.set(__self__, "addons_config", addons_config)
        if authenticator_groups_config and not isinstance(authenticator_groups_config, dict):
            raise TypeError("Expected argument 'authenticator_groups_config' to be a dict")
        pulumi.set(__self__, "authenticator_groups_config", authenticator_groups_config)
        if autopilot and not isinstance(autopilot, dict):
            raise TypeError("Expected argument 'autopilot' to be a dict")
        pulumi.set(__self__, "autopilot", autopilot)
        if autoscaling and not isinstance(autoscaling, dict):
            raise TypeError("Expected argument 'autoscaling' to be a dict")
        pulumi.set(__self__, "autoscaling", autoscaling)
        if binary_authorization and not isinstance(binary_authorization, dict):
            raise TypeError("Expected argument 'binary_authorization' to be a dict")
        pulumi.set(__self__, "binary_authorization", binary_authorization)
        if cluster_ipv4_cidr and not isinstance(cluster_ipv4_cidr, str):
            raise TypeError("Expected argument 'cluster_ipv4_cidr' to be a str")
        pulumi.set(__self__, "cluster_ipv4_cidr", cluster_ipv4_cidr)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if confidential_nodes and not isinstance(confidential_nodes, dict):
            raise TypeError("Expected argument 'confidential_nodes' to be a dict")
        pulumi.set(__self__, "confidential_nodes", confidential_nodes)
        if cost_management_config and not isinstance(cost_management_config, dict):
            raise TypeError("Expected argument 'cost_management_config' to be a dict")
        pulumi.set(__self__, "cost_management_config", cost_management_config)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if current_master_version and not isinstance(current_master_version, str):
            raise TypeError("Expected argument 'current_master_version' to be a str")
        pulumi.set(__self__, "current_master_version", current_master_version)
        if current_node_count and not isinstance(current_node_count, int):
            raise TypeError("Expected argument 'current_node_count' to be a int")
        if current_node_count is not None:
            warnings.warn("""[Output only] The number of nodes currently in the cluster. Deprecated. Call Kubernetes API directly to retrieve node information.""", DeprecationWarning)
            pulumi.log.warn("""current_node_count is deprecated: [Output only] The number of nodes currently in the cluster. Deprecated. Call Kubernetes API directly to retrieve node information.""")

        pulumi.set(__self__, "current_node_count", current_node_count)
        if current_node_version and not isinstance(current_node_version, str):
            raise TypeError("Expected argument 'current_node_version' to be a str")
        pulumi.set(__self__, "current_node_version", current_node_version)
        if database_encryption and not isinstance(database_encryption, dict):
            raise TypeError("Expected argument 'database_encryption' to be a dict")
        pulumi.set(__self__, "database_encryption", database_encryption)
        if default_max_pods_constraint and not isinstance(default_max_pods_constraint, dict):
            raise TypeError("Expected argument 'default_max_pods_constraint' to be a dict")
        pulumi.set(__self__, "default_max_pods_constraint", default_max_pods_constraint)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enable_kubernetes_alpha and not isinstance(enable_kubernetes_alpha, bool):
            raise TypeError("Expected argument 'enable_kubernetes_alpha' to be a bool")
        pulumi.set(__self__, "enable_kubernetes_alpha", enable_kubernetes_alpha)
        if enable_tpu and not isinstance(enable_tpu, bool):
            raise TypeError("Expected argument 'enable_tpu' to be a bool")
        pulumi.set(__self__, "enable_tpu", enable_tpu)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if identity_service_config and not isinstance(identity_service_config, dict):
            raise TypeError("Expected argument 'identity_service_config' to be a dict")
        pulumi.set(__self__, "identity_service_config", identity_service_config)
        if initial_cluster_version and not isinstance(initial_cluster_version, str):
            raise TypeError("Expected argument 'initial_cluster_version' to be a str")
        pulumi.set(__self__, "initial_cluster_version", initial_cluster_version)
        if initial_node_count and not isinstance(initial_node_count, int):
            raise TypeError("Expected argument 'initial_node_count' to be a int")
        if initial_node_count is not None:
            warnings.warn("""The number of nodes to create in this cluster. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota. For requests, this field should only be used in lieu of a \"node_pool\" object, since this configuration (along with the \"node_config\") will be used to create a \"NodePool\" object with an auto-generated name. Do not use this and a node_pool at the same time. This field is deprecated, use node_pool.initial_node_count instead.""", DeprecationWarning)
            pulumi.log.warn("""initial_node_count is deprecated: The number of nodes to create in this cluster. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota. For requests, this field should only be used in lieu of a \"node_pool\" object, since this configuration (along with the \"node_config\") will be used to create a \"NodePool\" object with an auto-generated name. Do not use this and a node_pool at the same time. This field is deprecated, use node_pool.initial_node_count instead.""")

        pulumi.set(__self__, "initial_node_count", initial_node_count)
        if instance_group_urls and not isinstance(instance_group_urls, list):
            raise TypeError("Expected argument 'instance_group_urls' to be a list")
        if instance_group_urls is not None:
            warnings.warn("""Deprecated. Use node_pools.instance_group_urls.""", DeprecationWarning)
            pulumi.log.warn("""instance_group_urls is deprecated: Deprecated. Use node_pools.instance_group_urls.""")

        pulumi.set(__self__, "instance_group_urls", instance_group_urls)
        if ip_allocation_policy and not isinstance(ip_allocation_policy, dict):
            raise TypeError("Expected argument 'ip_allocation_policy' to be a dict")
        pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        if label_fingerprint and not isinstance(label_fingerprint, str):
            raise TypeError("Expected argument 'label_fingerprint' to be a str")
        pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if legacy_abac and not isinstance(legacy_abac, dict):
            raise TypeError("Expected argument 'legacy_abac' to be a dict")
        pulumi.set(__self__, "legacy_abac", legacy_abac)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if logging_config and not isinstance(logging_config, dict):
            raise TypeError("Expected argument 'logging_config' to be a dict")
        pulumi.set(__self__, "logging_config", logging_config)
        if logging_service and not isinstance(logging_service, str):
            raise TypeError("Expected argument 'logging_service' to be a str")
        pulumi.set(__self__, "logging_service", logging_service)
        if maintenance_policy and not isinstance(maintenance_policy, dict):
            raise TypeError("Expected argument 'maintenance_policy' to be a dict")
        pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if master_auth and not isinstance(master_auth, dict):
            raise TypeError("Expected argument 'master_auth' to be a dict")
        pulumi.set(__self__, "master_auth", master_auth)
        if master_authorized_networks_config and not isinstance(master_authorized_networks_config, dict):
            raise TypeError("Expected argument 'master_authorized_networks_config' to be a dict")
        pulumi.set(__self__, "master_authorized_networks_config", master_authorized_networks_config)
        if mesh_certificates and not isinstance(mesh_certificates, dict):
            raise TypeError("Expected argument 'mesh_certificates' to be a dict")
        pulumi.set(__self__, "mesh_certificates", mesh_certificates)
        if monitoring_config and not isinstance(monitoring_config, dict):
            raise TypeError("Expected argument 'monitoring_config' to be a dict")
        pulumi.set(__self__, "monitoring_config", monitoring_config)
        if monitoring_service and not isinstance(monitoring_service, str):
            raise TypeError("Expected argument 'monitoring_service' to be a str")
        pulumi.set(__self__, "monitoring_service", monitoring_service)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if network_config and not isinstance(network_config, dict):
            raise TypeError("Expected argument 'network_config' to be a dict")
        pulumi.set(__self__, "network_config", network_config)
        if network_policy and not isinstance(network_policy, dict):
            raise TypeError("Expected argument 'network_policy' to be a dict")
        pulumi.set(__self__, "network_policy", network_policy)
        if node_config and not isinstance(node_config, dict):
            raise TypeError("Expected argument 'node_config' to be a dict")
        if node_config is not None:
            warnings.warn("""Parameters used in creating the cluster's nodes. For requests, this field should only be used in lieu of a \"node_pool\" object, since this configuration (along with the \"initial_node_count\") will be used to create a \"NodePool\" object with an auto-generated name. Do not use this and a node_pool at the same time. For responses, this field will be populated with the node configuration of the first node pool. (For configuration of each node pool, see `node_pool.config`) If unspecified, the defaults are used. This field is deprecated, use node_pool.config instead.""", DeprecationWarning)
            pulumi.log.warn("""node_config is deprecated: Parameters used in creating the cluster's nodes. For requests, this field should only be used in lieu of a \"node_pool\" object, since this configuration (along with the \"initial_node_count\") will be used to create a \"NodePool\" object with an auto-generated name. Do not use this and a node_pool at the same time. For responses, this field will be populated with the node configuration of the first node pool. (For configuration of each node pool, see `node_pool.config`) If unspecified, the defaults are used. This field is deprecated, use node_pool.config instead.""")

        pulumi.set(__self__, "node_config", node_config)
        if node_ipv4_cidr_size and not isinstance(node_ipv4_cidr_size, int):
            raise TypeError("Expected argument 'node_ipv4_cidr_size' to be a int")
        pulumi.set(__self__, "node_ipv4_cidr_size", node_ipv4_cidr_size)
        if node_pool_auto_config and not isinstance(node_pool_auto_config, dict):
            raise TypeError("Expected argument 'node_pool_auto_config' to be a dict")
        pulumi.set(__self__, "node_pool_auto_config", node_pool_auto_config)
        if node_pool_defaults and not isinstance(node_pool_defaults, dict):
            raise TypeError("Expected argument 'node_pool_defaults' to be a dict")
        pulumi.set(__self__, "node_pool_defaults", node_pool_defaults)
        if node_pools and not isinstance(node_pools, list):
            raise TypeError("Expected argument 'node_pools' to be a list")
        pulumi.set(__self__, "node_pools", node_pools)
        if notification_config and not isinstance(notification_config, dict):
            raise TypeError("Expected argument 'notification_config' to be a dict")
        pulumi.set(__self__, "notification_config", notification_config)
        if private_cluster_config and not isinstance(private_cluster_config, dict):
            raise TypeError("Expected argument 'private_cluster_config' to be a dict")
        pulumi.set(__self__, "private_cluster_config", private_cluster_config)
        if release_channel and not isinstance(release_channel, dict):
            raise TypeError("Expected argument 'release_channel' to be a dict")
        pulumi.set(__self__, "release_channel", release_channel)
        if resource_labels and not isinstance(resource_labels, dict):
            raise TypeError("Expected argument 'resource_labels' to be a dict")
        pulumi.set(__self__, "resource_labels", resource_labels)
        if resource_usage_export_config and not isinstance(resource_usage_export_config, dict):
            raise TypeError("Expected argument 'resource_usage_export_config' to be a dict")
        pulumi.set(__self__, "resource_usage_export_config", resource_usage_export_config)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if services_ipv4_cidr and not isinstance(services_ipv4_cidr, str):
            raise TypeError("Expected argument 'services_ipv4_cidr' to be a str")
        pulumi.set(__self__, "services_ipv4_cidr", services_ipv4_cidr)
        if shielded_nodes and not isinstance(shielded_nodes, dict):
            raise TypeError("Expected argument 'shielded_nodes' to be a dict")
        pulumi.set(__self__, "shielded_nodes", shielded_nodes)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_message and not isinstance(status_message, str):
            raise TypeError("Expected argument 'status_message' to be a str")
        if status_message is not None:
            warnings.warn("""[Output only] Deprecated. Use conditions instead. Additional information about the current status of this cluster, if available.""", DeprecationWarning)
            pulumi.log.warn("""status_message is deprecated: [Output only] Deprecated. Use conditions instead. Additional information about the current status of this cluster, if available.""")

        pulumi.set(__self__, "status_message", status_message)
        if subnetwork and not isinstance(subnetwork, str):
            raise TypeError("Expected argument 'subnetwork' to be a str")
        pulumi.set(__self__, "subnetwork", subnetwork)
        if tpu_ipv4_cidr_block and not isinstance(tpu_ipv4_cidr_block, str):
            raise TypeError("Expected argument 'tpu_ipv4_cidr_block' to be a str")
        pulumi.set(__self__, "tpu_ipv4_cidr_block", tpu_ipv4_cidr_block)
        if vertical_pod_autoscaling and not isinstance(vertical_pod_autoscaling, dict):
            raise TypeError("Expected argument 'vertical_pod_autoscaling' to be a dict")
        pulumi.set(__self__, "vertical_pod_autoscaling", vertical_pod_autoscaling)
        if workload_identity_config and not isinstance(workload_identity_config, dict):
            raise TypeError("Expected argument 'workload_identity_config' to be a dict")
        pulumi.set(__self__, "workload_identity_config", workload_identity_config)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        if zone is not None:
            warnings.warn("""[Output only] The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field is deprecated, use location instead.""", DeprecationWarning)
            pulumi.log.warn("""zone is deprecated: [Output only] The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field is deprecated, use location instead.""")

        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="addonsConfig")
    def addons_config(self) -> 'outputs.AddonsConfigResponse':
        """
        Configurations for the various addons available to run in the cluster.
        """
        return pulumi.get(self, "addons_config")

    @property
    @pulumi.getter(name="authenticatorGroupsConfig")
    def authenticator_groups_config(self) -> 'outputs.AuthenticatorGroupsConfigResponse':
        """
        Configuration controlling RBAC group membership information.
        """
        return pulumi.get(self, "authenticator_groups_config")

    @property
    @pulumi.getter
    def autopilot(self) -> 'outputs.AutopilotResponse':
        """
        Autopilot configuration for the cluster.
        """
        return pulumi.get(self, "autopilot")

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.ClusterAutoscalingResponse':
        """
        Cluster-level autoscaling configuration.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> 'outputs.BinaryAuthorizationResponse':
        """
        Configuration for Binary Authorization.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter(name="clusterIpv4Cidr")
    def cluster_ipv4_cidr(self) -> str:
        """
        The IP address range of the container pods in this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`). Leave blank to have one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
        """
        return pulumi.get(self, "cluster_ipv4_cidr")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.StatusConditionResponse']:
        """
        Which conditions caused the current cluster state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="confidentialNodes")
    def confidential_nodes(self) -> 'outputs.ConfidentialNodesResponse':
        """
        Configuration of Confidential Nodes. All the nodes in the cluster will be Confidential VM once enabled.
        """
        return pulumi.get(self, "confidential_nodes")

    @property
    @pulumi.getter(name="costManagementConfig")
    def cost_management_config(self) -> 'outputs.CostManagementConfigResponse':
        """
        Configuration for the fine-grained cost management feature.
        """
        return pulumi.get(self, "cost_management_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        [Output only] The time the cluster was created, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentMasterVersion")
    def current_master_version(self) -> str:
        """
        [Output only] The current software version of the master endpoint.
        """
        return pulumi.get(self, "current_master_version")

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> int:
        """
        [Output only] The number of nodes currently in the cluster. Deprecated. Call Kubernetes API directly to retrieve node information.
        """
        return pulumi.get(self, "current_node_count")

    @property
    @pulumi.getter(name="currentNodeVersion")
    def current_node_version(self) -> str:
        """
        [Output only] Deprecated, use [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools) instead. The current version of the node software components. If they are currently at multiple versions because they're in the process of being upgraded, this reflects the minimum version of all nodes.
        """
        return pulumi.get(self, "current_node_version")

    @property
    @pulumi.getter(name="databaseEncryption")
    def database_encryption(self) -> 'outputs.DatabaseEncryptionResponse':
        """
        Configuration of etcd encryption.
        """
        return pulumi.get(self, "database_encryption")

    @property
    @pulumi.getter(name="defaultMaxPodsConstraint")
    def default_max_pods_constraint(self) -> 'outputs.MaxPodsConstraintResponse':
        """
        The default constraint on the maximum number of pods that can be run simultaneously on a node in the node pool of this cluster. Only honored if cluster created with IP Alias support.
        """
        return pulumi.get(self, "default_max_pods_constraint")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of this cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableKubernetesAlpha")
    def enable_kubernetes_alpha(self) -> bool:
        """
        Kubernetes alpha features are enabled on this cluster. This includes alpha API groups (e.g. v1alpha1) and features that may not be production ready in the kubernetes version of the master and nodes. The cluster has no SLA for uptime and master/node upgrades are disabled. Alpha enabled clusters are automatically deleted thirty days after creation.
        """
        return pulumi.get(self, "enable_kubernetes_alpha")

    @property
    @pulumi.getter(name="enableTpu")
    def enable_tpu(self) -> bool:
        """
        Enable the ability to use Cloud TPUs in this cluster.
        """
        return pulumi.get(self, "enable_tpu")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        [Output only] The IP address of this cluster's master endpoint. The endpoint can be accessed from the internet at `https://username:password@endpoint/`. See the `masterAuth` property of this resource for username and password information.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        [Output only] The time the cluster will be automatically deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="identityServiceConfig")
    def identity_service_config(self) -> 'outputs.IdentityServiceConfigResponse':
        """
        Configuration for Identity Service component.
        """
        return pulumi.get(self, "identity_service_config")

    @property
    @pulumi.getter(name="initialClusterVersion")
    def initial_cluster_version(self) -> str:
        """
        The initial Kubernetes version for this cluster. Valid versions are those found in validMasterVersions returned by getServerConfig. The version can be upgraded over time; such upgrades are reflected in currentMasterVersion and currentNodeVersion. Users may specify either explicit versions offered by Kubernetes Engine or version aliases, which have the following behavior: - "latest": picks the highest valid Kubernetes version - "1.X": picks the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "","-": picks the default Kubernetes version
        """
        return pulumi.get(self, "initial_cluster_version")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> int:
        """
        The number of nodes to create in this cluster. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota. For requests, this field should only be used in lieu of a "node_pool" object, since this configuration (along with the "node_config") will be used to create a "NodePool" object with an auto-generated name. Do not use this and a node_pool at the same time. This field is deprecated, use node_pool.initial_node_count instead.
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> Sequence[str]:
        """
        Deprecated. Use node_pools.instance_group_urls.
        """
        return pulumi.get(self, "instance_group_urls")

    @property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> 'outputs.IPAllocationPolicyResponse':
        """
        Configuration for cluster IP allocation.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> str:
        """
        The fingerprint of the set of labels for this cluster.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter(name="legacyAbac")
    def legacy_abac(self) -> 'outputs.LegacyAbacResponse':
        """
        Configuration for the legacy ABAC authorization mode.
        """
        return pulumi.get(self, "legacy_abac")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        [Output only] The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available) or [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available) in which the cluster resides.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def locations(self) -> Sequence[str]:
        """
        The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the cluster's nodes should be located. This field provides a default value if [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations) are not specified during node pool creation. Warning: changing cluster locations will update the [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations) of all node pools and will result in nodes being added and/or removed.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Logging configuration for the cluster.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="loggingService")
    def logging_service(self) -> str:
        """
        The logging service the cluster should use to write logs. Currently available options: * `logging.googleapis.com/kubernetes` - The Cloud Logging service with a Kubernetes-native resource model * `logging.googleapis.com` - The legacy Cloud Logging service (no longer available as of GKE 1.15). * `none` - no logs will be exported from the cluster. If left as an empty string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
        """
        return pulumi.get(self, "logging_service")

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> 'outputs.MaintenancePolicyResponse':
        """
        Configure the maintenance policy for this cluster.
        """
        return pulumi.get(self, "maintenance_policy")

    @property
    @pulumi.getter(name="masterAuth")
    def master_auth(self) -> 'outputs.MasterAuthResponse':
        """
        The authentication information for accessing the master endpoint. If unspecified, the defaults are used: For clusters before v1.12, if master_auth is unspecified, `username` will be set to "admin", a random password will be generated, and a client certificate will be issued.
        """
        return pulumi.get(self, "master_auth")

    @property
    @pulumi.getter(name="masterAuthorizedNetworksConfig")
    def master_authorized_networks_config(self) -> 'outputs.MasterAuthorizedNetworksConfigResponse':
        """
        The configuration options for master authorized networks feature.
        """
        return pulumi.get(self, "master_authorized_networks_config")

    @property
    @pulumi.getter(name="meshCertificates")
    def mesh_certificates(self) -> 'outputs.MeshCertificatesResponse':
        """
        Configuration for issuance of mTLS keys and certificates to Kubernetes pods.
        """
        return pulumi.get(self, "mesh_certificates")

    @property
    @pulumi.getter(name="monitoringConfig")
    def monitoring_config(self) -> 'outputs.MonitoringConfigResponse':
        """
        Monitoring configuration for the cluster.
        """
        return pulumi.get(self, "monitoring_config")

    @property
    @pulumi.getter(name="monitoringService")
    def monitoring_service(self) -> str:
        """
        The monitoring service the cluster should use to write metrics. Currently available options: * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service with a Kubernetes-native resource model * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no longer available as of GKE 1.15). * `none` - No metrics will be exported from the cluster. If left as an empty string,`monitoring.googleapis.com/kubernetes` will be used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
        """
        return pulumi.get(self, "monitoring_service")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this cluster. The name must be unique within this project and location (e.g. zone or region), and can be up to 40 characters with the following restrictions: * Lowercase letters, numbers, and hyphens only. * Must start with a letter. * Must end with a number or a letter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The name of the Google Compute Engine [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. If left unspecified, the `default` network will be used.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> 'outputs.NetworkConfigResponse':
        """
        Configuration for cluster networking.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> 'outputs.NetworkPolicyResponse':
        """
        Configuration options for the NetworkPolicy feature.
        """
        return pulumi.get(self, "network_policy")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> 'outputs.NodeConfigResponse':
        """
        Parameters used in creating the cluster's nodes. For requests, this field should only be used in lieu of a "node_pool" object, since this configuration (along with the "initial_node_count") will be used to create a "NodePool" object with an auto-generated name. Do not use this and a node_pool at the same time. For responses, this field will be populated with the node configuration of the first node pool. (For configuration of each node pool, see `node_pool.config`) If unspecified, the defaults are used. This field is deprecated, use node_pool.config instead.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="nodeIpv4CidrSize")
    def node_ipv4_cidr_size(self) -> int:
        """
        [Output only] The size of the address space on each node for hosting containers. This is provisioned from within the `container_ipv4_cidr` range. This field will only be set when cluster is in route-based network mode.
        """
        return pulumi.get(self, "node_ipv4_cidr_size")

    @property
    @pulumi.getter(name="nodePoolAutoConfig")
    def node_pool_auto_config(self) -> 'outputs.NodePoolAutoConfigResponse':
        """
        Node pool configs that apply to all auto-provisioned node pools in autopilot clusters and node auto-provisioning enabled clusters.
        """
        return pulumi.get(self, "node_pool_auto_config")

    @property
    @pulumi.getter(name="nodePoolDefaults")
    def node_pool_defaults(self) -> 'outputs.NodePoolDefaultsResponse':
        """
        Default NodePool settings for the entire cluster. These settings are overridden if specified on the specific NodePool object.
        """
        return pulumi.get(self, "node_pool_defaults")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Sequence['outputs.NodePoolResponse']:
        """
        The node pools associated with this cluster. This field should not be set if "node_config" or "initial_node_count" are specified.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> 'outputs.NotificationConfigResponse':
        """
        Notification configuration of the cluster.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> 'outputs.PrivateClusterConfigResponse':
        """
        Configuration for private cluster.
        """
        return pulumi.get(self, "private_cluster_config")

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> 'outputs.ReleaseChannelResponse':
        """
        Release channel configuration.
        """
        return pulumi.get(self, "release_channel")

    @property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> Mapping[str, str]:
        """
        The resource labels for the cluster to use to annotate any related Google Compute Engine resources.
        """
        return pulumi.get(self, "resource_labels")

    @property
    @pulumi.getter(name="resourceUsageExportConfig")
    def resource_usage_export_config(self) -> 'outputs.ResourceUsageExportConfigResponse':
        """
        Configuration for exporting resource usages. Resource usage export is disabled when this config is unspecified.
        """
        return pulumi.get(self, "resource_usage_export_config")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        [Output only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="servicesIpv4Cidr")
    def services_ipv4_cidr(self) -> str:
        """
        [Output only] The IP address range of the Kubernetes services in this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `1.2.3.4/29`). Service addresses are typically put in the last `/16` from the container CIDR.
        """
        return pulumi.get(self, "services_ipv4_cidr")

    @property
    @pulumi.getter(name="shieldedNodes")
    def shielded_nodes(self) -> 'outputs.ShieldedNodesResponse':
        """
        Shielded Nodes configuration.
        """
        return pulumi.get(self, "shielded_nodes")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        [Output only] The current status of this cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        [Output only] Deprecated. Use conditions instead. Additional information about the current status of this cluster, if available.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which the cluster is connected.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="tpuIpv4CidrBlock")
    def tpu_ipv4_cidr_block(self) -> str:
        """
        [Output only] The IP address range of the Cloud TPUs in this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `1.2.3.4/29`).
        """
        return pulumi.get(self, "tpu_ipv4_cidr_block")

    @property
    @pulumi.getter(name="verticalPodAutoscaling")
    def vertical_pod_autoscaling(self) -> 'outputs.VerticalPodAutoscalingResponse':
        """
        Cluster-level Vertical Pod Autoscaling configuration.
        """
        return pulumi.get(self, "vertical_pod_autoscaling")

    @property
    @pulumi.getter(name="workloadIdentityConfig")
    def workload_identity_config(self) -> 'outputs.WorkloadIdentityConfigResponse':
        """
        Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
        """
        return pulumi.get(self, "workload_identity_config")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        [Output only] The name of the Google Compute Engine [zone](https://cloud.google.com/compute/docs/zones#available) in which the cluster resides. This field is deprecated, use location instead.
        """
        return pulumi.get(self, "zone")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            addons_config=self.addons_config,
            authenticator_groups_config=self.authenticator_groups_config,
            autopilot=self.autopilot,
            autoscaling=self.autoscaling,
            binary_authorization=self.binary_authorization,
            cluster_ipv4_cidr=self.cluster_ipv4_cidr,
            conditions=self.conditions,
            confidential_nodes=self.confidential_nodes,
            cost_management_config=self.cost_management_config,
            create_time=self.create_time,
            current_master_version=self.current_master_version,
            current_node_count=self.current_node_count,
            current_node_version=self.current_node_version,
            database_encryption=self.database_encryption,
            default_max_pods_constraint=self.default_max_pods_constraint,
            description=self.description,
            enable_kubernetes_alpha=self.enable_kubernetes_alpha,
            enable_tpu=self.enable_tpu,
            endpoint=self.endpoint,
            expire_time=self.expire_time,
            identity_service_config=self.identity_service_config,
            initial_cluster_version=self.initial_cluster_version,
            initial_node_count=self.initial_node_count,
            instance_group_urls=self.instance_group_urls,
            ip_allocation_policy=self.ip_allocation_policy,
            label_fingerprint=self.label_fingerprint,
            legacy_abac=self.legacy_abac,
            location=self.location,
            locations=self.locations,
            logging_config=self.logging_config,
            logging_service=self.logging_service,
            maintenance_policy=self.maintenance_policy,
            master_auth=self.master_auth,
            master_authorized_networks_config=self.master_authorized_networks_config,
            mesh_certificates=self.mesh_certificates,
            monitoring_config=self.monitoring_config,
            monitoring_service=self.monitoring_service,
            name=self.name,
            network=self.network,
            network_config=self.network_config,
            network_policy=self.network_policy,
            node_config=self.node_config,
            node_ipv4_cidr_size=self.node_ipv4_cidr_size,
            node_pool_auto_config=self.node_pool_auto_config,
            node_pool_defaults=self.node_pool_defaults,
            node_pools=self.node_pools,
            notification_config=self.notification_config,
            private_cluster_config=self.private_cluster_config,
            release_channel=self.release_channel,
            resource_labels=self.resource_labels,
            resource_usage_export_config=self.resource_usage_export_config,
            self_link=self.self_link,
            services_ipv4_cidr=self.services_ipv4_cidr,
            shielded_nodes=self.shielded_nodes,
            status=self.status,
            status_message=self.status_message,
            subnetwork=self.subnetwork,
            tpu_ipv4_cidr_block=self.tpu_ipv4_cidr_block,
            vertical_pod_autoscaling=self.vertical_pod_autoscaling,
            workload_identity_config=self.workload_identity_config,
            zone=self.zone)


def get_cluster(cluster_id: Optional[str] = None,
                location: Optional[str] = None,
                project: Optional[str] = None,
                project_id: Optional[str] = None,
                zone: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Gets the details of a specific cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:container/v1:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        addons_config=__ret__.addons_config,
        authenticator_groups_config=__ret__.authenticator_groups_config,
        autopilot=__ret__.autopilot,
        autoscaling=__ret__.autoscaling,
        binary_authorization=__ret__.binary_authorization,
        cluster_ipv4_cidr=__ret__.cluster_ipv4_cidr,
        conditions=__ret__.conditions,
        confidential_nodes=__ret__.confidential_nodes,
        cost_management_config=__ret__.cost_management_config,
        create_time=__ret__.create_time,
        current_master_version=__ret__.current_master_version,
        current_node_count=__ret__.current_node_count,
        current_node_version=__ret__.current_node_version,
        database_encryption=__ret__.database_encryption,
        default_max_pods_constraint=__ret__.default_max_pods_constraint,
        description=__ret__.description,
        enable_kubernetes_alpha=__ret__.enable_kubernetes_alpha,
        enable_tpu=__ret__.enable_tpu,
        endpoint=__ret__.endpoint,
        expire_time=__ret__.expire_time,
        identity_service_config=__ret__.identity_service_config,
        initial_cluster_version=__ret__.initial_cluster_version,
        initial_node_count=__ret__.initial_node_count,
        instance_group_urls=__ret__.instance_group_urls,
        ip_allocation_policy=__ret__.ip_allocation_policy,
        label_fingerprint=__ret__.label_fingerprint,
        legacy_abac=__ret__.legacy_abac,
        location=__ret__.location,
        locations=__ret__.locations,
        logging_config=__ret__.logging_config,
        logging_service=__ret__.logging_service,
        maintenance_policy=__ret__.maintenance_policy,
        master_auth=__ret__.master_auth,
        master_authorized_networks_config=__ret__.master_authorized_networks_config,
        mesh_certificates=__ret__.mesh_certificates,
        monitoring_config=__ret__.monitoring_config,
        monitoring_service=__ret__.monitoring_service,
        name=__ret__.name,
        network=__ret__.network,
        network_config=__ret__.network_config,
        network_policy=__ret__.network_policy,
        node_config=__ret__.node_config,
        node_ipv4_cidr_size=__ret__.node_ipv4_cidr_size,
        node_pool_auto_config=__ret__.node_pool_auto_config,
        node_pool_defaults=__ret__.node_pool_defaults,
        node_pools=__ret__.node_pools,
        notification_config=__ret__.notification_config,
        private_cluster_config=__ret__.private_cluster_config,
        release_channel=__ret__.release_channel,
        resource_labels=__ret__.resource_labels,
        resource_usage_export_config=__ret__.resource_usage_export_config,
        self_link=__ret__.self_link,
        services_ipv4_cidr=__ret__.services_ipv4_cidr,
        shielded_nodes=__ret__.shielded_nodes,
        status=__ret__.status,
        status_message=__ret__.status_message,
        subnetwork=__ret__.subnetwork,
        tpu_ipv4_cidr_block=__ret__.tpu_ipv4_cidr_block,
        vertical_pod_autoscaling=__ret__.vertical_pod_autoscaling,
        workload_identity_config=__ret__.workload_identity_config,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_cluster)
def get_cluster_output(cluster_id: Optional[pulumi.Input[str]] = None,
                       location: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       project_id: Optional[pulumi.Input[Optional[str]]] = None,
                       zone: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterResult]:
    """
    Gets the details of a specific cluster.
    """
    ...
