# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['IssueModelArgs', 'IssueModel']

@pulumi.input_type
class IssueModelArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IssueModel resource.
        :param pulumi.Input[str] display_name: The representative name for the issue model.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs'] input_data_config: Configs for the input data that used to create the issue model.
        :param pulumi.Input[str] name: Immutable. The resource name of the issue model. Format: projects/{project}/locations/{location}/issueModels/{issue_model}
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if input_data_config is not None:
            pulumi.set(__self__, "input_data_config", input_data_config)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The representative name for the issue model.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs']]:
        """
        Configs for the input data that used to create the issue model.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs']]):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The resource name of the issue model. Format: projects/{project}/locations/{location}/issueModels/{issue_model}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class IssueModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an issue model.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: The representative name for the issue model.
        :param pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs']] input_data_config: Configs for the input data that used to create the issue model.
        :param pulumi.Input[str] name: Immutable. The resource name of the issue model. Format: projects/{project}/locations/{location}/issueModels/{issue_model}
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IssueModelArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an issue model.

        :param str resource_name: The name of the resource.
        :param IssueModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IssueModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IssueModelArgs.__new__(IssueModelArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["input_data_config"] = input_data_config
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["training_stats"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IssueModel, __self__).__init__(
            'google-native:contactcenterinsights/v1:IssueModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IssueModel':
        """
        Get an existing IssueModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IssueModelArgs.__new__(IssueModelArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["input_data_config"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["training_stats"] = None
        __props__.__dict__["update_time"] = None
        return IssueModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which this issue model was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The representative name for the issue model.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Output['outputs.GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigResponse']:
        """
        Configs for the input data that used to create the issue model.
        """
        return pulumi.get(self, "input_data_config")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The resource name of the issue model. Format: projects/{project}/locations/{location}/issueModels/{issue_model}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="trainingStats")
    def training_stats(self) -> pulumi.Output['outputs.GoogleCloudContactcenterinsightsV1IssueModelLabelStatsResponse']:
        """
        Immutable. The issue model's label statistics on its training data.
        """
        return pulumi.get(self, "training_stats")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The most recent time at which the issue model was updated.
        """
        return pulumi.get(self, "update_time")

