# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTraceSinkResult',
    'AwaitableGetTraceSinkResult',
    'get_trace_sink',
    'get_trace_sink_output',
]

@pulumi.output_type
class GetTraceSinkResult:
    def __init__(__self__, name=None, output_config=None, writer_identity=None):
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_config and not isinstance(output_config, dict):
            raise TypeError("Expected argument 'output_config' to be a dict")
        pulumi.set(__self__, "output_config", output_config)
        if writer_identity and not isinstance(writer_identity, str):
            raise TypeError("Expected argument 'writer_identity' to be a str")
        pulumi.set(__self__, "writer_identity", writer_identity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The canonical sink resource name, unique within the project. Must be of the form: projects/[PROJECT_NUMBER]/traceSinks/[SINK_ID]. E.g.: `"projects/12345/traceSinks/my-project-trace-sink"`. Sink identifiers are limited to 256 characters and can include only the following characters: upper and lower-case alphanumeric characters, underscores, hyphens, and periods.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputConfig")
    def output_config(self) -> 'outputs.OutputConfigResponse':
        """
        The export destination.
        """
        return pulumi.get(self, "output_config")

    @property
    @pulumi.getter(name="writerIdentity")
    def writer_identity(self) -> str:
        """
        A service account name for exporting the data. This field is set by sinks.create and sinks.update. The service account will need to be granted write access to the destination specified in the output configuration, see [Granting access for a resource](/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource). To create tables and to write data, this account needs the `dataEditor` role. Read more about roles in the [BigQuery documentation](https://cloud.google.com/bigquery/docs/access-control). E.g.: "service-00000001@00000002.iam.gserviceaccount.com"
        """
        return pulumi.get(self, "writer_identity")


class AwaitableGetTraceSinkResult(GetTraceSinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTraceSinkResult(
            name=self.name,
            output_config=self.output_config,
            writer_identity=self.writer_identity)


def get_trace_sink(project: Optional[str] = None,
                   trace_sink_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTraceSinkResult:
    """
    Get a trace sink by name under the parent resource (GCP project).
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['traceSinkId'] = trace_sink_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:cloudtrace/v2beta1:getTraceSink', __args__, opts=opts, typ=GetTraceSinkResult).value

    return AwaitableGetTraceSinkResult(
        name=__ret__.name,
        output_config=__ret__.output_config,
        writer_identity=__ret__.writer_identity)


@_utilities.lift_output_func(get_trace_sink)
def get_trace_sink_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                          trace_sink_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTraceSinkResult]:
    """
    Get a trace sink by name under the parent resource (GCP project).
    """
    ...
