# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetReleaseResult',
    'AwaitableGetReleaseResult',
    'get_release',
    'get_release_output',
]

@pulumi.output_type
class GetReleaseResult:
    def __init__(__self__, abandoned=None, annotations=None, build_artifacts=None, create_time=None, delivery_pipeline_snapshot=None, description=None, etag=None, labels=None, name=None, render_end_time=None, render_start_time=None, render_state=None, skaffold_config_path=None, skaffold_config_uri=None, skaffold_version=None, target_artifacts=None, target_renders=None, target_snapshots=None, uid=None):
        if abandoned and not isinstance(abandoned, bool):
            raise TypeError("Expected argument 'abandoned' to be a bool")
        pulumi.set(__self__, "abandoned", abandoned)
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if build_artifacts and not isinstance(build_artifacts, list):
            raise TypeError("Expected argument 'build_artifacts' to be a list")
        pulumi.set(__self__, "build_artifacts", build_artifacts)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if delivery_pipeline_snapshot and not isinstance(delivery_pipeline_snapshot, dict):
            raise TypeError("Expected argument 'delivery_pipeline_snapshot' to be a dict")
        pulumi.set(__self__, "delivery_pipeline_snapshot", delivery_pipeline_snapshot)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if render_end_time and not isinstance(render_end_time, str):
            raise TypeError("Expected argument 'render_end_time' to be a str")
        pulumi.set(__self__, "render_end_time", render_end_time)
        if render_start_time and not isinstance(render_start_time, str):
            raise TypeError("Expected argument 'render_start_time' to be a str")
        pulumi.set(__self__, "render_start_time", render_start_time)
        if render_state and not isinstance(render_state, str):
            raise TypeError("Expected argument 'render_state' to be a str")
        pulumi.set(__self__, "render_state", render_state)
        if skaffold_config_path and not isinstance(skaffold_config_path, str):
            raise TypeError("Expected argument 'skaffold_config_path' to be a str")
        pulumi.set(__self__, "skaffold_config_path", skaffold_config_path)
        if skaffold_config_uri and not isinstance(skaffold_config_uri, str):
            raise TypeError("Expected argument 'skaffold_config_uri' to be a str")
        pulumi.set(__self__, "skaffold_config_uri", skaffold_config_uri)
        if skaffold_version and not isinstance(skaffold_version, str):
            raise TypeError("Expected argument 'skaffold_version' to be a str")
        pulumi.set(__self__, "skaffold_version", skaffold_version)
        if target_artifacts and not isinstance(target_artifacts, dict):
            raise TypeError("Expected argument 'target_artifacts' to be a dict")
        pulumi.set(__self__, "target_artifacts", target_artifacts)
        if target_renders and not isinstance(target_renders, dict):
            raise TypeError("Expected argument 'target_renders' to be a dict")
        pulumi.set(__self__, "target_renders", target_renders)
        if target_snapshots and not isinstance(target_snapshots, list):
            raise TypeError("Expected argument 'target_snapshots' to be a list")
        pulumi.set(__self__, "target_snapshots", target_snapshots)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def abandoned(self) -> bool:
        """
        Indicates whether this is an abandoned release.
        """
        return pulumi.get(self, "abandoned")

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="buildArtifacts")
    def build_artifacts(self) -> Sequence['outputs.BuildArtifactResponse']:
        """
        List of artifacts to pass through to Skaffold command.
        """
        return pulumi.get(self, "build_artifacts")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the `Release` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deliveryPipelineSnapshot")
    def delivery_pipeline_snapshot(self) -> 'outputs.DeliveryPipelineResponse':
        """
        Snapshot of the parent pipeline taken at release creation time.
        """
        return pulumi.get(self, "delivery_pipeline_snapshot")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the `Release`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. Name of the `Release`. Format is projects/{project}/ locations/{location}/deliveryPipelines/{deliveryPipeline}/ releases/a-z{0,62}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="renderEndTime")
    def render_end_time(self) -> str:
        """
        Time at which the render completed.
        """
        return pulumi.get(self, "render_end_time")

    @property
    @pulumi.getter(name="renderStartTime")
    def render_start_time(self) -> str:
        """
        Time at which the render began.
        """
        return pulumi.get(self, "render_start_time")

    @property
    @pulumi.getter(name="renderState")
    def render_state(self) -> str:
        """
        Current state of the render operation.
        """
        return pulumi.get(self, "render_state")

    @property
    @pulumi.getter(name="skaffoldConfigPath")
    def skaffold_config_path(self) -> str:
        """
        Filepath of the Skaffold config inside of the config URI.
        """
        return pulumi.get(self, "skaffold_config_path")

    @property
    @pulumi.getter(name="skaffoldConfigUri")
    def skaffold_config_uri(self) -> str:
        """
        Cloud Storage URI of tar.gz archive containing Skaffold configuration.
        """
        return pulumi.get(self, "skaffold_config_uri")

    @property
    @pulumi.getter(name="skaffoldVersion")
    def skaffold_version(self) -> str:
        """
        The Skaffold version to use when operating on this release, such as "1.20.0". Not all versions are valid; Google Cloud Deploy supports a specific set of versions. If unset, the most recent supported Skaffold version will be used.
        """
        return pulumi.get(self, "skaffold_version")

    @property
    @pulumi.getter(name="targetArtifacts")
    def target_artifacts(self) -> Mapping[str, str]:
        """
        Map from target ID to the target artifacts created during the render operation.
        """
        return pulumi.get(self, "target_artifacts")

    @property
    @pulumi.getter(name="targetRenders")
    def target_renders(self) -> Mapping[str, str]:
        """
        Map from target ID to details of the render operation for that target.
        """
        return pulumi.get(self, "target_renders")

    @property
    @pulumi.getter(name="targetSnapshots")
    def target_snapshots(self) -> Sequence['outputs.TargetResponse']:
        """
        Snapshot of the targets taken at release creation time.
        """
        return pulumi.get(self, "target_snapshots")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Unique identifier of the `Release`.
        """
        return pulumi.get(self, "uid")


class AwaitableGetReleaseResult(GetReleaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReleaseResult(
            abandoned=self.abandoned,
            annotations=self.annotations,
            build_artifacts=self.build_artifacts,
            create_time=self.create_time,
            delivery_pipeline_snapshot=self.delivery_pipeline_snapshot,
            description=self.description,
            etag=self.etag,
            labels=self.labels,
            name=self.name,
            render_end_time=self.render_end_time,
            render_start_time=self.render_start_time,
            render_state=self.render_state,
            skaffold_config_path=self.skaffold_config_path,
            skaffold_config_uri=self.skaffold_config_uri,
            skaffold_version=self.skaffold_version,
            target_artifacts=self.target_artifacts,
            target_renders=self.target_renders,
            target_snapshots=self.target_snapshots,
            uid=self.uid)


def get_release(delivery_pipeline_id: Optional[str] = None,
                location: Optional[str] = None,
                project: Optional[str] = None,
                release_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReleaseResult:
    """
    Gets details of a single Release.
    """
    __args__ = dict()
    __args__['deliveryPipelineId'] = delivery_pipeline_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['releaseId'] = release_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:clouddeploy/v1:getRelease', __args__, opts=opts, typ=GetReleaseResult).value

    return AwaitableGetReleaseResult(
        abandoned=__ret__.abandoned,
        annotations=__ret__.annotations,
        build_artifacts=__ret__.build_artifacts,
        create_time=__ret__.create_time,
        delivery_pipeline_snapshot=__ret__.delivery_pipeline_snapshot,
        description=__ret__.description,
        etag=__ret__.etag,
        labels=__ret__.labels,
        name=__ret__.name,
        render_end_time=__ret__.render_end_time,
        render_start_time=__ret__.render_start_time,
        render_state=__ret__.render_state,
        skaffold_config_path=__ret__.skaffold_config_path,
        skaffold_config_uri=__ret__.skaffold_config_uri,
        skaffold_version=__ret__.skaffold_version,
        target_artifacts=__ret__.target_artifacts,
        target_renders=__ret__.target_renders,
        target_snapshots=__ret__.target_snapshots,
        uid=__ret__.uid)


@_utilities.lift_output_func(get_release)
def get_release_output(delivery_pipeline_id: Optional[pulumi.Input[str]] = None,
                       location: Optional[pulumi.Input[str]] = None,
                       project: Optional[pulumi.Input[Optional[str]]] = None,
                       release_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReleaseResult]:
    """
    Gets details of a single Release.
    """
    ...
