# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApprovalConfigResponse',
    'ApprovalResultResponse',
    'ArtifactObjectsResponse',
    'ArtifactsResponse',
    'BitbucketServerConfigResponse',
    'BitbucketServerRepositoryIdResponse',
    'BitbucketServerSecretsResponse',
    'BitbucketServerTriggerConfigResponse',
    'BuildApprovalResponse',
    'BuildOptionsResponse',
    'BuildResponse',
    'BuildStepResponse',
    'BuiltImageResponse',
    'FailureInfoResponse',
    'FileHashesResponse',
    'GitFileSourceResponse',
    'GitHubEnterpriseSecretsResponse',
    'GitHubEventsConfigResponse',
    'GitLabConfigResponse',
    'GitLabEnterpriseConfigResponse',
    'GitLabEventsConfigResponse',
    'GitLabRepositoryIdResponse',
    'GitLabSecretsResponse',
    'GitRepoSourceResponse',
    'HashResponse',
    'InlineSecretResponse',
    'MavenArtifactResponse',
    'NetworkConfigResponse',
    'PoolOptionResponse',
    'PrivatePoolV1ConfigResponse',
    'PubsubConfigResponse',
    'PullRequestFilterResponse',
    'PushFilterResponse',
    'PythonPackageResponse',
    'RepoSourceResponse',
    'ResultsResponse',
    'SecretManagerSecretResponse',
    'SecretResponse',
    'SecretsResponse',
    'ServiceDirectoryConfigResponse',
    'SourceProvenanceResponse',
    'SourceResponse',
    'StorageSourceManifestResponse',
    'StorageSourceResponse',
    'TimeSpanResponse',
    'UploadedMavenArtifactResponse',
    'UploadedPythonPackageResponse',
    'VolumeResponse',
    'WarningResponse',
    'WebhookConfigResponse',
    'WorkerConfigResponse',
]

@pulumi.output_type
class ApprovalConfigResponse(dict):
    """
    ApprovalConfig describes configuration for manual approval of a build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalRequired":
            suggest = "approval_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApprovalConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApprovalConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApprovalConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_required: bool):
        """
        ApprovalConfig describes configuration for manual approval of a build.
        :param bool approval_required: Whether or not approval is needed. If this is set on a build, it will become pending when created, and will need to be explicitly approved to start.
        """
        pulumi.set(__self__, "approval_required", approval_required)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> bool:
        """
        Whether or not approval is needed. If this is set on a build, it will become pending when created, and will need to be explicitly approved to start.
        """
        return pulumi.get(self, "approval_required")


@pulumi.output_type
class ApprovalResultResponse(dict):
    """
    ApprovalResult describes the decision and associated metadata of a manual approval of a build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalTime":
            suggest = "approval_time"
        elif key == "approverAccount":
            suggest = "approver_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApprovalResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApprovalResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApprovalResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_time: str,
                 approver_account: str,
                 comment: str,
                 decision: str,
                 url: str):
        """
        ApprovalResult describes the decision and associated metadata of a manual approval of a build.
        :param str approval_time: The time when the approval decision was made.
        :param str approver_account: Email of the user that called the ApproveBuild API to approve or reject a build at the time that the API was called.
        :param str comment: Optional. An optional comment for this manual approval result.
        :param str decision: The decision of this manual approval.
        :param str url: Optional. An optional URL tied to this manual approval result. This field is essentially the same as comment, except that it will be rendered by the UI differently. An example use case is a link to an external job that approved this Build.
        """
        pulumi.set(__self__, "approval_time", approval_time)
        pulumi.set(__self__, "approver_account", approver_account)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="approvalTime")
    def approval_time(self) -> str:
        """
        The time when the approval decision was made.
        """
        return pulumi.get(self, "approval_time")

    @property
    @pulumi.getter(name="approverAccount")
    def approver_account(self) -> str:
        """
        Email of the user that called the ApproveBuild API to approve or reject a build at the time that the API was called.
        """
        return pulumi.get(self, "approver_account")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        Optional. An optional comment for this manual approval result.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def decision(self) -> str:
        """
        The decision of this manual approval.
        """
        return pulumi.get(self, "decision")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Optional. An optional URL tied to this manual approval result. This field is essentially the same as comment, except that it will be rendered by the UI differently. An example use case is a link to an external job that approved this Build.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ArtifactObjectsResponse(dict):
    """
    Files in the workspace to upload to Cloud Storage upon successful completion of all build steps.
    """
    def __init__(__self__, *,
                 location: str,
                 paths: Sequence[str],
                 timing: 'outputs.TimeSpanResponse'):
        """
        Files in the workspace to upload to Cloud Storage upon successful completion of all build steps.
        :param str location: Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/". (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files in the workspace matching any path pattern will be uploaded to Cloud Storage with this location as a prefix.
        :param Sequence[str] paths: Path globs used to match files in the build's workspace.
        :param 'TimeSpanResponse' timing: Stores timing information for pushing all artifact objects.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "timing", timing)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/". (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files in the workspace matching any path pattern will be uploaded to Cloud Storage with this location as a prefix.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter
    def timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pushing all artifact objects.
        """
        return pulumi.get(self, "timing")


@pulumi.output_type
class ArtifactsResponse(dict):
    """
    Artifacts produced by a build that should be uploaded upon successful completion of all build steps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mavenArtifacts":
            suggest = "maven_artifacts"
        elif key == "pythonPackages":
            suggest = "python_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArtifactsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArtifactsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArtifactsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 images: Sequence[str],
                 maven_artifacts: Sequence['outputs.MavenArtifactResponse'],
                 objects: 'outputs.ArtifactObjectsResponse',
                 python_packages: Sequence['outputs.PythonPackageResponse']):
        """
        Artifacts produced by a build that should be uploaded upon successful completion of all build steps.
        :param Sequence[str] images: A list of images to be pushed upon the successful completion of all build steps. The images will be pushed using the builder service account's credentials. The digests of the pushed images will be stored in the Build resource's results field. If any of the images fail to be pushed, the build is marked FAILURE.
        :param Sequence['MavenArtifactResponse'] maven_artifacts: A list of Maven artifacts to be uploaded to Artifact Registry upon successful completion of all build steps. Artifacts in the workspace matching specified paths globs will be uploaded to the specified Artifact Registry repository using the builder service account's credentials. If any artifacts fail to be pushed, the build is marked FAILURE.
        :param 'ArtifactObjectsResponse' objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps. Files in the workspace matching specified paths globs will be uploaded to the specified Cloud Storage location using the builder service account's credentials. The location and generation of the uploaded objects will be stored in the Build resource's results field. If any objects fail to be pushed, the build is marked FAILURE.
        :param Sequence['PythonPackageResponse'] python_packages: A list of Python packages to be uploaded to Artifact Registry upon successful completion of all build steps. The build service account credentials will be used to perform the upload. If any objects fail to be pushed, the build is marked FAILURE.
        """
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "maven_artifacts", maven_artifacts)
        pulumi.set(__self__, "objects", objects)
        pulumi.set(__self__, "python_packages", python_packages)

    @property
    @pulumi.getter
    def images(self) -> Sequence[str]:
        """
        A list of images to be pushed upon the successful completion of all build steps. The images will be pushed using the builder service account's credentials. The digests of the pushed images will be stored in the Build resource's results field. If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="mavenArtifacts")
    def maven_artifacts(self) -> Sequence['outputs.MavenArtifactResponse']:
        """
        A list of Maven artifacts to be uploaded to Artifact Registry upon successful completion of all build steps. Artifacts in the workspace matching specified paths globs will be uploaded to the specified Artifact Registry repository using the builder service account's credentials. If any artifacts fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "maven_artifacts")

    @property
    @pulumi.getter
    def objects(self) -> 'outputs.ArtifactObjectsResponse':
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps. Files in the workspace matching specified paths globs will be uploaded to the specified Cloud Storage location using the builder service account's credentials. The location and generation of the uploaded objects will be stored in the Build resource's results field. If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Sequence['outputs.PythonPackageResponse']:
        """
        A list of Python packages to be uploaded to Artifact Registry upon successful completion of all build steps. The build service account credentials will be used to perform the upload. If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "python_packages")


@pulumi.output_type
class BitbucketServerConfigResponse(dict):
    """
    BitbucketServerConfig represents the configuration for a Bitbucket Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "connectedRepositories":
            suggest = "connected_repositories"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "hostUri":
            suggest = "host_uri"
        elif key == "peeredNetwork":
            suggest = "peered_network"
        elif key == "sslCa":
            suggest = "ssl_ca"
        elif key == "webhookKey":
            suggest = "webhook_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketServerConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketServerConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketServerConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: str,
                 connected_repositories: Sequence['outputs.BitbucketServerRepositoryIdResponse'],
                 create_time: str,
                 host_uri: str,
                 name: str,
                 peered_network: str,
                 secrets: 'outputs.BitbucketServerSecretsResponse',
                 ssl_ca: str,
                 username: str,
                 webhook_key: str):
        """
        BitbucketServerConfig represents the configuration for a Bitbucket Server.
        :param str api_key: Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        :param Sequence['BitbucketServerRepositoryIdResponse'] connected_repositories: Connected Bitbucket Server repositories for this config.
        :param str create_time: Time when the config was created.
        :param str host_uri: Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        :param str name: The resource name for the config.
        :param str peered_network: Optional. The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param 'BitbucketServerSecretsResponse' secrets: Secret Manager secrets needed by the config.
        :param str ssl_ca: Optional. SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of .pem, .cer, or .crt.
        :param str username: Username of the account Cloud Build will use on Bitbucket Server.
        :param str webhook_key: UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "connected_repositories", connected_repositories)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "peered_network", peered_network)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "ssl_ca", ssl_ca)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "webhook_key", webhook_key)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> Sequence['outputs.BitbucketServerRepositoryIdResponse']:
        """
        Connected Bitbucket Server repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when the config was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> str:
        """
        Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> str:
        """
        Optional. The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @property
    @pulumi.getter
    def secrets(self) -> 'outputs.BitbucketServerSecretsResponse':
        """
        Secret Manager secrets needed by the config.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> str:
        """
        Optional. SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of .pem, .cer, or .crt.
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username of the account Cloud Build will use on Bitbucket Server.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> str:
        """
        UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        return pulumi.get(self, "webhook_key")


@pulumi.output_type
class BitbucketServerRepositoryIdResponse(dict):
    """
    BitbucketServerRepositoryId identifies a specific repository hosted on a Bitbucket Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectKey":
            suggest = "project_key"
        elif key == "repoSlug":
            suggest = "repo_slug"
        elif key == "webhookId":
            suggest = "webhook_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketServerRepositoryIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketServerRepositoryIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketServerRepositoryIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_key: str,
                 repo_slug: str,
                 webhook_id: int):
        """
        BitbucketServerRepositoryId identifies a specific repository hosted on a Bitbucket Server.
        :param str project_key: Identifier for the project storing the repository.
        :param str repo_slug: Identifier for the repository.
        :param int webhook_id: The ID of the webhook that was created for receiving events from this repo. We only create and manage a single webhook for each repo.
        """
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "repo_slug", repo_slug)
        pulumi.set(__self__, "webhook_id", webhook_id)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> str:
        """
        Identifier for the project storing the repository.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> str:
        """
        Identifier for the repository.
        """
        return pulumi.get(self, "repo_slug")

    @property
    @pulumi.getter(name="webhookId")
    def webhook_id(self) -> int:
        """
        The ID of the webhook that was created for receiving events from this repo. We only create and manage a single webhook for each repo.
        """
        return pulumi.get(self, "webhook_id")


@pulumi.output_type
class BitbucketServerSecretsResponse(dict):
    """
    BitbucketServerSecrets represents the secrets in Secret Manager for a Bitbucket Server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminAccessTokenVersionName":
            suggest = "admin_access_token_version_name"
        elif key == "readAccessTokenVersionName":
            suggest = "read_access_token_version_name"
        elif key == "webhookSecretVersionName":
            suggest = "webhook_secret_version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketServerSecretsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketServerSecretsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketServerSecretsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_access_token_version_name: str,
                 read_access_token_version_name: str,
                 webhook_secret_version_name: str):
        """
        BitbucketServerSecrets represents the secrets in Secret Manager for a Bitbucket Server.
        :param str admin_access_token_version_name: The resource name for the admin access token's secret version.
        :param str read_access_token_version_name: The resource name for the read access token's secret version.
        :param str webhook_secret_version_name: Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        pulumi.set(__self__, "admin_access_token_version_name", admin_access_token_version_name)
        pulumi.set(__self__, "read_access_token_version_name", read_access_token_version_name)
        pulumi.set(__self__, "webhook_secret_version_name", webhook_secret_version_name)

    @property
    @pulumi.getter(name="adminAccessTokenVersionName")
    def admin_access_token_version_name(self) -> str:
        """
        The resource name for the admin access token's secret version.
        """
        return pulumi.get(self, "admin_access_token_version_name")

    @property
    @pulumi.getter(name="readAccessTokenVersionName")
    def read_access_token_version_name(self) -> str:
        """
        The resource name for the read access token's secret version.
        """
        return pulumi.get(self, "read_access_token_version_name")

    @property
    @pulumi.getter(name="webhookSecretVersionName")
    def webhook_secret_version_name(self) -> str:
        """
        Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "webhook_secret_version_name")


@pulumi.output_type
class BitbucketServerTriggerConfigResponse(dict):
    """
    BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitbucketServerConfig":
            suggest = "bitbucket_server_config"
        elif key == "bitbucketServerConfigResource":
            suggest = "bitbucket_server_config_resource"
        elif key == "projectKey":
            suggest = "project_key"
        elif key == "pullRequest":
            suggest = "pull_request"
        elif key == "repoSlug":
            suggest = "repo_slug"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BitbucketServerTriggerConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BitbucketServerTriggerConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BitbucketServerTriggerConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitbucket_server_config: 'outputs.BitbucketServerConfigResponse',
                 bitbucket_server_config_resource: str,
                 project_key: str,
                 pull_request: 'outputs.PullRequestFilterResponse',
                 push: 'outputs.PushFilterResponse',
                 repo_slug: str):
        """
        BitbucketServerTriggerConfig describes the configuration of a trigger that creates a build whenever a Bitbucket Server event is received.
        :param 'BitbucketServerConfigResponse' bitbucket_server_config: The BitbucketServerConfig specified in the bitbucket_server_config_resource field.
        :param str bitbucket_server_config_resource: The Bitbucket server config resource that this trigger config maps to.
        :param str project_key: Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        :param 'PullRequestFilterResponse' pull_request: Filter to match changes in pull requests.
        :param 'PushFilterResponse' push: Filter to match changes in refs like branches, tags.
        :param str repo_slug: Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL. For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        pulumi.set(__self__, "bitbucket_server_config_resource", bitbucket_server_config_resource)
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "pull_request", pull_request)
        pulumi.set(__self__, "push", push)
        pulumi.set(__self__, "repo_slug", repo_slug)

    @property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> 'outputs.BitbucketServerConfigResponse':
        """
        The BitbucketServerConfig specified in the bitbucket_server_config_resource field.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @property
    @pulumi.getter(name="bitbucketServerConfigResource")
    def bitbucket_server_config_resource(self) -> str:
        """
        The Bitbucket server config resource that this trigger config maps to.
        """
        return pulumi.get(self, "bitbucket_server_config_resource")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> str:
        """
        Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> 'outputs.PullRequestFilterResponse':
        """
        Filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_request")

    @property
    @pulumi.getter
    def push(self) -> 'outputs.PushFilterResponse':
        """
        Filter to match changes in refs like branches, tags.
        """
        return pulumi.get(self, "push")

    @property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> str:
        """
        Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL. For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        return pulumi.get(self, "repo_slug")


@pulumi.output_type
class BuildApprovalResponse(dict):
    """
    BuildApproval describes a build's approval configuration, state, and result.
    """
    def __init__(__self__, *,
                 config: 'outputs.ApprovalConfigResponse',
                 result: 'outputs.ApprovalResultResponse',
                 state: str):
        """
        BuildApproval describes a build's approval configuration, state, and result.
        :param 'ApprovalConfigResponse' config: Configuration for manual approval of this build.
        :param 'ApprovalResultResponse' result: Result of manual approval for this Build.
        :param str state: The state of this build's approval.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "result", result)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.ApprovalConfigResponse':
        """
        Configuration for manual approval of this build.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def result(self) -> 'outputs.ApprovalResultResponse':
        """
        Result of manual approval for this Build.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of this build's approval.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BuildOptionsResponse(dict):
    """
    Optional arguments to enable specific features of builds.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "dynamicSubstitutions":
            suggest = "dynamic_substitutions"
        elif key == "logStreamingOption":
            suggest = "log_streaming_option"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "requestedVerifyOption":
            suggest = "requested_verify_option"
        elif key == "secretEnv":
            suggest = "secret_env"
        elif key == "sourceProvenanceHash":
            suggest = "source_provenance_hash"
        elif key == "substitutionOption":
            suggest = "substitution_option"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: str,
                 dynamic_substitutions: bool,
                 env: Sequence[str],
                 log_streaming_option: str,
                 logging: str,
                 machine_type: str,
                 pool: 'outputs.PoolOptionResponse',
                 requested_verify_option: str,
                 secret_env: Sequence[str],
                 source_provenance_hash: Sequence[str],
                 substitution_option: str,
                 volumes: Sequence['outputs.VolumeResponse'],
                 worker_pool: str):
        """
        Optional arguments to enable specific features of builds.
        :param str disk_size_gb: Requested disk size for the VM that runs the build. Note that this is *NOT* "disk free"; some of the space will be used by the operating system and build utilities. Also note that this is the minimum disk size that will be allocated for the build -- the build may run with a larger disk than requested. At present, the maximum disk size is 1000GB; builds that request more than the maximum are rejected with an error.
        :param bool dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions. NOTE: this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param Sequence[str] env: A list of global environment variable definitions that will exist for all build steps in this build. If a variable is defined in both globally and in a build step, the variable will use the build step value. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param str log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage.
        :param str logging: Option to specify the logging mode, which determines if and where build logs are stored.
        :param str machine_type: Compute Engine machine type on which to run the build.
        :param 'PoolOptionResponse' pool: Optional. Specification for execution on a `WorkerPool`. See [running builds in a private pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool) for more information.
        :param str requested_verify_option: Requested verifiability options.
        :param Sequence[str] secret_env: A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`. These variables will be available to all build steps in this build.
        :param Sequence[str] source_provenance_hash: Requested hash for SourceProvenance.
        :param str substitution_option: Option to specify behavior when there is an error in the substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
        :param Sequence['VolumeResponse'] volumes: Global list of volumes to mount for ALL build steps Each volume is created as an empty volume prior to starting the build process. Upon completion of the build, volumes and their contents are discarded. Global volume names and paths cannot conflict with the volumes defined a build step. Using a global volume in a build with only one step is not valid as it is indicative of a build request with an incorrect configuration.
        :param str worker_pool: This field deprecated; please use `pool.name` instead.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        pulumi.set(__self__, "logging", logging)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "pool", pool)
        pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        pulumi.set(__self__, "secret_env", secret_env)
        pulumi.set(__self__, "source_provenance_hash", source_provenance_hash)
        pulumi.set(__self__, "substitution_option", substitution_option)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        Requested disk size for the VM that runs the build. Note that this is *NOT* "disk free"; some of the space will be used by the operating system and build utilities. Also note that this is the minimum disk size that will be allocated for the build -- the build may run with a larger disk than requested. At present, the maximum disk size is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> bool:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions. NOTE: this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        A list of global environment variable definitions that will exist for all build steps in this build. If a variable is defined in both globally and in a build step, the variable will use the build step value. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> str:
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        """
        return pulumi.get(self, "log_streaming_option")

    @property
    @pulumi.getter
    def logging(self) -> str:
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Compute Engine machine type on which to run the build.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def pool(self) -> 'outputs.PoolOptionResponse':
        """
        Optional. Specification for execution on a `WorkerPool`. See [running builds in a private pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool) for more information.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> str:
        """
        Requested verifiability options.
        """
        return pulumi.get(self, "requested_verify_option")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Sequence[str]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`. These variables will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_env")

    @property
    @pulumi.getter(name="sourceProvenanceHash")
    def source_provenance_hash(self) -> Sequence[str]:
        """
        Requested hash for SourceProvenance.
        """
        return pulumi.get(self, "source_provenance_hash")

    @property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> str:
        """
        Option to specify behavior when there is an error in the substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "substitution_option")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Global list of volumes to mount for ALL build steps Each volume is created as an empty volume prior to starting the build process. Upon completion of the build, volumes and their contents are discarded. Global volume names and paths cannot conflict with the volumes defined a build step. Using a global volume in a build with only one step is not valid as it is indicative of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> str:
        """
        This field deprecated; please use `pool.name` instead.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class BuildResponse(dict):
    """
    A build resource in the Cloud Build API. At a high level, a `Build` describes where to find source code, how to build it (for example, the builder image to run on the source), and where to store the built artifacts. Fields can include the following variables, which will be expanded when the build is created: - $PROJECT_ID: the project ID of the build. - $PROJECT_NUMBER: the project number of the build. - $LOCATION: the location/region of the build. - $BUILD_ID: the autogenerated ID of the build. - $REPO_NAME: the source repository name specified by RepoSource. - $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableSecrets":
            suggest = "available_secrets"
        elif key == "buildTriggerId":
            suggest = "build_trigger_id"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "failureInfo":
            suggest = "failure_info"
        elif key == "finishTime":
            suggest = "finish_time"
        elif key == "logUrl":
            suggest = "log_url"
        elif key == "logsBucket":
            suggest = "logs_bucket"
        elif key == "queueTtl":
            suggest = "queue_ttl"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "sourceProvenance":
            suggest = "source_provenance"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "statusDetail":
            suggest = "status_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval: 'outputs.BuildApprovalResponse',
                 artifacts: 'outputs.ArtifactsResponse',
                 available_secrets: 'outputs.SecretsResponse',
                 build_trigger_id: str,
                 create_time: str,
                 failure_info: 'outputs.FailureInfoResponse',
                 finish_time: str,
                 images: Sequence[str],
                 log_url: str,
                 logs_bucket: str,
                 name: str,
                 options: 'outputs.BuildOptionsResponse',
                 project: str,
                 queue_ttl: str,
                 results: 'outputs.ResultsResponse',
                 secrets: Sequence['outputs.SecretResponse'],
                 service_account: str,
                 source: 'outputs.SourceResponse',
                 source_provenance: 'outputs.SourceProvenanceResponse',
                 start_time: str,
                 status: str,
                 status_detail: str,
                 steps: Sequence['outputs.BuildStepResponse'],
                 substitutions: Mapping[str, str],
                 tags: Sequence[str],
                 timeout: str,
                 timing: Mapping[str, str],
                 warnings: Sequence['outputs.WarningResponse']):
        """
        A build resource in the Cloud Build API. At a high level, a `Build` describes where to find source code, how to build it (for example, the builder image to run on the source), and where to store the built artifacts. Fields can include the following variables, which will be expanded when the build is created: - $PROJECT_ID: the project ID of the build. - $PROJECT_NUMBER: the project number of the build. - $LOCATION: the location/region of the build. - $BUILD_ID: the autogenerated ID of the build. - $REPO_NAME: the source repository name specified by RepoSource. - $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
        :param 'BuildApprovalResponse' approval: Describes this build's approval configuration, status, and result.
        :param 'ArtifactsResponse' artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        :param 'SecretsResponse' available_secrets: Secrets and secret environment variables.
        :param str build_trigger_id: The ID of the `BuildTrigger` that triggered this build, if it was triggered automatically.
        :param str create_time: Time at which the request to create the build was received.
        :param 'FailureInfoResponse' failure_info: Contains information about the build when status=FAILURE.
        :param str finish_time: Time at which execution of the build was finished. The difference between finish_time and start_time is the duration of the build's execution.
        :param Sequence[str] images: A list of images to be pushed upon the successful completion of all build steps. The images are pushed using the builder service account's credentials. The digests of the pushed images will be stored in the `Build` resource's results field. If any of the images fail to be pushed, the build status is marked `FAILURE`.
        :param str log_url: URL to logs for this build in Google Cloud Console.
        :param str logs_bucket: Google Cloud Storage bucket where logs should be written (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
        :param str name: The 'Build' name with format: `projects/{project}/locations/{location}/builds/{build}`, where {build} is a unique identifier generated by the service.
        :param 'BuildOptionsResponse' options: Special options for this build.
        :param str project: ID of the project.
        :param str queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value, the build will expire and the build status will be `EXPIRED`. The TTL starts ticking from create_time.
        :param 'ResultsResponse' results: Results of the build.
        :param Sequence['SecretResponse'] secrets: Secrets to decrypt using Cloud Key Management Service. Note: Secret Manager is the recommended technique for managing sensitive data with Cloud Build. Use `available_secrets` to configure builds to access secrets from Secret Manager. For instructions, see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
        :param str service_account: IAM service account whose credentials will be used at build runtime. Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email address or uniqueId of the service account. 
        :param 'SourceResponse' source: The location of the source files to build.
        :param 'SourceProvenanceResponse' source_provenance: A permanent fixed identifier for source.
        :param str start_time: Time at which execution of the build was started.
        :param str status: Status of the build.
        :param str status_detail: Customer-readable message about the current status.
        :param Sequence['BuildStepResponse'] steps: The operations to be performed on the workspace.
        :param Mapping[str, str] substitutions: Substitutions data for `Build` resource.
        :param Sequence[str] tags: Tags for annotation of a `Build`. These are not docker tags.
        :param str timeout: Amount of time that this build should be allowed to run, to second granularity. If this amount of time elapses, work on the build will cease and the build status will be `TIMEOUT`. `timeout` starts ticking from `startTime`. Default time is ten minutes.
        :param Mapping[str, str] timing: Stores timing information for phases of the build. Valid keys are: * BUILD: time to execute all build steps. * PUSH: time to push all specified images. * FETCHSOURCE: time to fetch source. * SETUPBUILD: time to set up build. If the build does not specify source or images, these keys will not be included.
        :param Sequence['WarningResponse'] warnings: Non-fatal problems encountered during the execution of the build.
        """
        pulumi.set(__self__, "approval", approval)
        pulumi.set(__self__, "artifacts", artifacts)
        pulumi.set(__self__, "available_secrets", available_secrets)
        pulumi.set(__self__, "build_trigger_id", build_trigger_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "failure_info", failure_info)
        pulumi.set(__self__, "finish_time", finish_time)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "log_url", log_url)
        pulumi.set(__self__, "logs_bucket", logs_bucket)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "queue_ttl", queue_ttl)
        pulumi.set(__self__, "results", results)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_provenance", source_provenance)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_detail", status_detail)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "substitutions", substitutions)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "timing", timing)
        pulumi.set(__self__, "warnings", warnings)

    @property
    @pulumi.getter
    def approval(self) -> 'outputs.BuildApprovalResponse':
        """
        Describes this build's approval configuration, status, and result.
        """
        return pulumi.get(self, "approval")

    @property
    @pulumi.getter
    def artifacts(self) -> 'outputs.ArtifactsResponse':
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="availableSecrets")
    def available_secrets(self) -> 'outputs.SecretsResponse':
        """
        Secrets and secret environment variables.
        """
        return pulumi.get(self, "available_secrets")

    @property
    @pulumi.getter(name="buildTriggerId")
    def build_trigger_id(self) -> str:
        """
        The ID of the `BuildTrigger` that triggered this build, if it was triggered automatically.
        """
        return pulumi.get(self, "build_trigger_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the request to create the build was received.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="failureInfo")
    def failure_info(self) -> 'outputs.FailureInfoResponse':
        """
        Contains information about the build when status=FAILURE.
        """
        return pulumi.get(self, "failure_info")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> str:
        """
        Time at which execution of the build was finished. The difference between finish_time and start_time is the duration of the build's execution.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter
    def images(self) -> Sequence[str]:
        """
        A list of images to be pushed upon the successful completion of all build steps. The images are pushed using the builder service account's credentials. The digests of the pushed images will be stored in the `Build` resource's results field. If any of the images fail to be pushed, the build status is marked `FAILURE`.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="logUrl")
    def log_url(self) -> str:
        """
        URL to logs for this build in Google Cloud Console.
        """
        return pulumi.get(self, "log_url")

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> str:
        """
        Google Cloud Storage bucket where logs should be written (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
        """
        return pulumi.get(self, "logs_bucket")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The 'Build' name with format: `projects/{project}/locations/{location}/builds/{build}`, where {build} is a unique identifier generated by the service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> 'outputs.BuildOptionsResponse':
        """
        Special options for this build.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> str:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value, the build will expire and the build status will be `EXPIRED`. The TTL starts ticking from create_time.
        """
        return pulumi.get(self, "queue_ttl")

    @property
    @pulumi.getter
    def results(self) -> 'outputs.ResultsResponse':
        """
        Results of the build.
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.SecretResponse']:
        """
        Secrets to decrypt using Cloud Key Management Service. Note: Secret Manager is the recommended technique for managing sensitive data with Cloud Build. Use `available_secrets` to configure builds to access secrets from Secret Manager. For instructions, see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        IAM service account whose credentials will be used at build runtime. Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email address or uniqueId of the service account. 
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.SourceResponse':
        """
        The location of the source files to build.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> 'outputs.SourceProvenanceResponse':
        """
        A permanent fixed identifier for source.
        """
        return pulumi.get(self, "source_provenance")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the build.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetail")
    def status_detail(self) -> str:
        """
        Customer-readable message about the current status.
        """
        return pulumi.get(self, "status_detail")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.BuildStepResponse']:
        """
        The operations to be performed on the workspace.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def substitutions(self) -> Mapping[str, str]:
        """
        Substitutions data for `Build` resource.
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Tags for annotation of a `Build`. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Amount of time that this build should be allowed to run, to second granularity. If this amount of time elapses, work on the build will cease and the build status will be `TIMEOUT`. `timeout` starts ticking from `startTime`. Default time is ten minutes.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def timing(self) -> Mapping[str, str]:
        """
        Stores timing information for phases of the build. Valid keys are: * BUILD: time to execute all build steps. * PUSH: time to push all specified images. * FETCHSOURCE: time to fetch source. * SETUPBUILD: time to set up build. If the build does not specify source or images, these keys will not be included.
        """
        return pulumi.get(self, "timing")

    @property
    @pulumi.getter
    def warnings(self) -> Sequence['outputs.WarningResponse']:
        """
        Non-fatal problems encountered during the execution of the build.
        """
        return pulumi.get(self, "warnings")


@pulumi.output_type
class BuildStepResponse(dict):
    """
    A step in the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowExitCodes":
            suggest = "allow_exit_codes"
        elif key == "allowFailure":
            suggest = "allow_failure"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "pullTiming":
            suggest = "pull_timing"
        elif key == "secretEnv":
            suggest = "secret_env"
        elif key == "waitFor":
            suggest = "wait_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_exit_codes: Sequence[int],
                 allow_failure: bool,
                 args: Sequence[str],
                 dir: str,
                 entrypoint: str,
                 env: Sequence[str],
                 exit_code: int,
                 name: str,
                 pull_timing: 'outputs.TimeSpanResponse',
                 script: str,
                 secret_env: Sequence[str],
                 status: str,
                 timeout: str,
                 timing: 'outputs.TimeSpanResponse',
                 volumes: Sequence['outputs.VolumeResponse'],
                 wait_for: Sequence[str]):
        """
        A step in the build pipeline.
        :param Sequence[int] allow_exit_codes: Allow this build step to fail without failing the entire build if and only if the exit code is one of the specified codes. If allow_failure is also specified, this field will take precedence.
        :param bool allow_failure: Allow this build step to fail without failing the entire build. If false, the entire build will fail if this step fails. Otherwise, the build will succeed, but this step will still have a failure status. Error information will be reported in the failure_detail field.
        :param Sequence[str] args: A list of arguments that will be presented to the step when it is started. If the image used to run the step's container has an entrypoint, the `args` are used as arguments to that entrypoint. If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as arguments.
        :param str dir: Working directory to use when running this step's container. If this value is a relative path, it is relative to the build's working directory. If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted across build step executions, unless a `volume` for that path is specified. If the build specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies an absolute path, the `RepoSource` `dir` is ignored for the step's execution.
        :param str entrypoint: Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
        :param Sequence[str] env: A list of environment variable definitions to be used when running a step. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param int exit_code: Return code from running the step.
        :param str name: The name of the container image that will run this particular build step. If the image is available in the host's Docker daemon's cache, it will be run directly. If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary. The Docker daemon's cache will already have the latest versions of all of the officially supported build steps ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at the time you attempt to use them. If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name for a later build step.
        :param 'TimeSpanResponse' pull_timing: Stores timing information for pulling this build step's builder image only.
        :param str script: A shell script to be executed in the step. When script is provided, the user cannot specify the entrypoint or args.
        :param Sequence[str] secret_env: A list of environment variables which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`.
        :param str status: Status of the build step. At this time, build step status is only updated on build completion; step status is not updated in real-time as the build progresses.
        :param str timeout: Time limit for executing this build step. If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
        :param 'TimeSpanResponse' timing: Stores timing information for executing this build step.
        :param Sequence['VolumeResponse'] volumes: List of volumes to mount into the build step. Each volume is created as an empty volume prior to execution of the build step. Upon completion of the build, volumes and their contents are discarded. Using a named volume in only one step is not valid as it is indicative of a build request with an incorrect configuration.
        :param Sequence[str] wait_for: The ID(s) of the step(s) that this build step depends on. This build step will not start until all the build steps in `wait_for` have completed successfully. If `wait_for` is empty, this build step will start when all previous build steps in the `Build.Steps` list have completed successfully.
        """
        pulumi.set(__self__, "allow_exit_codes", allow_exit_codes)
        pulumi.set(__self__, "allow_failure", allow_failure)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "entrypoint", entrypoint)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "exit_code", exit_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pull_timing", pull_timing)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "secret_env", secret_env)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "timing", timing)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter(name="allowExitCodes")
    def allow_exit_codes(self) -> Sequence[int]:
        """
        Allow this build step to fail without failing the entire build if and only if the exit code is one of the specified codes. If allow_failure is also specified, this field will take precedence.
        """
        return pulumi.get(self, "allow_exit_codes")

    @property
    @pulumi.getter(name="allowFailure")
    def allow_failure(self) -> bool:
        """
        Allow this build step to fail without failing the entire build. If false, the entire build will fail if this step fails. Otherwise, the build will succeed, but this step will still have a failure status. Error information will be reported in the failure_detail field.
        """
        return pulumi.get(self, "allow_failure")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        A list of arguments that will be presented to the step when it is started. If the image used to run the step's container has an entrypoint, the `args` are used as arguments to that entrypoint. If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Working directory to use when running this step's container. If this value is a relative path, it is relative to the build's working directory. If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted across build step executions, unless a `volume` for that path is specified. If the build specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies an absolute path, the `RepoSource` `dir` is ignored for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def entrypoint(self) -> str:
        """
        Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        A list of environment variable definitions to be used when running a step. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> int:
        """
        Return code from running the step.
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the container image that will run this particular build step. If the image is available in the host's Docker daemon's cache, it will be run directly. If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary. The Docker daemon's cache will already have the latest versions of all of the officially supported build steps ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at the time you attempt to use them. If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name for a later build step.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pullTiming")
    def pull_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pulling this build step's builder image only.
        """
        return pulumi.get(self, "pull_timing")

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        A shell script to be executed in the step. When script is provided, the user cannot specify the entrypoint or args.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Sequence[str]:
        """
        A list of environment variables which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`.
        """
        return pulumi.get(self, "secret_env")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the build step. At this time, build step status is only updated on build completion; step status is not updated in real-time as the build progresses.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Time limit for executing this build step. If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for executing this build step.
        """
        return pulumi.get(self, "timing")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        List of volumes to mount into the build step. Each volume is created as an empty volume prior to execution of the build step. Upon completion of the build, volumes and their contents are discarded. Using a named volume in only one step is not valid as it is indicative of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Sequence[str]:
        """
        The ID(s) of the step(s) that this build step depends on. This build step will not start until all the build steps in `wait_for` have completed successfully. If `wait_for` is empty, this build step will start when all previous build steps in the `Build.Steps` list have completed successfully.
        """
        return pulumi.get(self, "wait_for")


@pulumi.output_type
class BuiltImageResponse(dict):
    """
    An image built by the pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pushTiming":
            suggest = "push_timing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuiltImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuiltImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuiltImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digest: str,
                 name: str,
                 push_timing: 'outputs.TimeSpanResponse'):
        """
        An image built by the pipeline.
        :param str digest: Docker Registry 2.0 digest.
        :param str name: Name used to push the container image to Google Container Registry, as presented to `docker push`.
        :param 'TimeSpanResponse' push_timing: Stores timing information for pushing the specified image.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "push_timing", push_timing)

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        Docker Registry 2.0 digest.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name used to push the container image to Google Container Registry, as presented to `docker push`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pushTiming")
    def push_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pushing the specified image.
        """
        return pulumi.get(self, "push_timing")


@pulumi.output_type
class FailureInfoResponse(dict):
    """
    A fatal problem encountered during the execution of the build.
    """
    def __init__(__self__, *,
                 detail: str,
                 type: str):
        """
        A fatal problem encountered during the execution of the build.
        :param str detail: Explains the failure issue in more detail using hard-coded text.
        :param str type: The name of the failure.
        """
        pulumi.set(__self__, "detail", detail)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def detail(self) -> str:
        """
        Explains the failure issue in more detail using hard-coded text.
        """
        return pulumi.get(self, "detail")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The name of the failure.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FileHashesResponse(dict):
    """
    Container message for hashes of byte content of files, used in SourceProvenance messages to verify integrity of source input to the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileHash":
            suggest = "file_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileHashesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileHashesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileHashesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_hash: Sequence['outputs.HashResponse']):
        """
        Container message for hashes of byte content of files, used in SourceProvenance messages to verify integrity of source input to the build.
        :param Sequence['HashResponse'] file_hash: Collection of file hashes.
        """
        pulumi.set(__self__, "file_hash", file_hash)

    @property
    @pulumi.getter(name="fileHash")
    def file_hash(self) -> Sequence['outputs.HashResponse']:
        """
        Collection of file hashes.
        """
        return pulumi.get(self, "file_hash")


@pulumi.output_type
class GitFileSourceResponse(dict):
    """
    GitFileSource describes a file within a (possibly remote) code repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitbucketServerConfig":
            suggest = "bitbucket_server_config"
        elif key == "githubEnterpriseConfig":
            suggest = "github_enterprise_config"
        elif key == "repoType":
            suggest = "repo_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitFileSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitFileSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitFileSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitbucket_server_config: str,
                 github_enterprise_config: str,
                 path: str,
                 repo_type: str,
                 revision: str,
                 uri: str):
        """
        GitFileSource describes a file within a (possibly remote) code repository.
        :param str bitbucket_server_config: The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        :param str github_enterprise_config: The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        :param str path: The path of the file, with the repo root as the root of the path.
        :param str repo_type: See RepoType above.
        :param str revision: The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        :param str uri: The URI of the repo. Either uri or repository can be specified. If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> str:
        """
        The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> str:
        """
        The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        """
        return pulumi.get(self, "github_enterprise_config")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the file, with the repo root as the root of the path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        See RepoType above.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI of the repo. Either uri or repository can be specified. If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GitHubEnterpriseSecretsResponse(dict):
    """
    GitHubEnterpriseSecrets represents the names of all necessary secrets in Secret Manager for a GitHub Enterprise server. Format is: projects//secrets/.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oauthClientIdName":
            suggest = "oauth_client_id_name"
        elif key == "oauthClientIdVersionName":
            suggest = "oauth_client_id_version_name"
        elif key == "oauthSecretName":
            suggest = "oauth_secret_name"
        elif key == "oauthSecretVersionName":
            suggest = "oauth_secret_version_name"
        elif key == "privateKeyName":
            suggest = "private_key_name"
        elif key == "privateKeyVersionName":
            suggest = "private_key_version_name"
        elif key == "webhookSecretName":
            suggest = "webhook_secret_name"
        elif key == "webhookSecretVersionName":
            suggest = "webhook_secret_version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitHubEnterpriseSecretsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitHubEnterpriseSecretsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitHubEnterpriseSecretsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oauth_client_id_name: str,
                 oauth_client_id_version_name: str,
                 oauth_secret_name: str,
                 oauth_secret_version_name: str,
                 private_key_name: str,
                 private_key_version_name: str,
                 webhook_secret_name: str,
                 webhook_secret_version_name: str):
        """
        GitHubEnterpriseSecrets represents the names of all necessary secrets in Secret Manager for a GitHub Enterprise server. Format is: projects//secrets/.
        :param str oauth_client_id_name: The resource name for the OAuth client ID secret in Secret Manager.
        :param str oauth_client_id_version_name: The resource name for the OAuth client ID secret version in Secret Manager.
        :param str oauth_secret_name: The resource name for the OAuth secret in Secret Manager.
        :param str oauth_secret_version_name: The resource name for the OAuth secret secret version in Secret Manager.
        :param str private_key_name: The resource name for the private key secret.
        :param str private_key_version_name: The resource name for the private key secret version.
        :param str webhook_secret_name: The resource name for the webhook secret in Secret Manager.
        :param str webhook_secret_version_name: The resource name for the webhook secret secret version in Secret Manager.
        """
        pulumi.set(__self__, "oauth_client_id_name", oauth_client_id_name)
        pulumi.set(__self__, "oauth_client_id_version_name", oauth_client_id_version_name)
        pulumi.set(__self__, "oauth_secret_name", oauth_secret_name)
        pulumi.set(__self__, "oauth_secret_version_name", oauth_secret_version_name)
        pulumi.set(__self__, "private_key_name", private_key_name)
        pulumi.set(__self__, "private_key_version_name", private_key_version_name)
        pulumi.set(__self__, "webhook_secret_name", webhook_secret_name)
        pulumi.set(__self__, "webhook_secret_version_name", webhook_secret_version_name)

    @property
    @pulumi.getter(name="oauthClientIdName")
    def oauth_client_id_name(self) -> str:
        """
        The resource name for the OAuth client ID secret in Secret Manager.
        """
        return pulumi.get(self, "oauth_client_id_name")

    @property
    @pulumi.getter(name="oauthClientIdVersionName")
    def oauth_client_id_version_name(self) -> str:
        """
        The resource name for the OAuth client ID secret version in Secret Manager.
        """
        return pulumi.get(self, "oauth_client_id_version_name")

    @property
    @pulumi.getter(name="oauthSecretName")
    def oauth_secret_name(self) -> str:
        """
        The resource name for the OAuth secret in Secret Manager.
        """
        return pulumi.get(self, "oauth_secret_name")

    @property
    @pulumi.getter(name="oauthSecretVersionName")
    def oauth_secret_version_name(self) -> str:
        """
        The resource name for the OAuth secret secret version in Secret Manager.
        """
        return pulumi.get(self, "oauth_secret_version_name")

    @property
    @pulumi.getter(name="privateKeyName")
    def private_key_name(self) -> str:
        """
        The resource name for the private key secret.
        """
        return pulumi.get(self, "private_key_name")

    @property
    @pulumi.getter(name="privateKeyVersionName")
    def private_key_version_name(self) -> str:
        """
        The resource name for the private key secret version.
        """
        return pulumi.get(self, "private_key_version_name")

    @property
    @pulumi.getter(name="webhookSecretName")
    def webhook_secret_name(self) -> str:
        """
        The resource name for the webhook secret in Secret Manager.
        """
        return pulumi.get(self, "webhook_secret_name")

    @property
    @pulumi.getter(name="webhookSecretVersionName")
    def webhook_secret_version_name(self) -> str:
        """
        The resource name for the webhook secret secret version in Secret Manager.
        """
        return pulumi.get(self, "webhook_secret_version_name")


@pulumi.output_type
class GitHubEventsConfigResponse(dict):
    """
    GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a GitHub event is received.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enterpriseConfigResourceName":
            suggest = "enterprise_config_resource_name"
        elif key == "installationId":
            suggest = "installation_id"
        elif key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitHubEventsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitHubEventsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitHubEventsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enterprise_config_resource_name: str,
                 installation_id: str,
                 name: str,
                 owner: str,
                 pull_request: 'outputs.PullRequestFilterResponse',
                 push: 'outputs.PushFilterResponse'):
        """
        GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a GitHub event is received.
        :param str enterprise_config_resource_name: Optional. The resource name of the github enterprise config that should be applied to this installation. For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        :param str installation_id: The installationID that emits the GitHub event.
        :param str name: Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        :param str owner: Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param 'PullRequestFilterResponse' pull_request: filter to match changes in pull requests.
        :param 'PushFilterResponse' push: filter to match changes in refs like branches, tags.
        """
        pulumi.set(__self__, "enterprise_config_resource_name", enterprise_config_resource_name)
        pulumi.set(__self__, "installation_id", installation_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "pull_request", pull_request)
        pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="enterpriseConfigResourceName")
    def enterprise_config_resource_name(self) -> str:
        """
        Optional. The resource name of the github enterprise config that should be applied to this installation. For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        """
        return pulumi.get(self, "enterprise_config_resource_name")

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> str:
        """
        The installationID that emits the GitHub event.
        """
        return pulumi.get(self, "installation_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> 'outputs.PullRequestFilterResponse':
        """
        filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_request")

    @property
    @pulumi.getter
    def push(self) -> 'outputs.PushFilterResponse':
        """
        filter to match changes in refs like branches, tags.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class GitLabConfigResponse(dict):
    """
    GitLabConfig represents the configuration for a GitLab integration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectedRepositories":
            suggest = "connected_repositories"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "enterpriseConfig":
            suggest = "enterprise_config"
        elif key == "webhookKey":
            suggest = "webhook_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitLabConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitLabConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitLabConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connected_repositories: Sequence['outputs.GitLabRepositoryIdResponse'],
                 create_time: str,
                 enterprise_config: 'outputs.GitLabEnterpriseConfigResponse',
                 name: str,
                 secrets: 'outputs.GitLabSecretsResponse',
                 username: str,
                 webhook_key: str):
        """
        GitLabConfig represents the configuration for a GitLab integration.
        :param Sequence['GitLabRepositoryIdResponse'] connected_repositories: Connected GitLab.com or GitLabEnterprise repositories for this config.
        :param str create_time: Time when the config was created.
        :param 'GitLabEnterpriseConfigResponse' enterprise_config: Optional. GitLabEnterprise config.
        :param str name: The resource name for the config.
        :param 'GitLabSecretsResponse' secrets: Secret Manager secrets needed by the config.
        :param str username: Username of the GitLab.com or GitLab Enterprise account Cloud Build will use.
        :param str webhook_key: UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        pulumi.set(__self__, "connected_repositories", connected_repositories)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "enterprise_config", enterprise_config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "webhook_key", webhook_key)

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> Sequence['outputs.GitLabRepositoryIdResponse']:
        """
        Connected GitLab.com or GitLabEnterprise repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when the config was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="enterpriseConfig")
    def enterprise_config(self) -> 'outputs.GitLabEnterpriseConfigResponse':
        """
        Optional. GitLabEnterprise config.
        """
        return pulumi.get(self, "enterprise_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secrets(self) -> 'outputs.GitLabSecretsResponse':
        """
        Secret Manager secrets needed by the config.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username of the GitLab.com or GitLab Enterprise account Cloud Build will use.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> str:
        """
        UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        return pulumi.get(self, "webhook_key")


@pulumi.output_type
class GitLabEnterpriseConfigResponse(dict):
    """
    GitLabEnterpriseConfig represents the configuration for a GitLabEnterprise integration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostUri":
            suggest = "host_uri"
        elif key == "serviceDirectoryConfig":
            suggest = "service_directory_config"
        elif key == "sslCa":
            suggest = "ssl_ca"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitLabEnterpriseConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitLabEnterpriseConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitLabEnterpriseConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_uri: str,
                 service_directory_config: 'outputs.ServiceDirectoryConfigResponse',
                 ssl_ca: str):
        """
        GitLabEnterpriseConfig represents the configuration for a GitLabEnterprise integration.
        :param str host_uri: Immutable. The URI of the GitlabEnterprise host.
        :param 'ServiceDirectoryConfigResponse' service_directory_config: The Service Directory configuration to be used when reaching out to the GitLab Enterprise instance.
        :param str ssl_ca: The SSL certificate to use in requests to GitLab Enterprise instances.
        """
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "service_directory_config", service_directory_config)
        pulumi.set(__self__, "ssl_ca", ssl_ca)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> str:
        """
        Immutable. The URI of the GitlabEnterprise host.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> 'outputs.ServiceDirectoryConfigResponse':
        """
        The Service Directory configuration to be used when reaching out to the GitLab Enterprise instance.
        """
        return pulumi.get(self, "service_directory_config")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> str:
        """
        The SSL certificate to use in requests to GitLab Enterprise instances.
        """
        return pulumi.get(self, "ssl_ca")


@pulumi.output_type
class GitLabEventsConfigResponse(dict):
    """
    GitLabEventsConfig describes the configuration of a trigger that creates a build whenever a GitLab event is received.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gitlabConfig":
            suggest = "gitlab_config"
        elif key == "gitlabConfigResource":
            suggest = "gitlab_config_resource"
        elif key == "projectNamespace":
            suggest = "project_namespace"
        elif key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitLabEventsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitLabEventsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitLabEventsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gitlab_config: 'outputs.GitLabConfigResponse',
                 gitlab_config_resource: str,
                 project_namespace: str,
                 pull_request: 'outputs.PullRequestFilterResponse',
                 push: 'outputs.PushFilterResponse'):
        """
        GitLabEventsConfig describes the configuration of a trigger that creates a build whenever a GitLab event is received.
        :param 'GitLabConfigResponse' gitlab_config: The GitLabConfig specified in the gitlab_config_resource field.
        :param str gitlab_config_resource: The GitLab config resource that this trigger config maps to.
        :param str project_namespace: Namespace of the GitLab project.
        :param 'PullRequestFilterResponse' pull_request: Filter to match changes in pull requests.
        :param 'PushFilterResponse' push: Filter to match changes in refs like branches, tags.
        """
        pulumi.set(__self__, "gitlab_config", gitlab_config)
        pulumi.set(__self__, "gitlab_config_resource", gitlab_config_resource)
        pulumi.set(__self__, "project_namespace", project_namespace)
        pulumi.set(__self__, "pull_request", pull_request)
        pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="gitlabConfig")
    def gitlab_config(self) -> 'outputs.GitLabConfigResponse':
        """
        The GitLabConfig specified in the gitlab_config_resource field.
        """
        return pulumi.get(self, "gitlab_config")

    @property
    @pulumi.getter(name="gitlabConfigResource")
    def gitlab_config_resource(self) -> str:
        """
        The GitLab config resource that this trigger config maps to.
        """
        return pulumi.get(self, "gitlab_config_resource")

    @property
    @pulumi.getter(name="projectNamespace")
    def project_namespace(self) -> str:
        """
        Namespace of the GitLab project.
        """
        return pulumi.get(self, "project_namespace")

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> 'outputs.PullRequestFilterResponse':
        """
        Filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_request")

    @property
    @pulumi.getter
    def push(self) -> 'outputs.PushFilterResponse':
        """
        Filter to match changes in refs like branches, tags.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class GitLabRepositoryIdResponse(dict):
    """
    GitLabRepositoryId identifies a specific repository hosted on GitLab.com or GitLabEnterprise
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webhookId":
            suggest = "webhook_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitLabRepositoryIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitLabRepositoryIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitLabRepositoryIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 webhook_id: int):
        """
        GitLabRepositoryId identifies a specific repository hosted on GitLab.com or GitLabEnterprise
        :param int webhook_id: The ID of the webhook that was created for receiving events from this repo. We only create and manage a single webhook for each repo.
        """
        pulumi.set(__self__, "webhook_id", webhook_id)

    @property
    @pulumi.getter(name="webhookId")
    def webhook_id(self) -> int:
        """
        The ID of the webhook that was created for receiving events from this repo. We only create and manage a single webhook for each repo.
        """
        return pulumi.get(self, "webhook_id")


@pulumi.output_type
class GitLabSecretsResponse(dict):
    """
    GitLabSecrets represents the secrets in Secret Manager for a GitLab integration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiAccessTokenVersion":
            suggest = "api_access_token_version"
        elif key == "apiKeyVersion":
            suggest = "api_key_version"
        elif key == "readAccessTokenVersion":
            suggest = "read_access_token_version"
        elif key == "webhookSecretVersion":
            suggest = "webhook_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitLabSecretsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitLabSecretsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitLabSecretsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_access_token_version: str,
                 api_key_version: str,
                 read_access_token_version: str,
                 webhook_secret_version: str):
        """
        GitLabSecrets represents the secrets in Secret Manager for a GitLab integration.
        :param str api_access_token_version: The resource name for the api access token’s secret version
        :param str api_key_version: Immutable. API Key that will be attached to webhook requests from GitLab to Cloud Build.
        :param str read_access_token_version: The resource name for the read access token’s secret version
        :param str webhook_secret_version: Immutable. The resource name for the webhook secret’s secret version. Once this field has been set, it cannot be changed. If you need to change it, please create another GitLabConfig.
        """
        pulumi.set(__self__, "api_access_token_version", api_access_token_version)
        pulumi.set(__self__, "api_key_version", api_key_version)
        pulumi.set(__self__, "read_access_token_version", read_access_token_version)
        pulumi.set(__self__, "webhook_secret_version", webhook_secret_version)

    @property
    @pulumi.getter(name="apiAccessTokenVersion")
    def api_access_token_version(self) -> str:
        """
        The resource name for the api access token’s secret version
        """
        return pulumi.get(self, "api_access_token_version")

    @property
    @pulumi.getter(name="apiKeyVersion")
    def api_key_version(self) -> str:
        """
        Immutable. API Key that will be attached to webhook requests from GitLab to Cloud Build.
        """
        return pulumi.get(self, "api_key_version")

    @property
    @pulumi.getter(name="readAccessTokenVersion")
    def read_access_token_version(self) -> str:
        """
        The resource name for the read access token’s secret version
        """
        return pulumi.get(self, "read_access_token_version")

    @property
    @pulumi.getter(name="webhookSecretVersion")
    def webhook_secret_version(self) -> str:
        """
        Immutable. The resource name for the webhook secret’s secret version. Once this field has been set, it cannot be changed. If you need to change it, please create another GitLabConfig.
        """
        return pulumi.get(self, "webhook_secret_version")


@pulumi.output_type
class GitRepoSourceResponse(dict):
    """
    GitRepoSource describes a repo and ref of a code repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitbucketServerConfig":
            suggest = "bitbucket_server_config"
        elif key == "githubEnterpriseConfig":
            suggest = "github_enterprise_config"
        elif key == "repoType":
            suggest = "repo_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitRepoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitRepoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitRepoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitbucket_server_config: str,
                 github_enterprise_config: str,
                 ref: str,
                 repo_type: str,
                 uri: str):
        """
        GitRepoSource describes a repo and ref of a code repository.
        :param str bitbucket_server_config: The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        :param str github_enterprise_config: The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        :param str ref: The branch or tag to use. Must start with "refs/" (required).
        :param str repo_type: See RepoType below.
        :param str uri: The URI of the repo. Either uri or repository can be specified and is required.
        """
        pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        pulumi.set(__self__, "ref", ref)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> str:
        """
        The full resource name of the bitbucket server config. Format: `projects/{project}/locations/{location}/bitbucketServerConfigs/{id}`.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> str:
        """
        The full resource name of the github enterprise config. Format: `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`. `projects/{project}/githubEnterpriseConfigs/{id}`.
        """
        return pulumi.get(self, "github_enterprise_config")

    @property
    @pulumi.getter
    def ref(self) -> str:
        """
        The branch or tag to use. Must start with "refs/" (required).
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        See RepoType below.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI of the repo. Either uri or repository can be specified and is required.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class HashResponse(dict):
    """
    Container message for hash values.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        Container message for hash values.
        :param str type: The type of hash that was performed.
        :param str value: The hash value.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of hash that was performed.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The hash value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InlineSecretResponse(dict):
    """
    Pairs a set of secret environment variables mapped to encrypted values with the Cloud KMS key to use to decrypt the value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envMap":
            suggest = "env_map"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InlineSecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InlineSecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InlineSecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env_map: Mapping[str, str],
                 kms_key_name: str):
        """
        Pairs a set of secret environment variables mapped to encrypted values with the Cloud KMS key to use to decrypt the value.
        :param Mapping[str, str] env_map: Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        :param str kms_key_name: Resource name of Cloud KMS crypto key to decrypt the encrypted value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        pulumi.set(__self__, "env_map", env_map)
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="envMap")
    def env_map(self) -> Mapping[str, str]:
        """
        Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "env_map")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Resource name of Cloud KMS crypto key to decrypt the encrypted value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class MavenArtifactResponse(dict):
    """
    A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"
        elif key == "groupId":
            suggest = "group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MavenArtifactResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MavenArtifactResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MavenArtifactResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 group_id: str,
                 path: str,
                 repository: str,
                 version: str):
        """
        A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
        :param str artifact_id: Maven `artifactId` value used when uploading the artifact to Artifact Registry.
        :param str group_id: Maven `groupId` value used when uploading the artifact to Artifact Registry.
        :param str path: Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        :param str repository: Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY" Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        :param str version: Maven `version` value used when uploading the artifact to Artifact Registry.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        Maven `artifactId` value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        Maven `groupId` value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY" Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Maven `version` value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NetworkConfigResponse(dict):
    """
    Defines the network configuration for the pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressOption":
            suggest = "egress_option"
        elif key == "peeredNetwork":
            suggest = "peered_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_option: str,
                 peered_network: str):
        """
        Defines the network configuration for the pool.
        :param str egress_option: Option to configure network egress for the workers.
        :param str peered_network: Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See [Understanding network configuration options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
        """
        pulumi.set(__self__, "egress_option", egress_option)
        pulumi.set(__self__, "peered_network", peered_network)

    @property
    @pulumi.getter(name="egressOption")
    def egress_option(self) -> str:
        """
        Option to configure network egress for the workers.
        """
        return pulumi.get(self, "egress_option")

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> str:
        """
        Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See [Understanding network configuration options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
        """
        return pulumi.get(self, "peered_network")


@pulumi.output_type
class PoolOptionResponse(dict):
    """
    Details about how a build should be executed on a `WorkerPool`. See [running builds in a private pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool) for more information.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Details about how a build should be executed on a `WorkerPool`. See [running builds in a private pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool) for more information.
        :param str name: The `WorkerPool` resource to execute the build on. You must have `cloudbuild.workerpools.use` on the project hosting the WorkerPool. Format projects/{project}/locations/{location}/workerPools/{workerPoolId}
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The `WorkerPool` resource to execute the build on. You must have `cloudbuild.workerpools.use` on the project hosting the WorkerPool. Format projects/{project}/locations/{location}/workerPools/{workerPoolId}
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PrivatePoolV1ConfigResponse(dict):
    """
    Configuration for a V1 `PrivatePool`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkConfig":
            suggest = "network_config"
        elif key == "workerConfig":
            suggest = "worker_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivatePoolV1ConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivatePoolV1ConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivatePoolV1ConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_config: 'outputs.NetworkConfigResponse',
                 worker_config: 'outputs.WorkerConfigResponse'):
        """
        Configuration for a V1 `PrivatePool`.
        :param 'NetworkConfigResponse' network_config: Network configuration for the pool.
        :param 'WorkerConfigResponse' worker_config: Machine configuration for the workers in the pool.
        """
        pulumi.set(__self__, "network_config", network_config)
        pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> 'outputs.NetworkConfigResponse':
        """
        Network configuration for the pool.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> 'outputs.WorkerConfigResponse':
        """
        Machine configuration for the workers in the pool.
        """
        return pulumi.get(self, "worker_config")


@pulumi.output_type
class PubsubConfigResponse(dict):
    """
    PubsubConfig describes the configuration of a trigger that creates a build whenever a Pub/Sub message is published.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PubsubConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PubsubConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PubsubConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_email: str,
                 state: str,
                 subscription: str,
                 topic: str):
        """
        PubsubConfig describes the configuration of a trigger that creates a build whenever a Pub/Sub message is published.
        :param str service_account_email: Service account that will make the push request.
        :param str state: Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        :param str subscription: Name of the subscription. Format is `projects/{project}/subscriptions/{subscription}`.
        :param str topic: The name of the topic from which this subscription is receiving messages. Format is `projects/{project}/topics/{topic}`.
        """
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscription", subscription)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        Service account that will make the push request.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subscription(self) -> str:
        """
        Name of the subscription. Format is `projects/{project}/subscriptions/{subscription}`.
        """
        return pulumi.get(self, "subscription")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The name of the topic from which this subscription is receiving messages. Format is `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class PullRequestFilterResponse(dict):
    """
    PullRequestFilter contains filter properties for matching GitHub Pull Requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentControl":
            suggest = "comment_control"
        elif key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PullRequestFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PullRequestFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PullRequestFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: str,
                 comment_control: str,
                 invert_regex: bool):
        """
        PullRequestFilter contains filter properties for matching GitHub Pull Requests.
        :param str branch: Regex of branches to match. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param str comment_control: Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        :param bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "comment_control", comment_control)
        pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        Regex of branches to match. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> str:
        """
        Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        """
        return pulumi.get(self, "comment_control")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> bool:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class PushFilterResponse(dict):
    """
    Push contains filter properties for matching GitHub git pushes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PushFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PushFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PushFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: str,
                 invert_regex: bool,
                 tag: str):
        """
        Push contains filter properties for matching GitHub git pushes.
        :param str branch: Regexes matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param bool invert_regex: When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param str tag: Regexes matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        Regexes matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> bool:
        """
        When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Regexes matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class PythonPackageResponse(dict):
    """
    Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
    """
    def __init__(__self__, *,
                 paths: Sequence[str],
                 repository: str):
        """
        Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
        :param Sequence[str] paths: Path globs used to match files in the build's workspace. For Python/ Twine, this is usually `dist/*`, and sometimes additionally an `.asc` file.
        :param str repository: Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY" Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Path globs used to match files in the build's workspace. For Python/ Twine, this is usually `dist/*`, and sometimes additionally an `.asc` file.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY" Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class RepoSourceResponse(dict):
    """
    Location of the source in a Google Cloud Source Repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: str,
                 commit_sha: str,
                 dir: str,
                 invert_regex: bool,
                 project: str,
                 repo_name: str,
                 substitutions: Mapping[str, str],
                 tag_name: str):
        """
        Location of the source in a Google Cloud Source Repository.
        :param str branch_name: Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param str commit_sha: Explicit commit SHA to build.
        :param str dir: Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str project: ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        :param str repo_name: Name of the Cloud Source Repository.
        :param Mapping[str, str] substitutions: Substitutions to use in a triggered build. Should only be used with RunBuildTrigger
        :param str tag_name: Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "substitutions", substitutions)
        pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> str:
        """
        Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> str:
        """
        Explicit commit SHA to build.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> bool:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter
    def substitutions(self) -> Mapping[str, str]:
        """
        Substitutions to use in a triggered build. Should only be used with RunBuildTrigger
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> str:
        """
        Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class ResultsResponse(dict):
    """
    Artifacts created by the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactManifest":
            suggest = "artifact_manifest"
        elif key == "artifactTiming":
            suggest = "artifact_timing"
        elif key == "buildStepImages":
            suggest = "build_step_images"
        elif key == "buildStepOutputs":
            suggest = "build_step_outputs"
        elif key == "mavenArtifacts":
            suggest = "maven_artifacts"
        elif key == "numArtifacts":
            suggest = "num_artifacts"
        elif key == "pythonPackages":
            suggest = "python_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResultsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResultsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResultsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_manifest: str,
                 artifact_timing: 'outputs.TimeSpanResponse',
                 build_step_images: Sequence[str],
                 build_step_outputs: Sequence[str],
                 images: Sequence['outputs.BuiltImageResponse'],
                 maven_artifacts: Sequence['outputs.UploadedMavenArtifactResponse'],
                 num_artifacts: str,
                 python_packages: Sequence['outputs.UploadedPythonPackageResponse']):
        """
        Artifacts created by the build pipeline.
        :param str artifact_manifest: Path to the artifact manifest. Only populated when artifacts are uploaded.
        :param 'TimeSpanResponse' artifact_timing: Time to push all non-container artifacts.
        :param Sequence[str] build_step_images: List of build step digests, in the order corresponding to build step indices.
        :param Sequence[str] build_step_outputs: List of build step outputs, produced by builder images, in the order corresponding to build step indices. [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders) can produce this output by writing to `$BUILDER_OUTPUT/output`. Only the first 4KB of data is stored.
        :param Sequence['BuiltImageResponse'] images: Container images that were built as a part of the build.
        :param Sequence['UploadedMavenArtifactResponse'] maven_artifacts: Maven artifacts uploaded to Artifact Registry at the end of the build.
        :param str num_artifacts: Number of artifacts uploaded. Only populated when artifacts are uploaded.
        :param Sequence['UploadedPythonPackageResponse'] python_packages: Python artifacts uploaded to Artifact Registry at the end of the build.
        """
        pulumi.set(__self__, "artifact_manifest", artifact_manifest)
        pulumi.set(__self__, "artifact_timing", artifact_timing)
        pulumi.set(__self__, "build_step_images", build_step_images)
        pulumi.set(__self__, "build_step_outputs", build_step_outputs)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "maven_artifacts", maven_artifacts)
        pulumi.set(__self__, "num_artifacts", num_artifacts)
        pulumi.set(__self__, "python_packages", python_packages)

    @property
    @pulumi.getter(name="artifactManifest")
    def artifact_manifest(self) -> str:
        """
        Path to the artifact manifest. Only populated when artifacts are uploaded.
        """
        return pulumi.get(self, "artifact_manifest")

    @property
    @pulumi.getter(name="artifactTiming")
    def artifact_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Time to push all non-container artifacts.
        """
        return pulumi.get(self, "artifact_timing")

    @property
    @pulumi.getter(name="buildStepImages")
    def build_step_images(self) -> Sequence[str]:
        """
        List of build step digests, in the order corresponding to build step indices.
        """
        return pulumi.get(self, "build_step_images")

    @property
    @pulumi.getter(name="buildStepOutputs")
    def build_step_outputs(self) -> Sequence[str]:
        """
        List of build step outputs, produced by builder images, in the order corresponding to build step indices. [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders) can produce this output by writing to `$BUILDER_OUTPUT/output`. Only the first 4KB of data is stored.
        """
        return pulumi.get(self, "build_step_outputs")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.BuiltImageResponse']:
        """
        Container images that were built as a part of the build.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="mavenArtifacts")
    def maven_artifacts(self) -> Sequence['outputs.UploadedMavenArtifactResponse']:
        """
        Maven artifacts uploaded to Artifact Registry at the end of the build.
        """
        return pulumi.get(self, "maven_artifacts")

    @property
    @pulumi.getter(name="numArtifacts")
    def num_artifacts(self) -> str:
        """
        Number of artifacts uploaded. Only populated when artifacts are uploaded.
        """
        return pulumi.get(self, "num_artifacts")

    @property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Sequence['outputs.UploadedPythonPackageResponse']:
        """
        Python artifacts uploaded to Artifact Registry at the end of the build.
        """
        return pulumi.get(self, "python_packages")


@pulumi.output_type
class SecretManagerSecretResponse(dict):
    """
    Pairs a secret environment variable with a SecretVersion in Secret Manager.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionName":
            suggest = "version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretManagerSecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretManagerSecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretManagerSecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env: str,
                 version_name: str):
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        :param str env: Environment variable name to associate with the secret. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
        :param str version_name: Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def env(self) -> str:
        """
        Environment variable name to associate with the secret. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class SecretResponse(dict):
    """
    Pairs a set of secret environment variables containing encrypted values with the Cloud KMS key to use to decrypt the value. Note: Use `kmsKeyName` with `available_secrets` instead of using `kmsKeyName` with `secret`. For instructions see: https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "secretEnv":
            suggest = "secret_env"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 secret_env: Mapping[str, str]):
        """
        Pairs a set of secret environment variables containing encrypted values with the Cloud KMS key to use to decrypt the value. Note: Use `kmsKeyName` with `available_secrets` instead of using `kmsKeyName` with `secret`. For instructions see: https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
        :param str kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param Mapping[str, str] secret_env: Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "secret_env", secret_env)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Mapping[str, str]:
        """
        Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "secret_env")


@pulumi.output_type
class SecretsResponse(dict):
    """
    Secrets and secret environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretManager":
            suggest = "secret_manager"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inline: Sequence['outputs.InlineSecretResponse'],
                 secret_manager: Sequence['outputs.SecretManagerSecretResponse']):
        """
        Secrets and secret environment variables.
        :param Sequence['InlineSecretResponse'] inline: Secrets encrypted with KMS key and the associated secret environment variable.
        :param Sequence['SecretManagerSecretResponse'] secret_manager: Secrets in Secret Manager and associated secret environment variable.
        """
        pulumi.set(__self__, "inline", inline)
        pulumi.set(__self__, "secret_manager", secret_manager)

    @property
    @pulumi.getter
    def inline(self) -> Sequence['outputs.InlineSecretResponse']:
        """
        Secrets encrypted with KMS key and the associated secret environment variable.
        """
        return pulumi.get(self, "inline")

    @property
    @pulumi.getter(name="secretManager")
    def secret_manager(self) -> Sequence['outputs.SecretManagerSecretResponse']:
        """
        Secrets in Secret Manager and associated secret environment variable.
        """
        return pulumi.get(self, "secret_manager")


@pulumi.output_type
class ServiceDirectoryConfigResponse(dict):
    """
    ServiceDirectoryConfig represents Service Directory configuration for a SCM host connection.
    """
    def __init__(__self__, *,
                 service: str):
        """
        ServiceDirectoryConfig represents Service Directory configuration for a SCM host connection.
        :param str service: The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class SourceProvenanceResponse(dict):
    """
    Provenance of the source. Ways to find the original source, or verify that some source was used for this build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileHashes":
            suggest = "file_hashes"
        elif key == "resolvedRepoSource":
            suggest = "resolved_repo_source"
        elif key == "resolvedStorageSource":
            suggest = "resolved_storage_source"
        elif key == "resolvedStorageSourceManifest":
            suggest = "resolved_storage_source_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_hashes: Mapping[str, str],
                 resolved_repo_source: 'outputs.RepoSourceResponse',
                 resolved_storage_source: 'outputs.StorageSourceResponse',
                 resolved_storage_source_manifest: 'outputs.StorageSourceManifestResponse'):
        """
        Provenance of the source. Ways to find the original source, or verify that some source was used for this build.
        :param Mapping[str, str] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. Note that `FileHashes` will only be populated if `BuildOptions` has requested a `SourceProvenanceHash`. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path to that file.
        :param 'RepoSourceResponse' resolved_repo_source: A copy of the build's `source.repo_source`, if exists, with any revisions resolved.
        :param 'StorageSourceResponse' resolved_storage_source: A copy of the build's `source.storage_source`, if exists, with any generations resolved.
        :param 'StorageSourceManifestResponse' resolved_storage_source_manifest: A copy of the build's `source.storage_source_manifest`, if exists, with any revisions resolved. This feature is in Preview.
        """
        pulumi.set(__self__, "file_hashes", file_hashes)
        pulumi.set(__self__, "resolved_repo_source", resolved_repo_source)
        pulumi.set(__self__, "resolved_storage_source", resolved_storage_source)
        pulumi.set(__self__, "resolved_storage_source_manifest", resolved_storage_source_manifest)

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Mapping[str, str]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. Note that `FileHashes` will only be populated if `BuildOptions` has requested a `SourceProvenanceHash`. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")

    @property
    @pulumi.getter(name="resolvedRepoSource")
    def resolved_repo_source(self) -> 'outputs.RepoSourceResponse':
        """
        A copy of the build's `source.repo_source`, if exists, with any revisions resolved.
        """
        return pulumi.get(self, "resolved_repo_source")

    @property
    @pulumi.getter(name="resolvedStorageSource")
    def resolved_storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        A copy of the build's `source.storage_source`, if exists, with any generations resolved.
        """
        return pulumi.get(self, "resolved_storage_source")

    @property
    @pulumi.getter(name="resolvedStorageSourceManifest")
    def resolved_storage_source_manifest(self) -> 'outputs.StorageSourceManifestResponse':
        """
        A copy of the build's `source.storage_source_manifest`, if exists, with any revisions resolved. This feature is in Preview.
        """
        return pulumi.get(self, "resolved_storage_source_manifest")


@pulumi.output_type
class SourceResponse(dict):
    """
    Location of the source in a supported storage service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"
        elif key == "storageSourceManifest":
            suggest = "storage_source_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_source: 'outputs.RepoSourceResponse',
                 storage_source: 'outputs.StorageSourceResponse',
                 storage_source_manifest: 'outputs.StorageSourceManifestResponse'):
        """
        Location of the source in a supported storage service.
        :param 'RepoSourceResponse' repo_source: If provided, get the source from this location in a Cloud Source Repository.
        :param 'StorageSourceResponse' storage_source: If provided, get the source from this location in Google Cloud Storage.
        :param 'StorageSourceManifestResponse' storage_source_manifest: If provided, get the source from this manifest in Google Cloud Storage. This feature is in Preview; see description [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        """
        pulumi.set(__self__, "repo_source", repo_source)
        pulumi.set(__self__, "storage_source", storage_source)
        pulumi.set(__self__, "storage_source_manifest", storage_source_manifest)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> 'outputs.RepoSourceResponse':
        """
        If provided, get the source from this location in a Cloud Source Repository.
        """
        return pulumi.get(self, "repo_source")

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        If provided, get the source from this location in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_source")

    @property
    @pulumi.getter(name="storageSourceManifest")
    def storage_source_manifest(self) -> 'outputs.StorageSourceManifestResponse':
        """
        If provided, get the source from this manifest in Google Cloud Storage. This feature is in Preview; see description [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        """
        return pulumi.get(self, "storage_source_manifest")


@pulumi.output_type
class StorageSourceManifestResponse(dict):
    """
    Location of the source manifest in Google Cloud Storage. This feature is in Preview; see description [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        Location of the source manifest in Google Cloud Storage. This feature is in Preview; see description [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        :param str bucket: Google Cloud Storage bucket containing the source manifest (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param str generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        :param str object: Google Cloud Storage object containing the source manifest. This object must be a JSON file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing the source manifest (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing the source manifest. This object must be a JSON file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class StorageSourceResponse(dict):
    """
    Location of the source in an archive file in Google Cloud Storage.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        Location of the source in an archive file in Google Cloud Storage.
        :param str bucket: Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param str generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        :param str object: Google Cloud Storage object containing the source. This object must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`) containing source to build.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing the source. This object must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`) containing source to build.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class TimeSpanResponse(dict):
    """
    Start and end times for a build execution phase.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeSpanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeSpanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeSpanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 start_time: str):
        """
        Start and end times for a build execution phase.
        :param str end_time: End of time span.
        :param str start_time: Start of time span.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        End of time span.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start of time span.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class UploadedMavenArtifactResponse(dict):
    """
    A Maven artifact uploaded using the MavenArtifact directive.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileHashes":
            suggest = "file_hashes"
        elif key == "pushTiming":
            suggest = "push_timing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UploadedMavenArtifactResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UploadedMavenArtifactResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UploadedMavenArtifactResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_hashes: 'outputs.FileHashesResponse',
                 push_timing: 'outputs.TimeSpanResponse',
                 uri: str):
        """
        A Maven artifact uploaded using the MavenArtifact directive.
        :param 'FileHashesResponse' file_hashes: Hash types and values of the Maven Artifact.
        :param 'TimeSpanResponse' push_timing: Stores timing information for pushing the specified artifact.
        :param str uri: URI of the uploaded artifact.
        """
        pulumi.set(__self__, "file_hashes", file_hashes)
        pulumi.set(__self__, "push_timing", push_timing)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> 'outputs.FileHashesResponse':
        """
        Hash types and values of the Maven Artifact.
        """
        return pulumi.get(self, "file_hashes")

    @property
    @pulumi.getter(name="pushTiming")
    def push_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pushing the specified artifact.
        """
        return pulumi.get(self, "push_timing")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of the uploaded artifact.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class UploadedPythonPackageResponse(dict):
    """
    Artifact uploaded using the PythonPackage directive.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileHashes":
            suggest = "file_hashes"
        elif key == "pushTiming":
            suggest = "push_timing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UploadedPythonPackageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UploadedPythonPackageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UploadedPythonPackageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_hashes: 'outputs.FileHashesResponse',
                 push_timing: 'outputs.TimeSpanResponse',
                 uri: str):
        """
        Artifact uploaded using the PythonPackage directive.
        :param 'FileHashesResponse' file_hashes: Hash types and values of the Python Artifact.
        :param 'TimeSpanResponse' push_timing: Stores timing information for pushing the specified artifact.
        :param str uri: URI of the uploaded artifact.
        """
        pulumi.set(__self__, "file_hashes", file_hashes)
        pulumi.set(__self__, "push_timing", push_timing)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> 'outputs.FileHashesResponse':
        """
        Hash types and values of the Python Artifact.
        """
        return pulumi.get(self, "file_hashes")

    @property
    @pulumi.getter(name="pushTiming")
    def push_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pushing the specified artifact.
        """
        return pulumi.get(self, "push_timing")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of the uploaded artifact.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume describes a Docker container volume which is mounted into build steps in order to persist files across build step execution.
    """
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        Volume describes a Docker container volume which is mounted into build steps in order to persist files across build step execution.
        :param str name: Name of the volume to mount. Volume names must be unique per build step and must be valid names for Docker volumes. Each named volume must be used by at least two build steps.
        :param str path: Path at which to mount the volume. Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume to mount. Volume names must be unique per build step and must be valid names for Docker volumes. Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path at which to mount the volume. Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WarningResponse(dict):
    """
    A non-fatal problem encountered during the execution of the build.
    """
    def __init__(__self__, *,
                 priority: str,
                 text: str):
        """
        A non-fatal problem encountered during the execution of the build.
        :param str priority: The priority for this warning.
        :param str text: Explanation of the warning generated.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def priority(self) -> str:
        """
        The priority for this warning.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Explanation of the warning generated.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class WebhookConfigResponse(dict):
    """
    WebhookConfig describes the configuration of a trigger that creates a build whenever a webhook is sent to a trigger's webhook URL.
    """
    def __init__(__self__, *,
                 secret: str,
                 state: str):
        """
        WebhookConfig describes the configuration of a trigger that creates a build whenever a webhook is sent to a trigger's webhook URL.
        :param str secret: Resource name for the secret required as a URL parameter.
        :param str state: Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        Resource name for the secret required as a URL parameter.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class WorkerConfigResponse(dict):
    """
    Defines the configuration to be used for creating workers in the pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: str,
                 machine_type: str):
        """
        Defines the configuration to be used for creating workers in the pool.
        :param str disk_size_gb: Size of the disk attached to the worker, in GB. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        :param str machine_type: Machine type of a worker, such as `e2-medium`. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). If left blank, Cloud Build will use a sensible default.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        Size of the disk attached to the worker, in GB. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Machine type of a worker, such as `e2-medium`. See [Worker pool config file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema). If left blank, Cloud Build will use a sensible default.
        """
        return pulumi.get(self, "machine_type")


