# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitLabConfigArgs', 'GitLabConfig']

@pulumi.input_type
class GitLabConfigArgs:
    def __init__(__self__, *,
                 secrets: pulumi.Input['GitLabSecretsArgs'],
                 connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input['GitLabRepositoryIdArgs']]]] = None,
                 enterprise_config: Optional[pulumi.Input['GitLabEnterpriseConfigArgs']] = None,
                 gitlab_config_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GitLabConfig resource.
        :param pulumi.Input['GitLabSecretsArgs'] secrets: Secret Manager secrets needed by the config.
        :param pulumi.Input[Sequence[pulumi.Input['GitLabRepositoryIdArgs']]] connected_repositories: Connected GitLab.com or GitLabEnterprise repositories for this config.
        :param pulumi.Input['GitLabEnterpriseConfigArgs'] enterprise_config: Optional. GitLabEnterprise config.
        :param pulumi.Input[str] gitlab_config_id: Optional. The ID to use for the GitLabConfig, which will become the final component of the GitLabConfig’s resource name. gitlab_config_id must meet the following requirements: + They must contain only alphanumeric characters and dashes. + They can be 1-64 characters long. + They must begin and end with an alphanumeric character
        :param pulumi.Input[str] name: The resource name for the config.
        :param pulumi.Input[str] username: Username of the GitLab.com or GitLab Enterprise account Cloud Build will use.
        """
        pulumi.set(__self__, "secrets", secrets)
        if connected_repositories is not None:
            pulumi.set(__self__, "connected_repositories", connected_repositories)
        if enterprise_config is not None:
            pulumi.set(__self__, "enterprise_config", enterprise_config)
        if gitlab_config_id is not None:
            pulumi.set(__self__, "gitlab_config_id", gitlab_config_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['GitLabSecretsArgs']:
        """
        Secret Manager secrets needed by the config.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['GitLabSecretsArgs']):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitLabRepositoryIdArgs']]]]:
        """
        Connected GitLab.com or GitLabEnterprise repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @connected_repositories.setter
    def connected_repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitLabRepositoryIdArgs']]]]):
        pulumi.set(self, "connected_repositories", value)

    @property
    @pulumi.getter(name="enterpriseConfig")
    def enterprise_config(self) -> Optional[pulumi.Input['GitLabEnterpriseConfigArgs']]:
        """
        Optional. GitLabEnterprise config.
        """
        return pulumi.get(self, "enterprise_config")

    @enterprise_config.setter
    def enterprise_config(self, value: Optional[pulumi.Input['GitLabEnterpriseConfigArgs']]):
        pulumi.set(self, "enterprise_config", value)

    @property
    @pulumi.getter(name="gitlabConfigId")
    def gitlab_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The ID to use for the GitLabConfig, which will become the final component of the GitLabConfig’s resource name. gitlab_config_id must meet the following requirements: + They must contain only alphanumeric characters and dashes. + They can be 1-64 characters long. + They must begin and end with an alphanumeric character
        """
        return pulumi.get(self, "gitlab_config_id")

    @gitlab_config_id.setter
    def gitlab_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gitlab_config_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the GitLab.com or GitLab Enterprise account Cloud Build will use.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class GitLabConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitLabRepositoryIdArgs']]]]] = None,
                 enterprise_config: Optional[pulumi.Input[pulumi.InputType['GitLabEnterpriseConfigArgs']]] = None,
                 gitlab_config_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[pulumi.InputType['GitLabSecretsArgs']]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new `GitLabConfig`. This API is experimental

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitLabRepositoryIdArgs']]]] connected_repositories: Connected GitLab.com or GitLabEnterprise repositories for this config.
        :param pulumi.Input[pulumi.InputType['GitLabEnterpriseConfigArgs']] enterprise_config: Optional. GitLabEnterprise config.
        :param pulumi.Input[str] gitlab_config_id: Optional. The ID to use for the GitLabConfig, which will become the final component of the GitLabConfig’s resource name. gitlab_config_id must meet the following requirements: + They must contain only alphanumeric characters and dashes. + They can be 1-64 characters long. + They must begin and end with an alphanumeric character
        :param pulumi.Input[str] name: The resource name for the config.
        :param pulumi.Input[pulumi.InputType['GitLabSecretsArgs']] secrets: Secret Manager secrets needed by the config.
        :param pulumi.Input[str] username: Username of the GitLab.com or GitLab Enterprise account Cloud Build will use.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitLabConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new `GitLabConfig`. This API is experimental

        :param str resource_name: The name of the resource.
        :param GitLabConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitLabConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connected_repositories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GitLabRepositoryIdArgs']]]]] = None,
                 enterprise_config: Optional[pulumi.Input[pulumi.InputType['GitLabEnterpriseConfigArgs']]] = None,
                 gitlab_config_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[pulumi.InputType['GitLabSecretsArgs']]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitLabConfigArgs.__new__(GitLabConfigArgs)

            __props__.__dict__["connected_repositories"] = connected_repositories
            __props__.__dict__["enterprise_config"] = enterprise_config
            __props__.__dict__["gitlab_config_id"] = gitlab_config_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if secrets is None and not opts.urn:
                raise TypeError("Missing required property 'secrets'")
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["username"] = username
            __props__.__dict__["create_time"] = None
            __props__.__dict__["webhook_key"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(GitLabConfig, __self__).__init__(
            'google-native:cloudbuild/v1:GitLabConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GitLabConfig':
        """
        Get an existing GitLabConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GitLabConfigArgs.__new__(GitLabConfigArgs)

        __props__.__dict__["connected_repositories"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["enterprise_config"] = None
        __props__.__dict__["gitlab_config_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["secrets"] = None
        __props__.__dict__["username"] = None
        __props__.__dict__["webhook_key"] = None
        return GitLabConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> pulumi.Output[Sequence['outputs.GitLabRepositoryIdResponse']]:
        """
        Connected GitLab.com or GitLabEnterprise repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the config was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="enterpriseConfig")
    def enterprise_config(self) -> pulumi.Output['outputs.GitLabEnterpriseConfigResponse']:
        """
        Optional. GitLabEnterprise config.
        """
        return pulumi.get(self, "enterprise_config")

    @property
    @pulumi.getter(name="gitlabConfigId")
    def gitlab_config_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. The ID to use for the GitLabConfig, which will become the final component of the GitLabConfig’s resource name. gitlab_config_id must meet the following requirements: + They must contain only alphanumeric characters and dashes. + They can be 1-64 characters long. + They must begin and end with an alphanumeric character
        """
        return pulumi.get(self, "gitlab_config_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Output['outputs.GitLabSecretsResponse']:
        """
        Secret Manager secrets needed by the config.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username of the GitLab.com or GitLab Enterprise account Cloud Build will use.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> pulumi.Output[str]:
        """
        UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        return pulumi.get(self, "webhook_key")

