# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetNetConnectionResult',
    'AwaitableGetNetConnectionResult',
    'get_net_connection',
    'get_net_connection_output',
]

@pulumi.output_type
class GetNetConnectionResult:
    def __init__(__self__, connectors=None, create_time=None, destination_cidrs=None, display_name=None, labels=None, name=None, network_vpc=None, state=None, uid=None, update_time=None):
        if connectors and not isinstance(connectors, list):
            raise TypeError("Expected argument 'connectors' to be a list")
        pulumi.set(__self__, "connectors", connectors)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if destination_cidrs and not isinstance(destination_cidrs, list):
            raise TypeError("Expected argument 'destination_cidrs' to be a list")
        pulumi.set(__self__, "destination_cidrs", destination_cidrs)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_vpc and not isinstance(network_vpc, str):
            raise TypeError("Expected argument 'network_vpc' to be a str")
        pulumi.set(__self__, "network_vpc", network_vpc)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def connectors(self) -> Sequence[str]:
        """
        Optional. List of [google.cloud.beyondcorp.v1main.AppConnector.name] that are authorized to be associated with this NetConnection. e.g. projects/{project}/locations/{location}/appConnectors/{app_connector}
        """
        return pulumi.get(self, "connectors")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="destinationCidrs")
    def destination_cidrs(self) -> Sequence[str]:
        """
        CIDRs for the remote networks to connect to. e.g. IPv4: 198.51.100.14/24 IPv6: 2001:db8::/48
        """
        return pulumi.get(self, "destination_cidrs")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. An arbitrary user-provided name for the NetConnection. Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Resource labels to represent user provided metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique resource name of the NetConnection. The name is ignored when creating a NetConnection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkVpc")
    def network_vpc(self) -> str:
        """
        The full name of the VPC network connected to the applications. Client Connector will send traffic here.
        """
        return pulumi.get(self, "network_vpc")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the NetConnection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A unique identifier for the instance generated by the system.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Timestamp when the resource was last modified.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetNetConnectionResult(GetNetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetConnectionResult(
            connectors=self.connectors,
            create_time=self.create_time,
            destination_cidrs=self.destination_cidrs,
            display_name=self.display_name,
            labels=self.labels,
            name=self.name,
            network_vpc=self.network_vpc,
            state=self.state,
            uid=self.uid,
            update_time=self.update_time)


def get_net_connection(location: Optional[str] = None,
                       net_connection_id: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetConnectionResult:
    """
    Gets details of a single NetConnection.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['netConnectionId'] = net_connection_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:beyondcorp/v1alpha:getNetConnection', __args__, opts=opts, typ=GetNetConnectionResult).value

    return AwaitableGetNetConnectionResult(
        connectors=__ret__.connectors,
        create_time=__ret__.create_time,
        destination_cidrs=__ret__.destination_cidrs,
        display_name=__ret__.display_name,
        labels=__ret__.labels,
        name=__ret__.name,
        network_vpc=__ret__.network_vpc,
        state=__ret__.state,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_net_connection)
def get_net_connection_output(location: Optional[pulumi.Input[str]] = None,
                              net_connection_id: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetConnectionResult]:
    """
    Gets details of a single NetConnection.
    """
    ...
